/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempletonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TempletonUtils.class);
    public static final Pattern JAR_COMPLETE = Pattern.compile(" map \\d+%\\s+reduce \\d+%$");
    public static final Pattern PIG_COMPLETE = Pattern.compile(" \\d+% complete$");
    public static final Pattern HIVE_COMPLETE = Pattern.compile(" map = (\\d+%),\\s+reduce = (\\d+%).*$");
    public static final Pattern HIVE_TEZ_COMPLETE = Pattern.compile("(Map|Reducer) (\\d+:) (\\d+(\\(\\+\\d+\\))?/\\d+)");
    public static final Pattern HIVE_BEELINE_COMPLETE = Pattern.compile("VERTICES: .* (\\d+%)");
    public static final Pattern PIG_TEZ_COMPLETE = Pattern.compile("progress=TotalTasks: (\\d+) Succeeded: (\\d+)");
    public static final Pattern TEZ_COUNTERS = Pattern.compile("\\d+");
    public static final Pattern JAR_ID = Pattern.compile(" Running job: (\\S+)$");
    public static final Pattern PIG_ID = Pattern.compile(" HadoopJobId: (\\S+)$");
    public static final Pattern[] ID_PATTERNS = new Pattern[]{JAR_ID, PIG_ID};

    public static boolean isset(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isset(char ch) {
        return ch != '\u0000';
    }

    public static <T> boolean isset(T[] a) {
        return a != null && a.length > 0;
    }

    public static <T> boolean isset(Collection<T> col) {
        return col != null && !col.isEmpty();
    }

    public static <K, V> boolean isset(Map<K, V> col) {
        return col != null && !col.isEmpty();
    }

    public static String extractPercentComplete(String line) {
        Matcher jar = JAR_COMPLETE.matcher(line);
        if (jar.find()) {
            return jar.group().trim();
        }
        Matcher pig = PIG_COMPLETE.matcher(line);
        if (pig.find()) {
            return pig.group().trim();
        }
        Matcher beeline = HIVE_BEELINE_COMPLETE.matcher(line);
        if (beeline.find()) {
            return beeline.group(1).trim() + " complete";
        }
        Matcher hive = HIVE_COMPLETE.matcher(line);
        if (hive.find()) {
            return "map " + hive.group(1) + " reduce " + hive.group(2);
        }
        Matcher hiveTez = HIVE_TEZ_COMPLETE.matcher(line);
        if (hiveTez.find()) {
            int totalTasks = 0;
            int completedTasks = 0;
            do {
                Matcher counts = TEZ_COUNTERS.matcher(hiveTez.group());
                ArrayList<String> items = new ArrayList<String>(4);
                while (counts.find()) {
                    items.add(counts.group());
                }
                completedTasks += Integer.parseInt((String)items.get(1));
                if (items.size() == 3) {
                    totalTasks += Integer.parseInt((String)items.get(2));
                    continue;
                }
                totalTasks += Integer.parseInt((String)items.get(3));
            } while (hiveTez.find());
            if (totalTasks == 0) {
                return "0% complete (0 total tasks)";
            }
            return completedTasks * 100 / totalTasks + "% complete";
        }
        Matcher pigTez = PIG_TEZ_COMPLETE.matcher(line);
        if (pigTez.find()) {
            int totalTasks = Integer.parseInt(pigTez.group(1));
            int completedTasks = Integer.parseInt(pigTez.group(2));
            if (totalTasks == 0) {
                return "0% complete (0 total tasks)";
            }
            return completedTasks * 100 / totalTasks + "% complete";
        }
        return null;
    }

    public static String extractChildJobId(String line) {
        for (Pattern p : ID_PATTERNS) {
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            return m.group(1);
        }
        return null;
    }

    public static String encodeArray(String[] plain) {
        if (plain == null) {
            return null;
        }
        String[] escaped = new String[plain.length];
        for (int i = 0; i < plain.length; ++i) {
            if (plain[i] == null) {
                plain[i] = "";
            }
            escaped[i] = StringUtils.escapeString((String)plain[i]);
        }
        return StringUtils.arrayToString((String[])escaped);
    }

    public static String encodeArray(List<String> list) {
        if (list == null) {
            return null;
        }
        String[] array = new String[list.size()];
        return TempletonUtils.encodeArray(list.toArray(array));
    }

    public static String[] decodeArray(String s) {
        if (s == null) {
            return null;
        }
        String[] escaped = StringUtils.split((String)s);
        String[] plain = new String[escaped.length];
        for (int i = 0; i < escaped.length; ++i) {
            plain[i] = StringUtils.unEscapeString((String)escaped[i]);
        }
        return plain;
    }

    public static String[] hadoopFsListAsArray(String files, Configuration conf, String user) throws URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        if (files == null || conf == null) {
            return null;
        }
        String[] dirty = files.split(",");
        String[] clean = new String[dirty.length];
        for (int i = 0; i < dirty.length; ++i) {
            clean[i] = TempletonUtils.hadoopFsFilename(dirty[i], conf, user);
        }
        return clean;
    }

    public static String hadoopFsListAsString(String files, Configuration conf, String user) throws URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        if (files == null || conf == null) {
            return null;
        }
        return StringUtils.arrayToString((String[])TempletonUtils.hadoopFsListAsArray(files, conf, user));
    }

    public static String hadoopFsFilename(String fname, Configuration conf, String user) throws URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        Path p = TempletonUtils.hadoopFsPath(fname, conf, user);
        if (p == null) {
            return null;
        }
        return p.toString();
    }

    public static List<Path> hadoopFsListChildren(String dirName, Configuration conf, String user) throws URISyntaxException, IOException, InterruptedException {
        Path p = TempletonUtils.hadoopFsPath(dirName, conf, user);
        FileSystem fs = p.getFileSystem(conf);
        if (!fs.exists(p)) {
            return Collections.emptyList();
        }
        FileStatus[] children = fs.listStatus(p);
        if (!TempletonUtils.isset(children)) {
            return Collections.emptyList();
        }
        ArrayList<Path> files = new ArrayList<Path>();
        for (FileStatus stat : children) {
            files.add(stat.getPath());
        }
        return files;
    }

    public static boolean hadoopFsIsMissing(FileSystem fs, Path p) {
        try {
            return !fs.exists(p);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String addUserHomeDirectoryIfApplicable(String origPathStr, String user) throws IOException, URISyntaxException {
        if (origPathStr == null || origPathStr.isEmpty()) {
            return "/user/" + user;
        }
        Path p = new Path(origPathStr);
        if (p.isAbsolute()) {
            return origPathStr;
        }
        if (p.toUri().getPath().isEmpty()) {
            return new Path(p.toUri().getScheme(), p.toUri().getAuthority(), "/user/" + user).toString();
        }
        return "/user/" + user + "/" + origPathStr;
    }

    public static Path hadoopFsPath(String fname, Configuration conf, String user) throws URISyntaxException, IOException, InterruptedException {
        URI u;
        Path p;
        String finalFName;
        if (fname == null || conf == null) {
            return null;
        }
        UserGroupInformation ugi = user != null ? UgiFactory.getUgi(user) : UserGroupInformation.getLoginUser();
        FileSystem defaultFs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(finalFName = new String(fname), conf){
            final /* synthetic */ String val$finalFName;
            final /* synthetic */ Configuration val$conf;
            {
                this.val$finalFName = string;
                this.val$conf = configuration;
            }

            @Override
            public FileSystem run() throws URISyntaxException, IOException, InterruptedException {
                return FileSystem.get((URI)new URI(this.val$finalFName), (Configuration)this.val$conf);
            }
        });
        if (TempletonUtils.hadoopFsIsMissing(defaultFs, p = new Path(u = new URI(fname = TempletonUtils.addUserHomeDirectoryIfApplicable(fname, user))).makeQualified(defaultFs))) {
            throw new FileNotFoundException("File " + fname + " does not exist.");
        }
        FileSystem.closeAllForUGI((UserGroupInformation)ugi);
        return p;
    }

    public static int fetchUrl(URL url) throws IOException {
        URLConnection cnx = url.openConnection();
        InputStream in = cnx.getInputStream();
        byte[] buf = new byte[8192];
        int total = 0;
        int len = 0;
        while ((len = in.read(buf)) >= 0) {
            total += len;
        }
        return total;
    }

    public static Map<String, String> hadoopUserEnv(String user, String overrideClasspath) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("HADOOP_USER_NAME", user);
        if (overrideClasspath != null) {
            env.put("HADOOP_USER_CLASSPATH_FIRST", "true");
            String cur = System.getenv("HADOOP_CLASSPATH");
            if (TempletonUtils.isset(cur)) {
                overrideClasspath = overrideClasspath + ":" + cur;
            }
            env.put("HADOOP_CLASSPATH", overrideClasspath);
        }
        return env;
    }

    public static String unEscapeString(String s) {
        return s != null && s.contains("\\,") ? StringUtils.unEscapeString((String)s) : s;
    }

    public static String findContainingJar(Class<?> clazz, String fileNamePattern) {
        ClassLoader loader = clazz.getClassLoader();
        String classFile = clazz.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(classFile);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (fileNamePattern != null && !toReturn.matches(fileNamePattern)) continue;
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static StringBuilder dumpPropMap(String header, Properties props) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> ent : props.entrySet()) {
            map.put(ent.getKey().toString(), ent.getValue() == null ? null : ent.getValue().toString());
        }
        return TempletonUtils.dumpPropMap(header, map);
    }

    public static StringBuilder dumpPropMap(String header, Map<String, String> map) {
        StringBuilder sb = new StringBuilder("START").append(header).append(":\n");
        ArrayList<String> propKeys = new ArrayList<String>(map.keySet());
        Collections.sort(propKeys);
        for (String propKey : propKeys) {
            if (propKey.toLowerCase().contains("path")) {
                StringTokenizer st = new StringTokenizer(map.get(propKey), File.pathSeparator);
                if (st.countTokens() > 1) {
                    sb.append(propKey).append("=\n");
                    while (st.hasMoreTokens()) {
                        sb.append("    ").append(st.nextToken()).append(File.pathSeparator).append('\n');
                    }
                    continue;
                }
                sb.append(propKey).append('=').append(map.get(propKey)).append('\n');
                continue;
            }
            sb.append(propKey).append('=').append(LogUtils.maskIfPassword((String)propKey, (String)map.get(propKey)));
            sb.append('\n');
        }
        return sb.append("END").append(header).append('\n');
    }
}

