/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.apache.hive.hcatalog.templeton.tool.JobSubmissionConstants;
import org.apache.hive.hcatalog.templeton.tool.LogRetriever;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.apache.hive.hcatalog.templeton.tool.TrivialExecService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LaunchMapper
extends Mapper<NullWritable, NullWritable, Text, Text>
implements JobSubmissionConstants {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchMapper.class);

    private static void handlePigEnvVars(Configuration conf, Map<String, String> env) {
        if (conf.get("HIVE_HOME") != null) {
            env.put("HIVE_HOME", new File(conf.get("HIVE_HOME")).getAbsolutePath());
        }
        if (conf.get("HCAT_HOME") != null) {
            env.put("HCAT_HOME", new File(conf.get("HCAT_HOME")).getAbsolutePath());
        }
        if (conf.get("PIG_OPTS") != null) {
            StringBuilder pigOpts = new StringBuilder();
            for (String prop : StringUtils.split((String)conf.get("PIG_OPTS"))) {
                pigOpts.append("-D").append(StringUtils.unEscapeString((String)prop)).append(" ");
            }
            env.put("PIG_OPTS", pigOpts.toString());
        }
    }

    private static void handleSqoop(Configuration conf, Map<String, String> env) throws IOException {
        if (TempletonUtils.isset(conf.get("templeton.sqoop.lib.jar"))) {
            LOG.debug("templeton.sqoop.lib.jar=" + conf.get("templeton.sqoop.lib.jar"));
            String[] files = conf.getStrings("templeton.sqoop.lib.jar");
            StringBuilder jdbcJars = new StringBuilder();
            for (String f : files) {
                jdbcJars.append(f).append(File.pathSeparator);
            }
            jdbcJars.setLength(jdbcJars.length() - 1);
            LaunchMapper.prependPathToVariable("HADOOP_CLASSPATH", env, jdbcJars.toString());
        }
    }

    private static void handleHadoopClasspathExtras(Configuration conf, Map<String, String> env) throws IOException {
        if (!TempletonUtils.isset(conf.get("templeton.hadoop.classpath.extras"))) {
            return;
        }
        LOG.debug("templeton.hadoop.classpath.extras=" + conf.get("templeton.hadoop.classpath.extras"));
        String[] files = conf.getStrings("templeton.hadoop.classpath.extras");
        StringBuilder paths = new StringBuilder();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        for (String f : files) {
            Path p = new Path(f);
            FileStatus fileStatus = fs.getFileStatus(p);
            paths.append(f);
            if (fileStatus.isDir()) {
                paths.append(File.separator).append("*");
            }
            paths.append(File.pathSeparator);
        }
        paths.setLength(paths.length() - 1);
        LaunchMapper.prependPathToVariable("HADOOP_CLASSPATH", env, paths.toString());
    }

    private static void prependPathToVariable(String pathVarName, Map<String, String> env, String paths) {
        if (!TempletonUtils.isset(pathVarName) || !TempletonUtils.isset(paths) || env == null) {
            return;
        }
        if (TempletonUtils.isset(env.get(pathVarName))) {
            env.put(pathVarName, paths + File.pathSeparator + env.get(pathVarName));
        } else if (TempletonUtils.isset(System.getenv(pathVarName))) {
            env.put(pathVarName, paths + File.pathSeparator + System.getenv(pathVarName));
        } else {
            env.put(pathVarName, paths);
        }
    }

    protected Process startJob(Mapper.Context context, String jobId, String user, String overrideClasspath, LauncherDelegator.JobType jobType) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.copyLocal("templeton.copy", conf);
        String[] jarArgs = TempletonUtils.decodeArray(conf.get("templeton.args"));
        ArrayList<String> removeEnv = new ArrayList<String>();
        removeEnv.add("HADOOP_ROOT_LOGGER");
        removeEnv.add("hadoop-command");
        removeEnv.add("CLASS");
        removeEnv.add("mapredcommand");
        Map<String, String> env = TempletonUtils.hadoopUserEnv(user, overrideClasspath);
        LaunchMapper.handlePigEnvVars(conf, env);
        LaunchMapper.handleSqoop(conf, env);
        LaunchMapper.handleHadoopClasspathExtras(conf, env);
        LinkedList<String> jarArgsList = new LinkedList<String>(Arrays.asList(jarArgs));
        LaunchMapper.handleTokenFile(jarArgsList, "__MR_JOB_CREDENTIALS_OPTION=WEBHCAT_TOKEN_FILE_LOCATION__", "mapreduce.job.credentials.binary");
        LaunchMapper.handleTokenFile(jarArgsList, "__TEZ_CREDENTIALS_OPTION=WEBHCAT_TOKEN_FILE_LOCATION_TEZ__", "tez.credentials.path");
        if (jobType == LauncherDelegator.JobType.HIVE) {
            Credentials cred = new Credentials();
            Token token = context.getCredentials().getToken(new Text("hive"));
            cred.addToken(new Text("hive"), token);
            File t = File.createTempFile("templeton", null);
            Path tokenPath = new Path(t.toURI());
            cred.writeTokenStorageFile(tokenPath, conf);
            env.put("HADOOP_TOKEN_FILE_LOCATION", tokenPath.toUri().getPath());
            LaunchMapper.replaceJobTag(jarArgsList, "__HIVE_QUERY_TAG_OPTION=HIVE_QUERY_TAG_JOBID__", "hive.query.tag", jobId);
        } else {
            LaunchMapper.replaceJobTag(jarArgsList, "__MR_JOB_TAGS_OPTION=MR_JOB_TAGS_JOBID__", "mapreduce.job.tags", jobId);
        }
        return TrivialExecService.getInstance().run(jarArgsList, removeEnv, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killLauncherChildJobs(Configuration conf, String jobId) throws IOException {
        long startTime = this.getTempletonLaunchTime(conf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        try (HadoopShims.WebHCatJTShim tracker = ShimLoader.getHadoopShims().getWebHCatShim(conf, ugi);){
            tracker.killJobs(jobId, startTime);
        }
    }

    private long getTempletonLaunchTime(Configuration conf) {
        long startTime = 0L;
        try {
            String launchTimeStr = conf.get("templeton.job.launch.time");
            LOG.info("Launch time = " + launchTimeStr);
            if (launchTimeStr != null && launchTimeStr.length() > 0) {
                startTime = Long.parseLong(launchTimeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Could not parse Templeton job launch time", nfe);
        }
        if (startTime == 0L) {
            throw new RuntimeException(String.format("Launch time property '%s' not found", "templeton.job.launch.time"));
        }
        return startTime;
    }

    private static void handleTokenFile(List<String> jarArgsList, String tokenPlaceHolder, String tokenProperty) throws IOException {
        String tokenFile = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (tokenFile != null) {
            tokenFile = tokenFile.replaceAll("\"", "");
            String tokenArg = tokenProperty + "=" + tokenFile;
            for (int i = 0; i < jarArgsList.size(); ++i) {
                String newArg = jarArgsList.get(i).replace(tokenPlaceHolder, tokenArg);
                jarArgsList.set(i, newArg);
            }
        } else {
            Iterator<String> it = jarArgsList.iterator();
            while (it.hasNext()) {
                String arg = it.next();
                if (!arg.contains(tokenPlaceHolder)) continue;
                it.remove();
            }
        }
    }

    private static void replaceJobTag(List<String> jarArgsList, String placeholder, String mapReduceJobTagsProp, String currentJobId) throws IOException {
        String arg = String.format("%s=%s", mapReduceJobTagsProp, currentJobId);
        for (int i = 0; i < jarArgsList.size(); ++i) {
            if (!jarArgsList.get(i).contains(placeholder)) continue;
            String newArg = jarArgsList.get(i).replace(placeholder, arg);
            jarArgsList.set(i, newArg);
            return;
        }
        throw new RuntimeException(String.format("Unexpected Error: Tag '%s' not found in the list of launcher args", placeholder));
    }

    private void copyLocal(String var, Configuration conf) throws IOException {
        String[] filenames = TempletonUtils.decodeArray(conf.get(var));
        if (filenames != null) {
            for (String filename : filenames) {
                Path src = new Path(filename);
                Path dst = new Path(src.getName());
                FileSystem fs = src.getFileSystem(conf);
                LOG.info("templeton: copy " + src + " => " + dst);
                fs.copyToLocalFile(src, dst);
            }
        }
    }

    private boolean reconnectToRunningJobEnabledAndSupported(Configuration conf, LauncherDelegator.JobType jobType) {
        if (conf.get("templeton.enablejobreconnect") == null) {
            return false;
        }
        Boolean enableJobReconnect = Boolean.parseBoolean(conf.get("templeton.enablejobreconnect"));
        if (!enableJobReconnect.booleanValue()) {
            return false;
        }
        return jobType.equals((Object)LauncherDelegator.JobType.JAR) || jobType.equals((Object)LauncherDelegator.JobType.STREAMING);
    }

    private boolean tryReconnectToRunningJob(Configuration conf, Mapper.Context context, LauncherDelegator.JobType jobType, String statusdir) throws IOException, InterruptedException {
        if (!this.reconnectToRunningJobEnabledAndSupported(conf, jobType)) {
            return false;
        }
        long startTime = this.getTempletonLaunchTime(conf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        try (HadoopShims.WebHCatJTShim tracker = ShimLoader.getHadoopShims().getWebHCatShim(conf, ugi);){
            int exitCode;
            Set childJobs = tracker.getJobs(context.getJobID().toString(), startTime);
            if (childJobs.size() == 0) {
                LOG.info("No child jobs found to reconnect with");
                boolean bl = false;
                return bl;
            }
            if (childJobs.size() > 1) {
                LOG.warn(String.format("Found more than one child job to reconnect with: %s, skipping reconnect", Arrays.toString(childJobs.toArray())));
                boolean bl = false;
                return bl;
            }
            String childJobIdString = (String)childJobs.iterator().next();
            JobID childJobId = JobID.forName((String)childJobIdString);
            LOG.info(String.format("Reconnecting to an existing job %s", childJobIdString));
            LaunchMapper.updateJobStatePercentAndChildId(conf, context.getJobID().toString(), null, childJobIdString);
            while (true) {
                JobStatus jobStatus;
                if ((jobStatus = tracker.getJobStatus(childJobId)).isJobComplete()) {
                    LOG.info(String.format("Child job %s completed", childJobIdString));
                    exitCode = 0;
                    if (jobStatus.getRunState() != JobStatus.SUCCEEDED) {
                        exitCode = 1;
                    }
                    break;
                }
                String percent = String.format("map %s%%, reduce %s%%", Float.valueOf(jobStatus.mapProgress() * 100.0f), Float.valueOf(jobStatus.reduceProgress() * 100.0f));
                LaunchMapper.updateJobStatePercentAndChildId(conf, context.getJobID().toString(), percent, null);
                LOG.info("KeepAlive Heart beat");
                context.progress();
                Thread.sleep(30000L);
            }
            this.updateJobStateToDoneAndWriteExitValue(conf, statusdir, context.getJobID().toString(), exitCode);
            boolean bl = true;
            return bl;
        }
    }

    public void run(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        LauncherDelegator.JobType jobType = LauncherDelegator.JobType.valueOf(conf.get("templeton.jobtype"));
        String statusdir = conf.get("templeton.statusdir");
        if (statusdir != null) {
            try {
                statusdir = TempletonUtils.addUserHomeDirectoryIfApplicable(statusdir, conf.get("user.name"));
            }
            catch (URISyntaxException e) {
                String msg = "Invalid status dir URI";
                LOG.error(msg, (Throwable)e);
                throw new IOException(msg, e);
            }
        }
        if (this.tryReconnectToRunningJob(conf, context, jobType, statusdir)) {
            return;
        }
        this.killLauncherChildJobs(conf, context.getJobID().toString());
        Process proc = this.startJob(context, context.getJobID().toString(), conf.get("user.name"), conf.get("templeton.override-classpath"), jobType);
        JobState state = new JobState(context.getJobID().toString(), conf);
        state.setJobType(jobType.toString());
        state.close();
        ExecutorService pool = Executors.newCachedThreadPool();
        this.executeWatcher(pool, conf, context.getJobID(), proc.getInputStream(), statusdir, "stdout");
        this.executeWatcher(pool, conf, context.getJobID(), proc.getErrorStream(), statusdir, "stderr");
        KeepAlive keepAlive = this.startCounterKeepAlive(pool, context);
        proc.waitFor();
        keepAlive.sendReport = false;
        pool.shutdown();
        if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
            pool.shutdownNow();
        }
        this.updateJobStateToDoneAndWriteExitValue(conf, statusdir, context.getJobID().toString(), proc.exitValue());
        Boolean enablelog = Boolean.parseBoolean(conf.get("templeton.enablelog"));
        if (enablelog.booleanValue() && TempletonUtils.isset(statusdir)) {
            LOG.info("templeton: collecting logs for " + context.getJobID().toString() + " to " + statusdir + "/logs");
            LogRetriever logRetriever = new LogRetriever(statusdir, jobType, conf);
            logRetriever.run();
        }
    }

    private void updateJobStateToDoneAndWriteExitValue(Configuration conf, String statusdir, String jobId, int exitCode) throws IOException {
        this.writeExitValue(conf, exitCode, statusdir);
        JobState state = new JobState(jobId, conf);
        state.setExitValue(exitCode);
        state.setCompleteStatus("done");
        state.close();
        if (exitCode != 0) {
            LOG.info("templeton: job failed with exit code " + exitCode);
        } else {
            LOG.info("templeton: job completed with exit code 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateJobStatePercentAndChildId(Configuration conf, String jobId, String percent, String childid) {
        JobState state = null;
        try {
            if (percent != null || childid != null) {
                state = new JobState(jobId, conf);
                if (percent != null) {
                    state.setPercentComplete(percent);
                }
                if (childid != null) {
                    JobState childState = new JobState(childid, conf);
                    childState.setParent(jobId);
                    state.addChild(childid);
                    state.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error("templeton: state error: ", (Throwable)e);
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                }
                catch (IOException e) {
                    LOG.warn("Caught exception while closing job state ", (Throwable)e);
                }
            }
        }
    }

    private void executeWatcher(ExecutorService pool, Configuration conf, org.apache.hadoop.mapreduce.JobID jobid, InputStream in, String statusdir, String name) throws IOException {
        Watcher w = new Watcher(conf, jobid, in, statusdir, name);
        pool.execute(w);
    }

    private KeepAlive startCounterKeepAlive(ExecutorService pool, Mapper.Context context) throws IOException {
        KeepAlive k = new KeepAlive(context);
        pool.execute(k);
        return k;
    }

    private void writeExitValue(Configuration conf, int exitValue, String statusdir) throws IOException {
        if (TempletonUtils.isset(statusdir)) {
            Path p = new Path(statusdir, "exit");
            FileSystem fs = p.getFileSystem(conf);
            FSDataOutputStream out = fs.create(p);
            LOG.info("templeton: Writing exit value " + exitValue + " to " + p);
            PrintWriter writer = new PrintWriter((OutputStream)out);
            writer.println(exitValue);
            writer.close();
            LOG.info("templeton: Exit value successfully written");
        }
    }

    private static class KeepAlive
    implements Runnable {
        private final Mapper.Context context;
        private volatile boolean sendReport = true;

        public KeepAlive(Mapper.Context context) {
            this.context = context;
        }

        private static StringBuilder makeDots(int count) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                sb.append('.');
            }
            return sb;
        }

        @Override
        public void run() {
            try {
                int count = 0;
                while (this.sendReport) {
                    this.context.progress();
                    String msg = "KeepAlive Heart beat" + KeepAlive.makeDots(++count);
                    LOG.info(msg);
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class Watcher
    implements Runnable {
        private final InputStream in;
        private OutputStream out;
        private final org.apache.hadoop.mapreduce.JobID jobid;
        private final Configuration conf;
        boolean needCloseOutput = false;

        public Watcher(Configuration conf, org.apache.hadoop.mapreduce.JobID jobid, InputStream in, String statusdir, String name) throws IOException {
            this.conf = conf;
            this.jobid = jobid;
            this.in = in;
            this.out = name.equals("stderr") ? System.err : System.out;
            if (TempletonUtils.isset(statusdir)) {
                Path p = new Path(statusdir, name);
                FileSystem fs = p.getFileSystem(conf);
                this.out = fs.create(p);
                this.needCloseOutput = true;
                LOG.info("templeton: Writing status to " + p);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PrintWriter writer = null;
            try {
                String line;
                String enc = this.conf.get("templeton.exec.encoding");
                InputStreamReader isr = new InputStreamReader(this.in, enc);
                BufferedReader reader = new BufferedReader(isr);
                writer = new PrintWriter(new OutputStreamWriter(this.out, enc));
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                    String percent = TempletonUtils.extractPercentComplete(line);
                    String childid = TempletonUtils.extractChildJobId(line);
                    LaunchMapper.updateJobStatePercentAndChildId(this.conf, this.jobid.toString(), percent, childid);
                }
                writer.flush();
                if (this.out != System.err && this.out != System.out) {
                    writer.close();
                }
            }
            catch (IOException e) {
                LOG.error("templeton: execute error: ", (Throwable)e);
            }
            finally {
                if (this.needCloseOutput && writer != null) {
                    writer.close();
                }
            }
        }
    }
}

