/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonBuilder {
    private static final Map<Object, Integer> hiveError2HttpStatusCode = new HashMap<Object, Integer>();
    private Map map;

    private JsonBuilder(String json) throws IOException {
        this.map = JsonBuilder.jsonToMap(json);
    }

    public static JsonBuilder create(String json) throws IOException {
        return new JsonBuilder(json);
    }

    public static JsonBuilder create() throws IOException {
        return new JsonBuilder(null);
    }

    public static JsonBuilder createError(String msg, int errorCode) throws IOException {
        return new JsonBuilder(null).put("error", msg).put("errorCode", errorCode);
    }

    public JsonBuilder put(String name, Object val) {
        if (val != null) {
            this.map.put(name, val);
        }
        return this;
    }

    public JsonBuilder remove(String name) {
        this.map.remove(name);
        return this;
    }

    public Map getMap() {
        return this.map;
    }

    public Response build() {
        return this.buildResponse();
    }

    public String buildJson() throws IOException {
        return JsonBuilder.mapToJson(this.map);
    }

    public Response buildResponse() {
        Object o;
        int status = 200;
        if (this.map.containsKey("error")) {
            status = 500;
        }
        if ((o = this.map.get("errorCode")) != null && hiveError2HttpStatusCode.containsKey(o)) {
            status = hiveError2HttpStatusCode.get(o);
        }
        return this.buildResponse(status);
    }

    public Response buildResponse(int status) {
        return Response.status((int)status).entity((Object)this.map).type("application/json").build();
    }

    public boolean isset() {
        return TempletonUtils.isset(this.map);
    }

    public static boolean isError(Map obj) {
        return obj != null && obj.containsKey("error");
    }

    public static Map jsonToMap(String json) throws IOException {
        if (!TempletonUtils.isset(json)) {
            return new HashMap();
        }
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(json, Map.class);
    }

    public static String mapToJson(Object obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)out, obj);
        return out.toString();
    }

    static {
        hiveError2HttpStatusCode.put(ErrorMsg.GENERIC_ERROR.getErrorCode(), 500);
        hiveError2HttpStatusCode.put(ErrorMsg.DATABASE_NOT_EXISTS.getErrorCode(), 404);
        hiveError2HttpStatusCode.put(ErrorMsg.INVALID_TABLE.getErrorCode(), 404);
        hiveError2HttpStatusCode.put(ErrorMsg.TABLE_NOT_PARTITIONED.getErrorCode(), 404);
        hiveError2HttpStatusCode.put(ErrorMsg.INVALID_PARTITION.getErrorCode(), 404);
        hiveError2HttpStatusCode.put(ErrorMsg.DUPLICATE_COLUMN_NAMES.getErrorCode(), 409);
        hiveError2HttpStatusCode.put(ErrorMsg.DATABASE_ALREADY_EXISTS.getErrorCode(), 409);
        hiveError2HttpStatusCode.put(ErrorMsg.PARTITION_EXISTS.getErrorCode(), 409);
        hiveError2HttpStatusCode.put(ErrorMsg.TABLE_ALREADY_EXISTS.getErrorCode(), 409);
    }
}

