/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.schematool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;
import org.apache.hive.beeline.BeeLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSchemaTool
extends MetastoreSchemaTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveSchemaTool.class.getName());

    protected HiveSchemaHelper.NestedScriptParser getDbCommandParser(String dbType, String metaDbType) {
        return HiveSchemaHelper.getDbCommandParser((String)dbType, (String)this.dbOpts, (String)this.userName, (String)this.passWord, (Configuration)this.conf, (String)metaDbType, (boolean)false);
    }

    protected HiveSchemaHelper.MetaStoreConnectionInfo getConnectionInfo(boolean printInfo) {
        return new HiveSchemaHelper.MetaStoreConnectionInfo(this.userName, this.passWord, this.url, this.driver, printInfo, this.conf, this.dbType, this.metaDbType);
    }

    protected void execSql(String scriptDir, String scriptFile) throws IOException, HiveMetaException {
        HiveSchemaHelper.NestedScriptParser dbCommandParser = this.getDbCommandParser(this.dbType, this.metaDbType);
        String sqlCommands = dbCommandParser.buildCommand(scriptDir, scriptFile, this.metaDbType != null);
        File tmpFile = File.createTempFile("schematool", ".sql");
        tmpFile.deleteOnExit();
        FileWriter fstream = new FileWriter(tmpFile.getPath());
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("!autocommit on" + System.getProperty("line.separator"));
        out.write(sqlCommands);
        out.write("!closeall" + System.getProperty("line.separator"));
        out.close();
        this.execSql(tmpFile.getPath());
    }

    protected void execSql(String sqlScriptFile) throws IOException {
        HiveSchemaToolCommandBuilder builder = new HiveSchemaToolCommandBuilder(this.conf, this.url, this.driver, this.userName, this.passWord, sqlScriptFile);
        try (BeeLine beeLine = new BeeLine();){
            if (!this.verbose) {
                beeLine.setOutputStream(new PrintStream((OutputStream)new NullOutputStream()));
                beeLine.getOpts().setSilent(true);
            }
            beeLine.getOpts().setAllowMultiLineCommand(false);
            beeLine.getOpts().setIsolation("TRANSACTION_READ_COMMITTED");
            beeLine.getOpts().setEntireLineAsCommand(true);
            LOG.debug("Going to run command <" + builder.buildToLog() + ">");
            int status = beeLine.begin(builder.buildToRun(), null, false);
            if (status != 0) {
                throw new IOException("Schema script failed, errorcode " + status);
            }
        }
    }

    public static void main(String[] args) {
        HiveSchemaTool tool = new HiveSchemaTool();
        OptionGroup additionalGroup = new OptionGroup();
        OptionBuilder.withArgName((String)"metaDatabaseType");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Used only if upgrading the system catalog for hive");
        Option metaDbTypeOpt = OptionBuilder.create((String)"metaDbType");
        additionalGroup.addOption(metaDbTypeOpt);
        System.setProperty(MetastoreConf.ConfVars.SCHEMA_VERIFICATION.getVarname(), "true");
        System.exit(tool.run(System.getenv("HIVE_HOME"), args, additionalGroup, (Configuration)new HiveConf(HiveSchemaTool.class)));
    }

    static class HiveSchemaToolCommandBuilder
    extends MetastoreSchemaTool.CommandBuilder {
        HiveSchemaToolCommandBuilder(Configuration conf, String url, String driver, String userName, String password, String sqlScriptFile) throws IOException {
            super(conf, url, driver, userName, password, sqlScriptFile);
        }

        protected String[] argsWith(String password) {
            return new String[]{"-u", this.url, "-d", this.driver, "-n", this.userName, "-p", password, "-f", this.sqlScriptFile};
        }
    }
}

