/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.Function;

public class FunctionString
extends Function {
    public FunctionString(Exec e) {
        super(e);
    }

    @Override
    public void register(Function f) {
        f.map.put("CONCAT", this::concat);
        f.map.put("CHAR", this::char_);
        f.map.put("INSTR", this::instr);
        f.map.put("LEN", this::len);
        f.map.put("LENGTH", this::length);
        f.map.put("LOWER", this::lower);
        f.map.put("REPLACE", this::replace);
        f.map.put("SUBSTR", this::substr);
        f.map.put("SUBSTRING", this::substr);
        f.map.put("TO_CHAR", this::toChar);
        f.map.put("UPPER", this::upper);
        f.specMap.put("SUBSTRING", this::substring);
        f.specMap.put("TRIM", this::trim);
    }

    void concat(HplsqlParser.Expr_func_paramsContext ctx) {
        StringBuilder val = new StringBuilder();
        int cnt = this.getParamCount(ctx);
        boolean nulls = true;
        for (int i = 0; i < cnt; ++i) {
            Var c = this.evalPop(ctx.func_param(i).expr());
            if (c.isNull()) continue;
            val.append(c.toString());
            nulls = false;
        }
        if (nulls) {
            this.evalNull();
        } else {
            this.evalString(val);
        }
    }

    void char_(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = this.getParamCount(ctx);
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        this.evalString(str);
    }

    void instr(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = this.getParamCount(ctx);
        if (cnt < 2) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        if (str == null) {
            this.evalNull();
            return;
        }
        if (str.isEmpty()) {
            this.evalInt(0);
            return;
        }
        String substr = this.evalPop(ctx.func_param(1).expr()).toString();
        int pos = 1;
        int occur = 1;
        int idx = 0;
        if (cnt >= 3 && (pos = this.evalPop(ctx.func_param(2).expr()).intValue()) == 0) {
            pos = 1;
        }
        if (cnt >= 4 && (occur = this.evalPop(ctx.func_param(3).expr()).intValue()) < 0) {
            occur = 1;
        }
        for (int i = occur; i > 0; --i) {
            if (pos > 0) {
                idx = str.indexOf(substr, pos - 1);
            } else {
                str = str.substring(0, str.length() - pos * -1);
                idx = str.lastIndexOf(substr);
            }
            if (idx == -1) {
                idx = 0;
                break;
            }
            ++idx;
            if (i <= 1) continue;
            pos = pos > 0 ? idx + 1 : (str.length() - idx + 1) * -1;
        }
        this.evalInt(idx);
    }

    void len(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        int len = this.evalPop(ctx.func_param(0).expr()).toString().trim().length();
        this.evalInt(len);
    }

    void length(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        int len = this.evalPop(ctx.func_param(0).expr()).toString().length();
        this.evalInt(len);
    }

    void lower(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString().toLowerCase();
        this.evalString(str);
    }

    void replace(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = this.getParamCount(ctx);
        if (cnt < 3) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        String what = this.evalPop(ctx.func_param(1).expr()).toString();
        String with = this.evalPop(ctx.func_param(2).expr()).toString();
        this.evalString(str.replaceAll(what, with));
    }

    void substr(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = this.getParamCount(ctx);
        if (cnt < 2) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        int start = this.evalPop(ctx.func_param(1).expr()).intValue();
        int len = -1;
        if (start == 0) {
            start = 1;
        }
        if (cnt > 2) {
            len = this.evalPop(ctx.func_param(2).expr()).intValue();
        }
        this.substr(str, start, len);
    }

    void substr(String str, int start, int len) {
        if (str == null) {
            this.evalNull();
            return;
        }
        if (str.isEmpty()) {
            this.evalString(str);
            return;
        }
        if (start == 0) {
            start = 1;
        }
        if (len == -1) {
            if (start > 0) {
                this.evalString(str.substring(start - 1));
            }
        } else {
            this.evalString(str.substring(start - 1, start - 1 + len));
        }
    }

    void substring(HplsqlParser.Expr_spec_funcContext ctx) {
        String str = this.evalPop(ctx.expr(0)).toString();
        int start = this.evalPop(ctx.expr(1)).intValue();
        int len = -1;
        if (start == 0) {
            start = 1;
        }
        if (ctx.T_FOR() != null) {
            len = this.evalPop(ctx.expr(2)).intValue();
        }
        this.substr(str, start, len);
    }

    void trim(HplsqlParser.Expr_spec_funcContext ctx) {
        int cnt = ctx.expr().size();
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.expr(0)).toString();
        this.evalString(str.trim());
    }

    void toChar(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = this.getParamCount(ctx);
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        this.evalString(str);
    }

    void upper(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString().toUpperCase();
        this.evalString(str);
    }
}

