/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.Var;

@Description(name="hplsql", value="_FUNC_('query' [, :1, :2, ...n]) - Execute HPL/SQL query", extended="Example:\n > SELECT _FUNC_('CURRENT_DATE') FROM src LIMIT 1;\n")
@UDFType(deterministic=false)
public class Udf
extends GenericUDF {
    Exec exec;
    StringObjectInspector queryOI;
    ObjectInspector[] argumentsOI;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length == 0) {
            throw new UDFArgumentLengthException("At least one argument must be specified");
        }
        if (!(arguments[0] instanceof StringObjectInspector)) {
            throw new UDFArgumentException("First argument must be a string");
        }
        this.queryOI = (StringObjectInspector)arguments[0];
        this.argumentsOI = arguments;
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Var result;
        if (this.exec == null) {
            this.initExec(arguments);
        }
        if (arguments.length > 1) {
            this.setParameters(arguments);
        }
        if ((result = this.exec.run()) != null) {
            return result.toString();
        }
        return null;
    }

    public void initExec(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.exec = new Exec();
        this.exec.enterGlobalScope();
        String query = this.queryOI.getPrimitiveJavaObject(arguments[0].get());
        String[] args = new String[]{"-e", query, "-trace"};
        try {
            this.exec.setUdfRun(true);
            this.exec.init(args);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage());
        }
    }

    void setParameters(GenericUDF.DeferredObject[] arguments) throws HiveException {
        for (int i = 1; i < arguments.length; ++i) {
            Object value;
            String name = ":" + i;
            if (this.argumentsOI[i] instanceof StringObjectInspector) {
                value = ((StringObjectInspector)this.argumentsOI[i]).getPrimitiveJavaObject(arguments[i].get());
                if (value == null) continue;
                this.exec.setVariable(name, (String)value);
                continue;
            }
            if (this.argumentsOI[i] instanceof IntObjectInspector) {
                value = (Integer)((IntObjectInspector)this.argumentsOI[i]).getPrimitiveJavaObject(arguments[i].get());
                if (value == null) continue;
                this.exec.setVariable(name, new Var(Long.valueOf(((Integer)value).intValue())));
                continue;
            }
            if (this.argumentsOI[i] instanceof LongObjectInspector) {
                value = (Long)((LongObjectInspector)this.argumentsOI[i]).getPrimitiveJavaObject(arguments[i].get());
                if (value == null) continue;
                this.exec.setVariable(name, new Var((Long)value));
                continue;
            }
            this.exec.setVariableToNull(name);
        }
    }

    public String getDisplayString(String[] children) {
        return "hplsql";
    }
}

