/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Row;

public class Meta {
    HashMap<String, HashMap<String, Row>> dataTypes = new HashMap();
    Exec exec;
    boolean trace = false;
    boolean info = false;

    Meta(Exec e) {
        this.exec = e;
        this.trace = this.exec.getTrace();
        this.info = this.exec.getInfo();
    }

    String getDataType(ParserRuleContext ctx, String conn, String column) {
        ArrayList<String> twoparts;
        String type = null;
        HashMap<String, Row> map = this.dataTypes.get(conn);
        if (map == null) {
            map = new HashMap();
            this.dataTypes.put(conn, map);
        }
        if ((twoparts = this.splitIdentifierToTwoParts(column)) != null) {
            String tab = twoparts.get(0);
            String col = twoparts.get(1).toUpperCase();
            Row row = map.get(tab);
            if (row != null) {
                type = row.getType(col);
            } else {
                row = this.readColumns(ctx, conn, tab, map);
                if (row != null) {
                    type = row.getType(col);
                }
            }
        }
        return type;
    }

    Row getRowDataType(ParserRuleContext ctx, String conn, String table) {
        Row row;
        HashMap<String, Row> map = this.dataTypes.get(conn);
        if (map == null) {
            map = new HashMap();
            this.dataTypes.put(conn, map);
        }
        if ((row = map.get(table)) == null) {
            row = this.readColumns(ctx, conn, table, map);
        }
        return row;
    }

    Row getRowDataTypeForSelect(ParserRuleContext ctx, String conn, String select) {
        Row row = null;
        Conn.Type connType = this.exec.getConnectionType(conn);
        if (connType == Conn.Type.HIVE) {
            String sql = "SELECT * FROM (" + select + ") t LIMIT 1";
            Query query = new Query(sql);
            this.exec.executeQuery(ctx, query, conn);
            if (!query.error()) {
                ResultSet rs = query.getResultSet();
                try {
                    ResultSetMetaData rm = rs.getMetaData();
                    int cols = rm.getColumnCount();
                    row = new Row();
                    for (int i = 1; i <= cols; ++i) {
                        String name = rm.getColumnName(i);
                        if (name.startsWith("t.")) {
                            name = name.substring(2);
                        }
                        row.addColumn(name, rm.getColumnTypeName(i));
                    }
                }
                catch (Exception e) {
                    this.exec.signal(e);
                }
            } else {
                this.exec.signal(query.getException());
            }
            this.exec.closeQuery(query, conn);
        } else {
            Query query = this.exec.prepareQuery(ctx, select, conn);
            if (!query.error()) {
                try {
                    PreparedStatement stmt = query.getPreparedStatement();
                    ResultSetMetaData rm = stmt.getMetaData();
                    int cols = rm.getColumnCount();
                    for (int i = 1; i <= cols; ++i) {
                        String col = rm.getColumnName(i);
                        String typ = rm.getColumnTypeName(i);
                        if (row == null) {
                            row = new Row();
                        }
                        row.addColumn(col.toUpperCase(), typ);
                    }
                }
                catch (Exception e) {
                    this.exec.signal(e);
                }
            }
            this.exec.closeQuery(query, conn);
        }
        return row;
    }

    Row readColumns(ParserRuleContext ctx, String conn, String table, HashMap<String, Row> map) {
        Row row = null;
        Conn.Type connType = this.exec.getConnectionType(conn);
        if (connType == Conn.Type.HIVE) {
            String sql = "DESCRIBE " + table;
            Query query = new Query(sql);
            this.exec.executeQuery(ctx, query, conn);
            if (!query.error()) {
                ResultSet rs = query.getResultSet();
                try {
                    while (rs.next()) {
                        String col = rs.getString(1);
                        String typ = rs.getString(2);
                        if (row == null) {
                            row = new Row();
                        }
                        if (typ == null) break;
                        row.addColumn(col.toUpperCase(), typ);
                    }
                    map.put(table, row);
                }
                catch (Exception e) {
                    this.exec.signal(e);
                }
            } else {
                this.exec.signal(query.getException());
            }
            this.exec.closeQuery(query, conn);
        } else {
            Query query = this.exec.prepareQuery(ctx, "SELECT * FROM " + table, conn);
            if (!query.error()) {
                try {
                    PreparedStatement stmt = query.getPreparedStatement();
                    ResultSetMetaData rm = stmt.getMetaData();
                    int cols = rm.getColumnCount();
                    for (int i = 1; i <= cols; ++i) {
                        String col = rm.getColumnName(i);
                        String typ = rm.getColumnTypeName(i);
                        if (row == null) {
                            row = new Row();
                        }
                        row.addColumn(col.toUpperCase(), typ);
                    }
                    map.put(table, row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.exec.closeQuery(query, conn);
        }
        return row;
    }

    public String normalizeObjectIdentifier(String name) {
        ArrayList<String> parts = this.splitIdentifier(name);
        if (parts != null) {
            StringBuilder norm = new StringBuilder();
            int size = parts.size();
            boolean appended = false;
            for (int i = 0; i < size; ++i) {
                if (i == size - 2) {
                    String schema = this.getTargetSchemaName(parts.get(i));
                    if (schema != null) {
                        norm.append(schema);
                        appended = true;
                    }
                } else {
                    norm.append(this.normalizeIdentifierPart(parts.get(i)));
                    appended = true;
                }
                if (i + 1 >= parts.size() || !appended) continue;
                norm.append(".");
            }
            return norm.toString();
        }
        return this.normalizeIdentifierPart(name);
    }

    String getTargetSchemaName(String name) {
        if (name.equalsIgnoreCase("dbo") || name.equalsIgnoreCase("[dbo]")) {
            return null;
        }
        return this.normalizeIdentifierPart(name);
    }

    public String normalizeIdentifierPart(String name) {
        char start = name.charAt(0);
        char end = name.charAt(name.length() - 1);
        if (start == '[' && end == ']' || start == '\"' && end == '\"') {
            return '`' + name.substring(1, name.length() - 1) + '`';
        }
        return name;
    }

    public ArrayList<String> splitIdentifierToTwoParts(String name) {
        ArrayList<String> parts = this.splitIdentifier(name);
        ArrayList<String> twoparts = null;
        if (parts != null) {
            int i;
            StringBuilder id = new StringBuilder();
            for (i = 0; i < parts.size() - 1; ++i) {
                id.append(parts.get(i));
                if (i + 1 >= parts.size() - 1) continue;
                id.append(".");
            }
            twoparts = new ArrayList<String>();
            twoparts.add(id.toString());
            id.setLength(0);
            id.append(parts.get(i));
            twoparts.add(id.toString());
        }
        return twoparts;
    }

    public ArrayList<String> splitIdentifier(String name) {
        ArrayList<String> parts = null;
        int start = 0;
        block0: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            char del = '\u0000';
            if (c == '`' || c == '\"') {
                del = c;
            } else if (c == '[') {
                del = ']';
            }
            if (del != '\u0000') {
                int j = i + 1;
                while (i < name.length()) {
                    ++i;
                    if (name.charAt(j) == del) continue block0;
                    ++j;
                }
                continue;
            }
            if (c != 46) continue;
            if (parts == null) {
                parts = new ArrayList<String>();
            }
            parts.add(name.substring(start, i));
            start = i + 1;
        }
        if (parts != null) {
            parts.add(name.substring(start));
        }
        return parts;
    }
}

