/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client;

public enum TableType {
    SOURCE(0),
    SINK(1);

    private static final TableType[] INDEX;
    private byte id;

    private static TableType[] buildIndex() {
        TableType[] index = new TableType[TableType.values().length];
        for (TableType type : TableType.values()) {
            byte position = type.getId();
            if (index[position] != null) {
                throw new IllegalStateException("Overloaded index: " + position);
            }
            index[position] = type;
        }
        return index;
    }

    private TableType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static TableType valueOf(byte id) {
        if (id < 0 || id >= INDEX.length) {
            throw new IllegalArgumentException("Invalid id: " + id);
        }
        return INDEX[id];
    }

    static {
        INDEX = TableType.buildIndex();
    }
}

