/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.spitter;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.storage.jdbc.spitter.IntervalSplitter;

public class LongIntervalSpitter
implements IntervalSplitter {
    @Override
    public List<MutablePair<String, String>> getIntervals(String lowerBound, String upperBound, int numPartitions, TypeInfo typeInfo) {
        ArrayList<MutablePair<String, String>> intervals = new ArrayList<MutablePair<String, String>>();
        long longLower = Long.parseLong(lowerBound);
        long longUpper = Long.parseLong(upperBound);
        double longInterval = (double)(longUpper - longLower) / (double)numPartitions;
        for (int i = 0; i < numPartitions; ++i) {
            long splitLongLower = Math.round((double)longLower + longInterval * (double)i);
            long splitLongUpper = Math.round((double)longLower + longInterval * (double)(i + 1));
            if (splitLongUpper <= splitLongLower) continue;
            intervals.add((MutablePair<String, String>)new MutablePair((Object)Long.toString(splitLongLower), (Object)Long.toString(splitLongUpper)));
        }
        return intervals;
    }
}

