/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.dao;

import org.apache.hadoop.conf.Configuration;
import org.apache.hive.storage.jdbc.conf.DatabaseType;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;
import org.apache.hive.storage.jdbc.dao.DB2DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.DerbyDatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.GenericJdbcDatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.JethroDatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.MsSqlDatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.MySqlDatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.OracleDatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.PostgresDatabaseAccessor;

public class DatabaseAccessorFactory {
    private DatabaseAccessorFactory() {
    }

    public static DatabaseAccessor getAccessor(DatabaseType dbType) {
        GenericJdbcDatabaseAccessor accessor = null;
        switch (dbType) {
            case MYSQL: {
                accessor = new MySqlDatabaseAccessor();
                break;
            }
            case JETHRO_DATA: {
                accessor = new JethroDatabaseAccessor();
                break;
            }
            case POSTGRES: {
                accessor = new PostgresDatabaseAccessor();
                break;
            }
            case ORACLE: {
                accessor = new OracleDatabaseAccessor();
                break;
            }
            case MSSQL: {
                accessor = new MsSqlDatabaseAccessor();
                break;
            }
            case DB2: {
                accessor = new DB2DatabaseAccessor();
                break;
            }
            case DERBY: {
                accessor = new DerbyDatabaseAccessor();
                break;
            }
            default: {
                accessor = new GenericJdbcDatabaseAccessor();
            }
        }
        return accessor;
    }

    public static DatabaseAccessor getAccessor(Configuration conf) {
        DatabaseType dbType = DatabaseType.valueOf(conf.get(JdbcStorageConfig.DATABASE_TYPE.getPropertyName()).toUpperCase());
        return DatabaseAccessorFactory.getAccessor(dbType);
    }
}

