/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.DateUtils;
import org.apache.hive.storage.jdbc.DBRecordWritable;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfigManager;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSerDe
extends AbstractSerDe {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSerDe.class);
    private String[] hiveColumnNames;
    private int numColumns;
    private PrimitiveTypeInfo[] hiveColumnTypes;
    private ObjectInspector inspector;
    private List<Object> row;
    private DBRecordWritable dbRecordWritable;

    public void initialize(Configuration conf, Properties properties) throws SerDeException {
        try {
            LOGGER.trace("Initializing the JdbcSerDe");
            if (properties.containsKey(JdbcStorageConfig.DATABASE_TYPE.getPropertyName())) {
                ArrayList hiveColumnTypesList;
                Configuration tableConfig = JdbcStorageConfigManager.convertPropertiesToConfiguration(properties);
                DatabaseAccessor dbAccessor = DatabaseAccessorFactory.getAccessor(tableConfig);
                if (properties.containsKey("hive.sql.table") && properties.containsKey("hive.sql.query")) {
                    String fieldNamesProperty = (String)Preconditions.checkNotNull((Object)properties.getProperty("hive.sql.query.fieldNames", null));
                    String fieldTypesProperty = (String)Preconditions.checkNotNull((Object)properties.getProperty("hive.sql.query.fieldTypes", null));
                    this.hiveColumnNames = fieldNamesProperty.trim().split(",");
                    hiveColumnTypesList = TypeInfoUtils.getTypeInfosFromTypeString((String)fieldTypesProperty);
                } else if (properties.containsKey("hive.sql.query")) {
                    this.hiveColumnNames = properties.getProperty("columns").split(",");
                    hiveColumnTypesList = TypeInfoUtils.getTypeInfosFromTypeString((String)properties.getProperty("columns.types"));
                } else {
                    this.hiveColumnNames = dbAccessor.getColumnNames(tableConfig).toArray(new String[0]);
                    if (this.hiveColumnNames.length != properties.getProperty("columns").split(",").length) {
                        throw new SerDeException("Column numbers do not match. Remote table columns are " + Arrays.toString(this.hiveColumnNames) + " and declared table columns in Hive external table are " + Arrays.toString(properties.getProperty("columns").split(",")));
                    }
                    hiveColumnTypesList = TypeInfoUtils.getTypeInfosFromTypeString((String)properties.getProperty("columns.types"));
                }
                if (this.hiveColumnNames.length == 0) {
                    throw new SerDeException("Received an empty Hive column name definition");
                }
                if (hiveColumnTypesList.size() == 0) {
                    throw new SerDeException("Received an empty Hive column type definition");
                }
                this.numColumns = this.hiveColumnNames.length;
                this.dbRecordWritable = new DBRecordWritable(this.numColumns);
                this.hiveColumnTypes = new PrimitiveTypeInfo[hiveColumnTypesList.size()];
                ArrayList<AbstractPrimitiveJavaObjectInspector> fieldInspectors = new ArrayList<AbstractPrimitiveJavaObjectInspector>(this.hiveColumnNames.length);
                for (int i = 0; i < this.hiveColumnNames.length; ++i) {
                    TypeInfo ti = (TypeInfo)hiveColumnTypesList.get(i);
                    if (ti.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                        throw new SerDeException("Non primitive types not supported yet");
                    }
                    this.hiveColumnTypes[i] = (PrimitiveTypeInfo)ti;
                    fieldInspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)this.hiveColumnTypes[i]));
                }
                this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(this.hiveColumnNames), fieldInspectors);
                this.row = new ArrayList<Object>(this.hiveColumnNames.length);
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while initializing the SqlSerDe", (Throwable)e);
            throw new SerDeException((Throwable)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JdbcSerDe initialized with\n\t columns: " + Arrays.toString(this.hiveColumnNames) + "\n\t types: " + Arrays.toString(this.hiveColumnTypes));
        }
    }

    public DBRecordWritable serialize(Object row, ObjectInspector inspector) throws SerDeException {
        LOGGER.trace("Serializing from SerDe");
        if (row == null || this.hiveColumnTypes == null) {
            throw new SerDeException("JDBC SerDe hasn't been initialized properly");
        }
        if (((Object[])row).length != this.numColumns) {
            throw new SerDeException(String.format("Required %d columns, received %d.", this.numColumns, ((Object[])row).length));
        }
        this.dbRecordWritable.clear();
        for (int i = 0; i < this.numColumns; ++i) {
            Object rowData = ((Object[])row)[i];
            switch (this.hiveColumnTypes[i].getPrimitiveCategory()) {
                case INT: {
                    rowData = Integer.valueOf(rowData.toString());
                    break;
                }
                case SHORT: {
                    rowData = Short.valueOf(rowData.toString());
                    break;
                }
                case BYTE: {
                    rowData = Byte.valueOf(rowData.toString());
                    break;
                }
                case LONG: {
                    rowData = Long.valueOf(rowData.toString());
                    break;
                }
                case FLOAT: {
                    rowData = Float.valueOf(rowData.toString());
                    break;
                }
                case DOUBLE: {
                    rowData = Double.valueOf(rowData.toString());
                    break;
                }
                case DECIMAL: {
                    int scale = ((HiveDecimalWritable)rowData).getScale();
                    long value = ((HiveDecimalWritable)rowData).getHiveDecimal().unscaledValue().longValue();
                    rowData = BigDecimal.valueOf(value, scale);
                    break;
                }
                case BOOLEAN: {
                    rowData = Boolean.valueOf(rowData.toString());
                    break;
                }
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    rowData = String.valueOf(rowData.toString());
                    break;
                }
                case DATE: {
                    rowData = Date.valueOf(rowData.toString());
                    break;
                }
                case TIMESTAMP: {
                    rowData = Timestamp.valueOf(rowData.toString());
                    break;
                }
            }
            this.dbRecordWritable.set(i, rowData);
        }
        return this.dbRecordWritable;
    }

    public Object deserialize(Writable blob) throws SerDeException {
        LOGGER.trace("Deserializing from SerDe");
        if (!(blob instanceof MapWritable)) {
            throw new SerDeException("Expected MapWritable. Got " + blob.getClass().getName());
        }
        if (this.row == null || this.hiveColumnNames == null) {
            throw new SerDeException("JDBC SerDe hasn't been initialized properly");
        }
        this.row.clear();
        MapWritable input = (MapWritable)blob;
        Text columnKey = new Text();
        for (int i = 0; i < this.hiveColumnNames.length; ++i) {
            Object rowVal;
            columnKey.set(this.hiveColumnNames[i]);
            Writable value = input.get((Object)columnKey);
            if (value instanceof NullWritable) {
                rowVal = null;
            } else {
                rowVal = ((ObjectWritable)value).get();
                switch (this.hiveColumnTypes[i].getPrimitiveCategory()) {
                    case INT: {
                        if (rowVal instanceof Number) {
                            rowVal = ((Number)rowVal).intValue();
                            break;
                        }
                        rowVal = Integer.valueOf(rowVal.toString());
                        break;
                    }
                    case SHORT: {
                        if (rowVal instanceof Number) {
                            rowVal = ((Number)rowVal).shortValue();
                            break;
                        }
                        rowVal = Short.valueOf(rowVal.toString());
                        break;
                    }
                    case BYTE: {
                        if (rowVal instanceof Number) {
                            rowVal = ((Number)rowVal).byteValue();
                            break;
                        }
                        rowVal = Byte.valueOf(rowVal.toString());
                        break;
                    }
                    case LONG: {
                        if (rowVal instanceof Long) {
                            rowVal = ((Number)rowVal).longValue();
                            break;
                        }
                        rowVal = Long.valueOf(rowVal.toString());
                        break;
                    }
                    case FLOAT: {
                        if (rowVal instanceof Number) {
                            rowVal = Float.valueOf(((Number)rowVal).floatValue());
                            break;
                        }
                        rowVal = Float.valueOf(rowVal.toString());
                        break;
                    }
                    case DOUBLE: {
                        if (rowVal instanceof Number) {
                            rowVal = ((Number)rowVal).doubleValue();
                            break;
                        }
                        rowVal = Double.valueOf(rowVal.toString());
                        break;
                    }
                    case DECIMAL: {
                        int scale = ((DecimalTypeInfo)this.hiveColumnTypes[i]).getScale();
                        rowVal = HiveDecimal.create((String)rowVal.toString());
                        ((HiveDecimal)rowVal).setScale(scale, 6);
                        break;
                    }
                    case BOOLEAN: {
                        if (rowVal instanceof Number) {
                            rowVal = ((Number)value).intValue() != 0;
                            break;
                        }
                        rowVal = Boolean.valueOf(rowVal.toString());
                        break;
                    }
                    case CHAR: 
                    case VARCHAR: 
                    case STRING: {
                        if (rowVal instanceof Date) {
                            rowVal = DateUtils.getDateFormat().format((Date)rowVal);
                            break;
                        }
                        rowVal = rowVal.toString();
                        break;
                    }
                    case DATE: {
                        if (rowVal instanceof Date) {
                            LocalDate localDate = ((Date)rowVal).toLocalDate();
                            rowVal = org.apache.hadoop.hive.common.type.Date.of((int)localDate.getYear(), (int)localDate.getMonthValue(), (int)localDate.getDayOfMonth());
                            break;
                        }
                        rowVal = org.apache.hadoop.hive.common.type.Date.valueOf((String)rowVal.toString());
                        break;
                    }
                    case TIMESTAMP: {
                        if (rowVal instanceof Timestamp) {
                            LocalDateTime localDateTime = ((Timestamp)rowVal).toLocalDateTime();
                            rowVal = org.apache.hadoop.hive.common.type.Timestamp.ofEpochSecond((long)localDateTime.toEpochSecond(ZoneOffset.UTC), (int)localDateTime.getNano());
                            break;
                        }
                        rowVal = org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)rowVal.toString());
                        break;
                    }
                }
            }
            this.row.add(rowVal);
        }
        return this.row;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return MapWritable.class;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

