/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

public class DBRecordWritable
implements Writable,
DBWritable {
    private Object[] columnValues;

    public DBRecordWritable() {
    }

    public DBRecordWritable(int numColumns) {
        this.columnValues = new Object[numColumns];
    }

    public void clear() {
        Arrays.fill(this.columnValues, null);
    }

    public void set(int i, Object columnObject) {
        this.columnValues[i] = columnObject;
    }

    public void readFields(ResultSet rs) throws SQLException {
    }

    public void write(PreparedStatement statement) throws SQLException {
        if (this.columnValues == null) {
            throw new SQLException("No data available to be written");
        }
        ParameterMetaData parameterMetaData = statement.getParameterMetaData();
        for (int i = 0; i < this.columnValues.length; ++i) {
            Object value = this.columnValues[i];
            if (parameterMetaData.getParameterType(i + 1) == 1 && value != null && value instanceof Boolean) {
                value = (Boolean)value != false ? "1" : "0";
            }
            statement.setObject(i + 1, value);
        }
    }

    public void readFields(DataInput in) throws IOException {
    }

    public void write(DataOutput out) throws IOException {
    }
}

