/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.pig;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.pig.PigHCatUtil;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.BackendException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HCatBaseStorer
extends StoreFunc
implements StoreMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(HCatBaseStorer.class);
    private static final List<HCatFieldSchema.Type> SUPPORTED_INTEGER_CONVERSIONS = Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.TINYINT, HCatFieldSchema.Type.SMALLINT, HCatFieldSchema.Type.INT});
    protected static final String COMPUTED_OUTPUT_SCHEMA = "hcat.output.schema";
    protected final List<String> partitionKeys;
    protected final Map<String, String> partitions;
    protected Schema pigSchema;
    private RecordWriter<WritableComparable<?>, HCatRecord> writer;
    protected HCatSchema computedSchema;
    protected static final String PIG_SCHEMA = "hcat.pig.store.schema";
    static final String ON_OOR_VALUE_OPT = "onOutOfRangeValue";
    static final String ON_OORA_VALUE_PROP = "hcat.pig.store.onoutofrangevalue";
    protected String sign;
    private final DataLossLogger dataLossLogger = new DataLossLogger();
    private final OOR_VALUE_OPT_VALUES onOutOfRange;

    public HCatBaseStorer(String partSpecs, String schema) throws Exception {
        this.partitionKeys = new ArrayList<String>();
        this.partitions = new HashMap<String, String>();
        if (partSpecs != null && !partSpecs.trim().isEmpty()) {
            String[] partKVPs;
            for (String partKVP : partKVPs = partSpecs.split(",")) {
                String[] partKV = partKVP.split("=");
                if (partKV.length != 2) {
                    throw new FrontendException("Invalid partition column specification. " + partSpecs, 1115);
                }
                String partKey = partKV[0].trim();
                this.partitionKeys.add(partKey);
                this.partitions.put(partKey, partKV[1].trim());
            }
        }
        if (schema != null && !schema.trim().isEmpty()) {
            this.pigSchema = Utils.getSchemaFromString((String)schema);
        }
        Properties udfProps = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.sign});
        this.onOutOfRange = OOR_VALUE_OPT_VALUES.valueOf(udfProps.getProperty(ON_OORA_VALUE_PROP, HCatBaseStorer.getDefaultValue().name()));
    }

    static OOR_VALUE_OPT_VALUES getDefaultValue() {
        return OOR_VALUE_OPT_VALUES.Null;
    }

    public void checkSchema(ResourceSchema resourceSchema) throws IOException {
        Schema runtimeSchema = Schema.getPigSchema((ResourceSchema)resourceSchema);
        if (this.pigSchema != null) {
            if (!Schema.equals((Schema)runtimeSchema, (Schema)this.pigSchema, (boolean)false, (boolean)true)) {
                throw new FrontendException("Schema provided in store statement doesn't match with the Schemareturned by Pig run-time. Schema provided in HCatStorer: " + this.pigSchema.toString() + " Schema received from Pig runtime: " + runtimeSchema.toString(), 1115);
            }
        } else {
            this.pigSchema = runtimeSchema;
        }
        UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.sign}).setProperty(PIG_SCHEMA, ObjectSerializer.serialize((Serializable)this.pigSchema));
    }

    protected HCatSchema convertPigSchemaToHCatSchema(Schema pigSchema, HCatSchema tableSchema) throws FrontendException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("convertPigSchemaToHCatSchema(pigSchema,tblSchema)=(" + pigSchema + "," + tableSchema + ")");
        }
        ArrayList<HCatFieldSchema> fieldSchemas = new ArrayList<HCatFieldSchema>(pigSchema.size());
        for (Schema.FieldSchema fSchema : pigSchema.getFields()) {
            try {
                HCatFieldSchema hcatFieldSchema = this.getColFromSchema(fSchema.alias, tableSchema);
                fieldSchemas.add(this.getHCatFSFromPigFS(fSchema, hcatFieldSchema, pigSchema, tableSchema));
            }
            catch (HCatException he) {
                throw new FrontendException(he.getMessage(), 1115, (Throwable)he);
            }
        }
        HCatSchema s = new HCatSchema(fieldSchemas);
        LOG.debug("convertPigSchemaToHCatSchema(computed)=(" + s + ")");
        return s;
    }

    public static boolean removeTupleFromBag(HCatFieldSchema hcatFieldSchema, Schema.FieldSchema bagFieldSchema) throws HCatException {
        if (hcatFieldSchema != null && hcatFieldSchema.getArrayElementSchema().get(0).getType() != HCatFieldSchema.Type.STRUCT) {
            return true;
        }
        List tupSchema = bagFieldSchema.schema.getFields();
        return hcatFieldSchema == null && tupSchema.size() == 1 && (((Schema.FieldSchema)tupSchema.get((int)0)).schema == null || ((Schema.FieldSchema)tupSchema.get((int)0)).type == 110 && ((Schema.FieldSchema)tupSchema.get((int)0)).schema.size() == 1);
    }

    private HCatFieldSchema getHCatFSFromPigFS(Schema.FieldSchema fSchema, HCatFieldSchema hcatFieldSchema, Schema pigSchema, HCatSchema tableSchema) throws FrontendException, HCatException {
        if (hcatFieldSchema == null && LOG.isDebugEnabled()) {
            LOG.debug("hcatFieldSchema is null for fSchema '" + fSchema.alias + "'");
        }
        byte type = fSchema.type;
        switch (type) {
            case 55: 
            case 60: {
                if (hcatFieldSchema != null && hcatFieldSchema.getTypeInfo() != null) {
                    return new HCatFieldSchema(fSchema.alias, hcatFieldSchema.getTypeInfo(), null);
                }
                return new HCatFieldSchema(fSchema.alias, TypeInfoFactory.stringTypeInfo, null);
            }
            case 10: {
                if (hcatFieldSchema != null) {
                    if (!SUPPORTED_INTEGER_CONVERSIONS.contains(hcatFieldSchema.getType())) {
                        throw new FrontendException("Unsupported type: " + type + "  in Pig's schema", 1115);
                    }
                    return new HCatFieldSchema(fSchema.alias, hcatFieldSchema.getTypeInfo(), null);
                }
                return new HCatFieldSchema(fSchema.alias, TypeInfoFactory.intTypeInfo, null);
            }
            case 15: {
                return new HCatFieldSchema(fSchema.alias, TypeInfoFactory.longTypeInfo, null);
            }
            case 20: {
                return new HCatFieldSchema(fSchema.alias, TypeInfoFactory.floatTypeInfo, null);
            }
            case 25: {
                return new HCatFieldSchema(fSchema.alias, TypeInfoFactory.doubleTypeInfo, null);
            }
            case 50: {
                return new HCatFieldSchema(fSchema.alias, TypeInfoFactory.binaryTypeInfo, null);
            }
            case 5: {
                return new HCatFieldSchema(fSchema.alias, TypeInfoFactory.booleanTypeInfo, null);
            }
            case 30: {
                if (hcatFieldSchema != null && hcatFieldSchema.getTypeInfo() != null) {
                    return new HCatFieldSchema(fSchema.alias, hcatFieldSchema.getTypeInfo(), null);
                }
                return new HCatFieldSchema(fSchema.alias, TypeInfoFactory.timestampTypeInfo, null);
            }
            case 70: {
                if (hcatFieldSchema != null && hcatFieldSchema.getTypeInfo() != null) {
                    return new HCatFieldSchema(fSchema.alias, hcatFieldSchema.getTypeInfo(), null);
                }
                return new HCatFieldSchema(fSchema.alias, (PrimitiveTypeInfo)TypeInfoFactory.decimalTypeInfo, null);
            }
            case 120: {
                Schema bagSchema = fSchema.schema;
                ArrayList<HCatFieldSchema> arrFields = new ArrayList<HCatFieldSchema>(1);
                Schema.FieldSchema field = HCatBaseStorer.removeTupleFromBag(hcatFieldSchema, fSchema) ? bagSchema.getField((int)0).schema.getField(0) : bagSchema.getField(0);
                arrFields.add(this.getHCatFSFromPigFS(field, hcatFieldSchema == null ? null : hcatFieldSchema.getArrayElementSchema().get(0), pigSchema, tableSchema));
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.ARRAY, new HCatSchema(arrFields), "");
            }
            case 110: {
                ArrayList<HCatFieldSchema> hcatFSs = new ArrayList<HCatFieldSchema>();
                HCatSchema structSubSchema = hcatFieldSchema == null ? null : hcatFieldSchema.getStructSubSchema();
                List fields = fSchema.schema.getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.FieldSchema fieldSchema = (Schema.FieldSchema)fields.get(i);
                    hcatFSs.add(this.getHCatFSFromPigFS(fieldSchema, structSubSchema == null ? null : structSubSchema.get(i), pigSchema, tableSchema));
                }
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.STRUCT, new HCatSchema(hcatFSs), "");
            }
            case 100: {
                ArrayList<HCatFieldSchema> valFSList = new ArrayList<HCatFieldSchema>(1);
                if (hcatFieldSchema != null) {
                    return HCatFieldSchema.createMapTypeFieldSchema((String)fSchema.alias, (PrimitiveTypeInfo)hcatFieldSchema.getMapKeyTypeInfo(), (HCatSchema)hcatFieldSchema.getMapValueSchema(), (String)"");
                }
                HCatFieldSchema valFS = new HCatFieldSchema(fSchema.alias, TypeInfoFactory.stringTypeInfo, "");
                valFSList.add(valFS);
                return HCatFieldSchema.createMapTypeFieldSchema((String)fSchema.alias, (PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (HCatSchema)new HCatSchema(valFSList), (String)"");
            }
        }
        throw new FrontendException("Unsupported type: " + type + "  in Pig's schema", 1115);
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
        this.computedSchema = (HCatSchema)ObjectSerializer.deserialize((String)UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.sign}).getProperty(COMPUTED_OUTPUT_SCHEMA));
    }

    public void putNext(Tuple tuple) throws IOException {
        ArrayList<Object> outgoing = new ArrayList<Object>(tuple.size());
        int i = 0;
        for (HCatFieldSchema fSchema : this.computedSchema.getFields()) {
            outgoing.add(this.getJavaObj(tuple.get(i++), fSchema));
        }
        try {
            this.writer.write(null, (Object)new DefaultHCatRecord(outgoing));
        }
        catch (InterruptedException e) {
            throw new BackendException("Error while writing tuple: " + tuple, 1115, (Throwable)e);
        }
    }

    private Object getJavaObj(Object pigObj, HCatFieldSchema hcatFS) throws HCatException, BackendException {
        try {
            if (pigObj == null) {
                return null;
            }
            HCatFieldSchema.Type type = hcatFS.getType();
            switch (type) {
                case BINARY: {
                    return ((DataByteArray)pigObj).get();
                }
                case STRUCT: {
                    HCatSchema structSubSchema = hcatFS.getStructSubSchema();
                    List all = ((Tuple)pigObj).getAll();
                    ArrayList<Object> converted = new ArrayList<Object>(all.size());
                    for (int i = 0; i < all.size(); ++i) {
                        converted.add(this.getJavaObj(all.get(i), structSubSchema.get(i)));
                    }
                    return converted;
                }
                case ARRAY: {
                    DataBag pigBag = (DataBag)pigObj;
                    HCatFieldSchema tupFS = hcatFS.getArrayElementSchema().get(0);
                    boolean needTuple = tupFS.getType() == HCatFieldSchema.Type.STRUCT;
                    ArrayList<Object> bagContents = new ArrayList<Object>((int)pigBag.size());
                    Iterator bagItr = pigBag.iterator();
                    while (bagItr.hasNext()) {
                        bagContents.add(this.getJavaObj(needTuple ? bagItr.next() : ((Tuple)bagItr.next()).get(0), tupFS));
                    }
                    return bagContents;
                }
                case MAP: {
                    Map pigMap = (Map)pigObj;
                    LinkedHashMap<String, Object> typeMap = new LinkedHashMap<String, Object>();
                    for (Map.Entry entry : pigMap.entrySet()) {
                        typeMap.put((String)entry.getKey(), this.getJavaObj(entry.getValue(), hcatFS.getMapValueSchema().get(0)));
                    }
                    return typeMap;
                }
                case STRING: 
                case INT: 
                case BIGINT: 
                case FLOAT: 
                case DOUBLE: {
                    return pigObj;
                }
                case SMALLINT: {
                    if ((Integer)pigObj < Short.MIN_VALUE || (Integer)pigObj > Short.MAX_VALUE) {
                        this.handleOutOfRangeValue(pigObj, hcatFS);
                        return null;
                    }
                    return ((Integer)pigObj).shortValue();
                }
                case TINYINT: {
                    if ((Integer)pigObj < -128 || (Integer)pigObj > 127) {
                        this.handleOutOfRangeValue(pigObj, hcatFS);
                        return null;
                    }
                    return ((Integer)pigObj).byteValue();
                }
                case BOOLEAN: {
                    if (pigObj instanceof String) {
                        if (((String)pigObj).trim().compareTo("0") == 0) {
                            return Boolean.FALSE;
                        }
                        if (((String)pigObj).trim().compareTo("1") == 0) {
                            return Boolean.TRUE;
                        }
                        throw new BackendException("Unexpected type " + type + " for value " + pigObj + " of class " + pigObj.getClass().getName(), 1115);
                    }
                    return Boolean.parseBoolean(pigObj.toString());
                }
                case DECIMAL: {
                    BigDecimal bd = (BigDecimal)pigObj;
                    DecimalTypeInfo dti = (DecimalTypeInfo)hcatFS.getTypeInfo();
                    if (bd.precision() > dti.precision() || bd.scale() > dti.scale()) {
                        this.handleOutOfRangeValue(pigObj, hcatFS);
                        return null;
                    }
                    return HiveDecimal.create((BigDecimal)bd);
                }
                case CHAR: {
                    String charVal = (String)pigObj;
                    CharTypeInfo cti = (CharTypeInfo)hcatFS.getTypeInfo();
                    if (charVal.length() > cti.getLength()) {
                        this.handleOutOfRangeValue(pigObj, hcatFS);
                        return null;
                    }
                    return new HiveChar(charVal, cti.getLength());
                }
                case VARCHAR: {
                    String varcharVal = (String)pigObj;
                    VarcharTypeInfo vti = (VarcharTypeInfo)hcatFS.getTypeInfo();
                    if (varcharVal.length() > vti.getLength()) {
                        this.handleOutOfRangeValue(pigObj, hcatFS);
                        return null;
                    }
                    return new HiveVarchar(varcharVal, vti.getLength());
                }
                case TIMESTAMP: {
                    DateTime dt = (DateTime)pigObj;
                    return Timestamp.ofEpochMilli((long)dt.getMillis());
                }
                case DATE: {
                    DateTime dateTime = (DateTime)pigObj;
                    if (dateTime.getMillisOfDay() != 0) {
                        this.handleOutOfRangeValue(pigObj, hcatFS, "Time component must be 0 (midnight) in local timezone; Local TZ val='" + pigObj + "'");
                        return null;
                    }
                    return Date.of((int)dateTime.getYear(), (int)dateTime.getMonthOfYear(), (int)dateTime.getDayOfMonth());
                }
            }
            throw new BackendException("Unexpected HCat type " + type + " for value " + pigObj + " of class " + pigObj.getClass().getName(), 1115);
        }
        catch (BackendException e) {
            throw new BackendException((hcatFS.getName() == null ? " " : hcatFS.getName() + ".") + e.getMessage(), (Throwable)e);
        }
    }

    private void handleOutOfRangeValue(Object pigObj, HCatFieldSchema hcatFS) throws BackendException {
        this.handleOutOfRangeValue(pigObj, hcatFS, null);
    }

    private void handleOutOfRangeValue(Object pigObj, HCatFieldSchema hcatFS, String additionalMsg) throws BackendException {
        String msg = "Pig value '" + pigObj + "' is outside the bounds of column " + hcatFS.getName() + " with type " + (hcatFS.getTypeInfo() == null ? hcatFS.getType() : hcatFS.getTypeInfo().getTypeName()) + (additionalMsg == null ? "" : "[" + additionalMsg + "]");
        switch (this.onOutOfRange) {
            case Throw: {
                throw new BackendException(msg, 1115);
            }
            case Null: {
                this.dataLossLogger.logDataLossMsg(hcatFS, pigObj, msg);
                break;
            }
            default: {
                throw new BackendException("Unexpected onOutOfRangeValue value: '" + (Object)((Object)this.onOutOfRange) + "'");
            }
        }
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.sign = signature;
    }

    protected void doSchemaValidations(Schema pigSchema, HCatSchema tblSchema) throws FrontendException, HCatException {
        int columnPos = 0;
        for (Schema.FieldSchema pigField : pigSchema.getFields()) {
            HCatFieldSchema hcatField = this.getColFromSchema(pigField.alias, tblSchema);
            this.validateSchema(pigField, hcatField, pigSchema, tblSchema, columnPos++);
        }
        try {
            PigHCatUtil.validateHCatTableSchemaFollowsPigRules(tblSchema);
        }
        catch (IOException e) {
            throw new FrontendException("HCatalog schema is not compatible with Pig: " + e.getMessage(), 1115, (Throwable)e);
        }
    }

    private void validateSchema(Schema.FieldSchema pigField, HCatFieldSchema hcatField, Schema topLevelPigSchema, HCatSchema topLevelHCatSchema, int columnPos) throws HCatException, FrontendException {
        block22: {
            byte type;
            block21: {
                this.validateAlias(pigField.alias);
                type = pigField.type;
                if (!DataType.isComplex((byte)type)) break block21;
                switch (type) {
                    case 100: {
                        if (hcatField != null && hcatField.getMapKeyType() != HCatFieldSchema.Type.STRING) {
                            throw new FrontendException("Key Type of map must be String " + hcatField, 1115);
                        }
                        break block22;
                    }
                    case 120: {
                        HCatSchema arrayElementSchema = hcatField == null ? null : hcatField.getArrayElementSchema();
                        for (Schema.FieldSchema innerField : pigField.schema.getField((int)0).schema.getFields()) {
                            this.validateSchema(innerField, this.getColFromSchema(pigField.alias, arrayElementSchema), topLevelPigSchema, topLevelHCatSchema, columnPos);
                        }
                        break block22;
                    }
                    case 110: {
                        HCatSchema structSubSchema = hcatField == null ? null : hcatField.getStructSubSchema();
                        for (Schema.FieldSchema innerField : pigField.schema.getFields()) {
                            this.validateSchema(innerField, this.getColFromSchema(pigField.alias, structSubSchema), topLevelPigSchema, topLevelHCatSchema, columnPos);
                        }
                        break block22;
                    }
                    default: {
                        throw new FrontendException("Internal Error.", 1115);
                    }
                }
            }
            if (hcatField != null) {
                switch (type) {
                    case 70: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.DECIMAL}), hcatField, columnPos);
                        break;
                    }
                    case 30: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.TIMESTAMP, HCatFieldSchema.Type.DATE}), hcatField, columnPos);
                        break;
                    }
                    case 50: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.BINARY}), hcatField, columnPos);
                        break;
                    }
                    case 65: {
                        HCatBaseStorer.throwTypeMismatchException(type, Collections.emptyList(), hcatField, columnPos);
                        break;
                    }
                    case 5: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.BOOLEAN}), hcatField, columnPos);
                        break;
                    }
                    case 55: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.STRING, HCatFieldSchema.Type.CHAR, HCatFieldSchema.Type.VARCHAR}), hcatField, columnPos);
                        break;
                    }
                    case 25: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.DOUBLE}), hcatField, columnPos);
                        break;
                    }
                    case 20: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.FLOAT}), hcatField, columnPos);
                        break;
                    }
                    case 10: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.INT, HCatFieldSchema.Type.BIGINT, HCatFieldSchema.Type.TINYINT, HCatFieldSchema.Type.SMALLINT}), hcatField, columnPos);
                        break;
                    }
                    case 15: {
                        HCatBaseStorer.throwTypeMismatchException(type, Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.BIGINT}), hcatField, columnPos);
                        break;
                    }
                    default: {
                        throw new FrontendException("'" + type + "' Pig datatype in column " + columnPos + "(0-based) is not supported by HCat", 1115);
                    }
                }
            }
        }
    }

    private static void throwTypeMismatchException(byte pigDataType, List<HCatFieldSchema.Type> hcatRequiredType, HCatFieldSchema hcatActualField, int columnPos) throws FrontendException {
        if (!hcatRequiredType.contains(hcatActualField.getType())) {
            throw new FrontendException("Pig '" + DataType.findTypeName((byte)pigDataType) + "' type in column " + columnPos + "(0-based) cannot map to HCat '" + hcatActualField.getType() + "'type.  Target filed must be of HCat type {" + StringUtils.join(hcatRequiredType, (String)" or ") + "}");
        }
    }

    private void validateAlias(String alias) throws FrontendException {
        if (alias == null) {
            throw new FrontendException("Column name for a field is not specified. Please provide the full schema as an argument to HCatStorer.", 1115);
        }
        if (alias.matches(".*[A-Z]+.*")) {
            throw new FrontendException("Column names should all be in lowercase. Invalid name found: " + alias, 1115);
        }
    }

    private HCatFieldSchema getColFromSchema(String alias, HCatSchema tblSchema) {
        if (tblSchema != null) {
            for (HCatFieldSchema hcatField : tblSchema.getFields()) {
                if (hcatField == null || hcatField.getName() == null || !hcatField.getName().equalsIgnoreCase(alias)) continue;
                return hcatField;
            }
        }
        return null;
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    public void storeStatistics(ResourceStatistics stats, String arg1, Job job) throws IOException {
    }

    private static final class DataLossLogger {
        private static final Map<String, Integer> msgCount = new HashMap<String, Integer>();

        private DataLossLogger() {
        }

        private static String getColumnTypeKey(HCatFieldSchema fieldSchema) {
            return fieldSchema.getName() + "_" + (fieldSchema.getTypeInfo() == null ? fieldSchema.getType() : fieldSchema.getTypeInfo());
        }

        private void logDataLossMsg(HCatFieldSchema fieldSchema, Object pigOjb, String msg) {
            String key = DataLossLogger.getColumnTypeKey(fieldSchema);
            if (!msgCount.containsKey(key)) {
                msgCount.put(key, 0);
                LOG.warn(msg + " Will write NULL instead.  Only 1 such message per type/column is emitted.");
            }
            msgCount.put(key, msgCount.get(key) + 1);
        }
    }

    public static enum OOR_VALUE_OPT_VALUES {
        Null,
        Throw;

    }
}

