/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.filter;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.io.filter.FilterContext;

public class MutableFilterContext
extends FilterContext {
    public void setFilterContext(boolean isSelectedInUse, int[] selected, int selectedSize) {
        this.currBatchIsSelectedInUse = isSelectedInUse;
        this.currBatchSelected = selected;
        this.currBatchSelectedSize = selectedSize;
        assert (this.isValidSelected()) : "Selected array may not contain duplicates or unordered values";
    }

    public void copyFilterContextFrom(MutableFilterContext other) {
        assert (this != other) : "May not copy a FilterContext to itself";
        if (this != other) {
            if (this.currBatchSelected == null || this.currBatchSelected.length < other.currBatchSelectedSize) {
                this.currBatchSelected = Arrays.copyOf(other.currBatchSelected, other.currBatchSelected.length);
            } else {
                System.arraycopy(other.currBatchSelected, 0, this.currBatchSelected, 0, other.currBatchSelectedSize);
            }
            this.currBatchSelectedSize = other.currBatchSelectedSize;
            this.currBatchIsSelectedInUse = other.currBatchIsSelectedInUse;
        }
    }

    public boolean isValidSelected() {
        for (int i = 1; i < this.currBatchSelectedSize; ++i) {
            if (this.currBatchSelected[i - 1] < this.currBatchSelected[i]) continue;
            return false;
        }
        return true;
    }

    public int[] borrowSelected(int minCapacity) {
        int[] existing = this.currBatchSelected;
        this.currBatchSelected = null;
        if (existing == null || existing.length < minCapacity) {
            return new int[minCapacity];
        }
        return existing;
    }

    public FilterContext immutable() {
        return this;
    }

    public void setSelectedInUse(boolean selectedInUse) {
        this.currBatchIsSelectedInUse = selectedInUse;
    }

    public void setSelected(int[] selectedArray) {
        this.currBatchSelected = selectedArray;
    }

    public void setSelectedSize(int selectedSize) {
        this.currBatchSelectedSize = selectedSize;
    }
}

