/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class HBaseCommonTestingUtility {
    protected static final Log LOG = LogFactory.getLog(HBaseCommonTestingUtility.class);
    public static final List<Object[]> COMPRESSION_ALGORITHMS_PARAMETERIZED = Arrays.asList({Compression.Algorithm.NONE}, {Compression.Algorithm.GZ});
    public static final List<Object[]> BOOLEAN_PARAMETERIZED = Arrays.asList({false}, {true});
    public static final Compression.Algorithm[] COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
    protected Configuration conf;
    public static final String BASE_TEST_DIRECTORY_KEY = "test.build.data.basedirectory";
    public static final String DEFAULT_BASE_TEST_DIRECTORY = "target/test-data";
    private File dataTestDir = null;

    public HBaseCommonTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public HBaseCommonTestingUtility(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Path getDataTestDir() {
        if (this.dataTestDir == null) {
            this.setupDataTestDir();
        }
        return new Path(this.dataTestDir.getAbsolutePath());
    }

    public Path getDataTestDir(String subdirName) {
        return new Path(this.getDataTestDir(), subdirName);
    }

    protected Path setupDataTestDir() {
        if (this.dataTestDir != null) {
            LOG.warn((Object)("Data test dir already setup in " + this.dataTestDir.getAbsolutePath()));
            return null;
        }
        Path testPath = this.getRandomDir();
        this.dataTestDir = new File(testPath.toString()).getAbsoluteFile();
        System.setProperty("test.build.dir", this.dataTestDir.toString());
        if (this.deleteOnExit()) {
            this.dataTestDir.deleteOnExit();
        }
        this.createSubDir("hbase.local.dir", testPath, "hbase-local-dir");
        return testPath;
    }

    public Path getRandomDir() {
        return new Path(this.getBaseTestDir(), UUID.randomUUID().toString());
    }

    protected void createSubDir(String propertyName, Path parent, String subDirName) {
        Path newPath = new Path(parent, subDirName);
        File newDir = new File(newPath.toString()).getAbsoluteFile();
        if (this.deleteOnExit()) {
            newDir.deleteOnExit();
        }
        this.conf.set(propertyName, newDir.getAbsolutePath());
    }

    boolean deleteOnExit() {
        String v = System.getProperty("hbase.testing.preserve.testdir");
        return v == null ? true : !Boolean.parseBoolean(v);
    }

    public boolean cleanupTestDir() throws IOException {
        if (this.deleteDir(this.dataTestDir)) {
            this.dataTestDir = null;
            return true;
        }
        return false;
    }

    boolean cleanupTestDir(String subdir) throws IOException {
        if (this.dataTestDir == null) {
            return false;
        }
        return this.deleteDir(new File(this.dataTestDir, subdir));
    }

    private Path getBaseTestDir() {
        String PathName = System.getProperty(BASE_TEST_DIRECTORY_KEY, DEFAULT_BASE_TEST_DIRECTORY);
        return new Path(PathName);
    }

    boolean deleteDir(File dir) throws IOException {
        if (dir == null || !dir.exists()) {
            return true;
        }
        int ntries = 0;
        do {
            ++ntries;
            try {
                if (this.deleteOnExit()) {
                    FileUtils.deleteDirectory((File)dir);
                }
                return true;
            }
            catch (IOException ex) {
                LOG.warn((Object)("Failed to delete " + dir.getAbsolutePath()));
            }
            catch (IllegalArgumentException ex) {
                LOG.warn((Object)("Failed to delete " + dir.getAbsolutePath()), (Throwable)ex);
            }
        } while (ntries < 30);
        return ntries < 30;
    }
}

