/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;

public class QueriesRESTfulAPIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(QueriesRESTfulAPIServlet.class);
    private static final String API_V1 = "v1";
    private static final String REQ_QUERIES = "queries";
    private static final String REQ_SESSIONS = "sessions";
    private static final String REQ_ACTIVE = "active";
    private static final String REQ_HISTORICAL = "historical";

    /*
     * Enabled aggressive block sorting
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || "/".equals(pathInfo)) {
            this.sendError(response, 400, "Path to the endpoint is missing");
            return;
        }
        String[] splits = pathInfo.split("/");
        if (splits.length < 3) {
            this.sendError(response, 400, "Expecting at least 2 parts in the path");
            return;
        }
        ServletContext ctx = this.getServletContext();
        SessionManager sessionManager = (SessionManager)ctx.getAttribute("hive.sm");
        OperationManager operationManager = sessionManager.getOperationManager();
        String apiVersion = splits[1];
        if (!apiVersion.equals(API_V1)) {
            this.sendError(response, 400, "This server only handles API v1");
            return;
        }
        String reqType = splits[2];
        if (reqType.equals(REQ_QUERIES)) {
            if (splits.length != 4) {
                this.sendError(response, 404, "Expecting 3 parts in the path: /v1/queries/active or /v1/queries/historical");
                return;
            }
            String queriesType = splits[3];
            if (queriesType.equals(REQ_ACTIVE)) {
                List<QueryInfo> operations = operationManager.getLiveQueryInfos();
                LOG.info((Object)"Returning active SQL operations via the RESTful API");
                this.sendAsJson(response, operations);
                return;
            }
            if (queriesType.equals(REQ_HISTORICAL)) {
                List<QueryInfo> operations = operationManager.getHistoricalQueryInfos();
                LOG.info((Object)"Returning historical SQL operations via the RESTful API");
                this.sendAsJson(response, operations);
                return;
            }
            this.sendError(response, 400, "Unknown query type: " + queriesType);
            return;
        }
        if (reqType.equals(REQ_SESSIONS)) {
            Collection<HiveSession> hiveSessions = sessionManager.getSessions();
            LOG.info((Object)"Returning active sessions via the RESTful API");
            this.sendAsJson(response, hiveSessions);
            return;
        }
        this.sendError(response, 404, "Unknown request type: " + reqType);
    }

    private void sendError(HttpServletResponse response, Integer errorCode, String message) {
        response.setStatus(errorCode.intValue());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            response.getWriter().write("{\"message\" : " + message + "}");
        }
        catch (IOException e) {
            LOG.error((Object)"Caught an exception while writing an HTTP error status", (Throwable)e);
            response.setStatus(500);
        }
    }

    private void sendAsJson(HttpServletResponse response, Object obj) {
        response.setContentType("application/json");
        response.setStatus(200);
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("CustomSessionModule", new Version(1, 0, 0, null));
        module.addSerializer(HiveSession.class, (JsonSerializer)new HiveSessionSerializer());
        mapper.registerModule((Module)module);
        try {
            PrintWriter out = response.getWriter();
            String objectAsJson = mapper.writeValueAsString(obj);
            out.print(objectAsJson);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Caught an exception while writing an HTTP response", (Throwable)e);
            response.setStatus(500);
        }
    }

    private static class HiveSessionSerializer
    extends JsonSerializer<HiveSession> {
        private HiveSessionSerializer() {
        }

        public void serialize(HiveSession hiveSession, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            long currentTime = System.currentTimeMillis();
            jgen.writeStartObject();
            jgen.writeStringField("sessionId", hiveSession.getSessionHandle().getSessionId().toString());
            jgen.writeStringField("username", hiveSession.getUserName());
            jgen.writeStringField("ipAddress", hiveSession.getIpAddress());
            jgen.writeNumberField("operationCount", hiveSession.getOpenOperationCount());
            jgen.writeNumberField("activeTime", (currentTime - hiveSession.getCreationTime()) / 1000L);
            jgen.writeNumberField("idleTime", (currentTime - hiveSession.getLastAccessTime()) / 1000L);
            jgen.writeEndObject();
        }
    }
}

