/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillQueryImpl
implements KillQuery {
    private static final Logger LOG = LoggerFactory.getLogger(KillQueryImpl.class);
    private final OperationManager operationManager;

    public KillQueryImpl(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    public static Set<ApplicationId> getChildYarnJobs(Configuration conf, String tag) throws IOException, YarnException {
        HashSet<ApplicationId> childYarnJobs = new HashSet<ApplicationId>();
        GetApplicationsRequest gar = GetApplicationsRequest.newInstance();
        gar.setScope(ApplicationsRequestScope.OWN);
        gar.setApplicationTags(Collections.singleton(tag));
        ApplicationClientProtocol proxy = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationClientProtocol.class);
        GetApplicationsResponse apps = proxy.getApplications(gar);
        List appsList = apps.getApplicationList();
        for (ApplicationReport appReport : appsList) {
            if (!KillQueryImpl.isAdmin() && !appReport.getApplicationTags().contains("userid=" + SessionState.get().getUserName())) continue;
            childYarnJobs.add(appReport.getApplicationId());
        }
        if (childYarnJobs.isEmpty()) {
            LOG.info("No child applications found");
        } else {
            LOG.info("Found child YARN applications: " + StringUtils.join(childYarnJobs, (String)","));
        }
        return childYarnJobs;
    }

    public static void killChildYarnJobs(Configuration conf, String tag) {
        try {
            if (tag == null) {
                return;
            }
            LOG.info("Killing yarn jobs using query tag:" + tag);
            Set<ApplicationId> childYarnJobs = KillQueryImpl.getChildYarnJobs(conf, tag);
            if (!childYarnJobs.isEmpty()) {
                YarnClient yarnClient = YarnClient.createYarnClient();
                yarnClient.init(conf);
                yarnClient.start();
                for (ApplicationId app : childYarnJobs) {
                    yarnClient.killApplication(app);
                }
            }
        }
        catch (IOException | YarnException ye) {
            LOG.warn("Exception occurred while killing child job({})", ye);
        }
    }

    private static boolean isAdmin() {
        boolean isAdmin = false;
        if (SessionState.get().getAuthorizerV2() != null) {
            try {
                SessionState.get().getAuthorizerV2().checkPrivileges(HiveOperationType.KILL_QUERY, new ArrayList(), new ArrayList(), new HiveAuthzContext.Builder().build());
                isAdmin = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isAdmin;
    }

    private boolean cancelOperation(Operation operation, boolean isAdmin, String errMsg) throws HiveSQLException {
        if (isAdmin || operation.getParentSession().getUserName().equals(SessionState.get().getAuthenticator().getUserName())) {
            OperationHandle handle = operation.getHandle();
            this.operationManager.cancelOperation(handle, errMsg);
            return true;
        }
        return false;
    }

    public void killQuery(String queryIdOrTag, String errMsg, HiveConf conf) throws HiveException {
        try {
            TagOrId tagOrId = TagOrId.UNKNOWN;
            HashSet<Operation> operationsToKill = new HashSet<Operation>();
            if (this.operationManager.getOperationByQueryId(queryIdOrTag) != null) {
                operationsToKill.add(this.operationManager.getOperationByQueryId(queryIdOrTag));
                tagOrId = TagOrId.ID;
            } else {
                operationsToKill.addAll(this.operationManager.getOperationsByQueryTag(queryIdOrTag));
                if (!operationsToKill.isEmpty()) {
                    tagOrId = TagOrId.TAG;
                }
            }
            if (operationsToKill.isEmpty()) {
                LOG.info("Query not found: " + queryIdOrTag);
            }
            boolean admin = KillQueryImpl.isAdmin();
            switch (tagOrId) {
                case ID: {
                    Operation operation = (Operation)operationsToKill.iterator().next();
                    boolean canceled = this.cancelOperation(operation, admin, errMsg);
                    if (canceled) {
                        String queryTag = operation.getQueryTag();
                        if (queryTag == null) {
                            queryTag = queryIdOrTag;
                        }
                        KillQueryImpl.killChildYarnJobs((Configuration)conf, queryTag);
                        break;
                    }
                    throw new HiveSQLException("No privilege to kill query id");
                }
                case TAG: {
                    int numCanceled = 0;
                    for (Operation operationToKill : operationsToKill) {
                        if (!this.cancelOperation(operationToKill, admin, errMsg)) continue;
                        ++numCanceled;
                    }
                    KillQueryImpl.killChildYarnJobs((Configuration)conf, queryIdOrTag);
                    if (numCanceled != 0) break;
                    throw new HiveSQLException("No privilege to kill query tag");
                }
                case UNKNOWN: {
                    KillQueryImpl.killChildYarnJobs((Configuration)conf, queryIdOrTag);
                }
            }
        }
        catch (HiveSQLException e) {
            LOG.error("Kill query failed for query " + queryIdOrTag, (Throwable)e);
            throw new HiveException(e.getMessage(), (Throwable)e);
        }
    }

    private static enum TagOrId {
        TAG,
        ID,
        UNKNOWN;

    }
}

