/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.ColumnTypeAttributes;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.client.PartialRow;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DataGenerator {
    private final Random random;
    private final int stringLength;
    private final int binaryLength;
    private final float nullRate;
    private final float defaultRate;

    private DataGenerator(Random random, int stringLength, int binaryLength, float nullRate, float defaultRate) {
        this.random = random;
        this.stringLength = stringLength;
        this.binaryLength = binaryLength;
        this.nullRate = nullRate;
        this.defaultRate = defaultRate;
    }

    public void randomizeRow(PartialRow row) {
        this.randomizeRow(row, true);
    }

    public void randomizeRow(PartialRow row, boolean randomizeKeys) {
        Schema schema = row.getSchema();
        List<ColumnSchema> columns = schema.getColumns();
        block12: for (int i = 0; i < columns.size(); ++i) {
            ColumnSchema col = columns.get(i);
            if (col.isKey() && !randomizeKeys) continue;
            Type type = col.getType();
            if (col.isNullable() && this.random.nextFloat() <= this.nullRate) {
                row.setNull(i);
                continue;
            }
            if (col.getDefaultValue() != null && !col.isKey() && this.random.nextFloat() <= this.defaultRate) continue;
            switch (type) {
                case BOOL: {
                    row.addBoolean(i, this.random.nextBoolean());
                    continue block12;
                }
                case INT8: {
                    row.addByte(i, (byte)this.random.nextInt());
                    continue block12;
                }
                case INT16: {
                    row.addShort(i, (short)this.random.nextInt());
                    continue block12;
                }
                case INT32: {
                    row.addInt(i, this.random.nextInt());
                    continue block12;
                }
                case INT64: 
                case UNIXTIME_MICROS: {
                    row.addLong(i, this.random.nextLong());
                    continue block12;
                }
                case FLOAT: {
                    row.addFloat(i, this.random.nextFloat());
                    continue block12;
                }
                case DOUBLE: {
                    row.addDouble(i, this.random.nextDouble());
                    continue block12;
                }
                case DECIMAL: {
                    row.addDecimal(i, DataGenerator.randomDecimal(col.getTypeAttributes(), this.random));
                    continue block12;
                }
                case STRING: {
                    row.addString(i, DataGenerator.randomString(this.stringLength, this.random));
                    continue block12;
                }
                case BINARY: {
                    row.addBinary(i, DataGenerator.randomBinary(this.binaryLength, this.random));
                    continue block12;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type " + (Object)((Object)type));
                }
            }
        }
    }

    public static BigDecimal randomDecimal(ColumnTypeAttributes attributes, Random random) {
        int numBits = BigInteger.TEN.pow(attributes.getPrecision()).subtract(BigInteger.ONE).bitCount();
        BigInteger randomUnscaled = new BigInteger(numBits, random);
        return new BigDecimal(randomUnscaled, attributes.getScale());
    }

    public static String randomString(int length, Random random) {
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    public static byte[] randomBinary(int length, Random random) {
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static class DataGeneratorBuilder {
        private Random random = new Random(System.currentTimeMillis());
        private int stringLength = 128;
        private int binaryLength = 128;
        private float nullRate = 0.1f;
        private float defaultRate = 0.1f;

        public DataGeneratorBuilder random(Random random) {
            this.random = random;
            return this;
        }

        public DataGeneratorBuilder stringLength(int stringLength) {
            this.stringLength = stringLength;
            return this;
        }

        public DataGeneratorBuilder binaryLength(int binaryLength) {
            this.binaryLength = binaryLength;
            return this;
        }

        public DataGeneratorBuilder nullRate(float nullRate) {
            Preconditions.checkArgument(nullRate >= 0.0f && nullRate <= 1.0f, "nullRate must be between 0 and 1");
            this.nullRate = nullRate;
            return this;
        }

        public DataGeneratorBuilder defaultRate(float defaultRate) {
            Preconditions.checkArgument(defaultRate >= 0.0f && defaultRate <= 1.0f, "defaultRate must be between 0 and 1");
            this.defaultRate = defaultRate;
            return this;
        }

        public DataGenerator build() {
            return new DataGenerator(this.random, this.stringLength, this.binaryLength, this.nullRate, this.defaultRate);
        }
    }
}

