/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.ipfilter.IpSet;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpV4Subnet
implements IpSet,
Comparable<IpV4Subnet> {
    private static final int SUBNET_MASK = Integer.MIN_VALUE;
    private InetAddress inetAddress;
    private int subnet;
    private int mask;
    private int cidrMask;

    public IpV4Subnet() {
        this.mask = -1;
        this.inetAddress = null;
        this.subnet = 0;
        this.cidrMask = 0;
    }

    public IpV4Subnet(String netAddress) throws UnknownHostException {
        this.setNetAddress(netAddress);
    }

    public IpV4Subnet(InetAddress inetAddress, int cidrNetMask) {
        this.setNetAddress(inetAddress, cidrNetMask);
    }

    public IpV4Subnet(InetAddress inetAddress, String netMask) {
        this.setNetAddress(inetAddress, netMask);
    }

    private void setNetAddress(String netAddress) throws UnknownHostException {
        String[] tokens = StringUtil.split(netAddress, '/');
        if (tokens.length != 2) {
            throw new IllegalArgumentException("netAddress: " + netAddress + " (expected: CIDR or Decimal Notation)");
        }
        if (tokens[1].length() < 3) {
            this.setNetId(tokens[0]);
            this.setCidrNetMask(Integer.parseInt(tokens[1]));
        } else {
            this.setNetId(tokens[0]);
            this.setNetMask(tokens[1]);
        }
    }

    private void setNetAddress(InetAddress inetAddress, int cidrNetMask) {
        this.setNetId(inetAddress);
        this.setCidrNetMask(cidrNetMask);
    }

    private void setNetAddress(InetAddress inetAddress, String netMask) {
        this.setNetId(inetAddress);
        this.setNetMask(netMask);
    }

    private void setNetId(String netId) throws UnknownHostException {
        InetAddress inetAddress1 = InetAddress.getByName(netId);
        this.setNetId(inetAddress1);
    }

    private static int toInt(InetAddress inetAddress1) {
        byte[] octets = inetAddress1.getAddress();
        assert (octets.length == 4);
        return (octets[0] & 0xFF) << 24 | (octets[1] & 0xFF) << 16 | (octets[2] & 0xFF) << 8 | octets[3] & 0xFF;
    }

    private void setNetId(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        this.subnet = IpV4Subnet.toInt(inetAddress);
    }

    private void setNetMask(String netMask) {
        StringTokenizer nm = new StringTokenizer(netMask, ".");
        int i = 0;
        int[] netmask = new int[4];
        while (nm.hasMoreTokens()) {
            netmask[i] = Integer.parseInt(nm.nextToken());
            ++i;
        }
        int mask1 = 0;
        for (i = 0; i < 4; ++i) {
            mask1 += Integer.bitCount(netmask[i]);
        }
        this.setCidrNetMask(mask1);
    }

    private void setCidrNetMask(int cidrNetMask) {
        this.cidrMask = cidrNetMask;
        this.mask = Integer.MIN_VALUE >> this.cidrMask - 1;
    }

    public boolean contains(String ipAddr) throws UnknownHostException {
        InetAddress inetAddress1 = InetAddress.getByName(ipAddr);
        return this.contains(inetAddress1);
    }

    @Override
    public boolean contains(InetAddress inetAddress1) {
        return (IpV4Subnet.toInt(inetAddress1) & this.mask) == this.subnet;
    }

    public String toString() {
        return this.inetAddress.getHostAddress() + '/' + this.cidrMask;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IpV4Subnet)) {
            return false;
        }
        IpV4Subnet ipV4Subnet = (IpV4Subnet)o;
        return ipV4Subnet.subnet == this.subnet && ipV4Subnet.cidrMask == this.cidrMask;
    }

    public int hashCode() {
        return this.subnet;
    }

    @Override
    public int compareTo(IpV4Subnet o) {
        if (o.subnet == this.subnet && o.cidrMask == this.cidrMask) {
            return 0;
        }
        if (o.subnet < this.subnet) {
            return 1;
        }
        if (o.subnet > this.subnet) {
            return -1;
        }
        if (o.cidrMask < this.cidrMask) {
            return -1;
        }
        return 1;
    }
}

