/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.execution;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.execution.ChannelEventRunnableFilter;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.util.ExternalResourceReleasable;

public class ChainedExecutor
implements Executor,
ExternalResourceReleasable {
    private final Executor cur;
    private final Executor next;
    private final ChannelEventRunnableFilter filter;

    public ChainedExecutor(ChannelEventRunnableFilter filter, Executor cur, Executor next) {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        if (cur == null) {
            throw new NullPointerException("cur");
        }
        if (next == null) {
            throw new NullPointerException("next");
        }
        this.filter = filter;
        this.cur = cur;
        this.next = next;
    }

    public void execute(Runnable command) {
        assert (command instanceof ChannelEventRunnable);
        if (this.filter.filter((ChannelEventRunnable)command)) {
            this.cur.execute(command);
        } else {
            this.next.execute(command);
        }
    }

    public void releaseExternalResources() {
        if (this.cur instanceof ExecutorService) {
            ((ExecutorService)this.cur).shutdown();
        }
        if (this.next instanceof ExecutorService) {
            ((ExecutorService)this.next).shutdown();
        }
        ChainedExecutor.releaseExternal(this.cur);
        ChainedExecutor.releaseExternal(this.next);
    }

    private static void releaseExternal(Executor executor) {
        if (executor instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)executor)).releaseExternalResources();
        }
    }
}

