/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.marshalling;

import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.Channel;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ExceptionEvent;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.marshalling.ChannelBufferByteInput;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.marshalling.LimitingByteInput;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.marshalling.UnmarshallerProvider;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.replay.VoidEnum;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleMarshallingDecoder
extends ReplayingDecoder<VoidEnum> {
    protected final UnmarshallerProvider provider;
    protected final int maxObjectSize;
    private boolean discardingTooLongFrame;

    public CompatibleMarshallingDecoder(UnmarshallerProvider provider, int maxObjectSize) {
        this.provider = provider;
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        if (this.discardingTooLongFrame) {
            buffer.skipBytes(this.actualReadableBytes());
            this.checkpoint();
            return null;
        }
        Unmarshaller unmarshaller = this.provider.getUnmarshaller(ctx);
        Object input = new ChannelBufferByteInput(buffer);
        if (this.maxObjectSize != Integer.MAX_VALUE) {
            input = new LimitingByteInput((ByteInput)input, this.maxObjectSize);
        }
        try {
            unmarshaller.start((ByteInput)input);
            Object obj = unmarshaller.readObject();
            unmarshaller.finish();
            Object object = obj;
            return object;
        }
        catch (LimitingByteInput.TooBigObjectException e) {
            this.discardingTooLongFrame = true;
            throw new TooLongFrameException();
        }
        finally {
            unmarshaller.close();
        }
    }

    @Override
    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        switch (buffer.readableBytes()) {
            case 0: {
                return null;
            }
            case 1: {
                if (buffer.getByte(buffer.readerIndex()) != 121) break;
                buffer.skipBytes(1);
                return null;
            }
        }
        Object decoded = this.decode(ctx, channel, buffer, state);
        return decoded;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof TooLongFrameException) {
            e.getChannel().close();
        } else {
            super.exceptionCaught(ctx, e);
        }
    }
}

