/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.local;

import java.net.SocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalAddress
extends SocketAddress
implements Comparable<LocalAddress> {
    private static final long serialVersionUID = -3601961747680808645L;
    public static final String EPHEMERAL = "ephemeral";
    private final String id;
    private final boolean ephemeral;

    public LocalAddress(int id) {
        this(String.valueOf(id));
    }

    public LocalAddress(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if ((id = id.trim().toLowerCase()).length() == 0) {
            throw new IllegalArgumentException("empty id");
        }
        this.id = id;
        this.ephemeral = EPHEMERAL.equals(id);
    }

    public String getId() {
        return this.id;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public int hashCode() {
        if (this.ephemeral) {
            return System.identityHashCode(this);
        }
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalAddress)) {
            return false;
        }
        if (this.ephemeral) {
            return this == o;
        }
        return this.getId().equals(((LocalAddress)o).getId());
    }

    @Override
    public int compareTo(LocalAddress o) {
        if (this.ephemeral) {
            if (o.ephemeral) {
                int b;
                if (this == o) {
                    return 0;
                }
                int a = System.identityHashCode(this);
                if (a < (b = System.identityHashCode(o))) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                throw new Error("Two different ephemeral addresses have same identityHashCode.");
            }
            return 1;
        }
        if (o.ephemeral) {
            return -1;
        }
        return this.getId().compareTo(o.getId());
    }

    public String toString() {
        return "local:" + this.getId();
    }
}

