/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel;

import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelEvent;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandler;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelPipeline;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelUpstreamHandler;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChildChannelStateEvent;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.DefaultChannelPipeline;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ExceptionEvent;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.MessageEvent;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.WriteCompletionEvent;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.logging.InternalLogger;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.logging.InternalLoggerFactory;

public class SimpleChannelUpstreamHandler
implements ChannelUpstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SimpleChannelUpstreamHandler.class.getName());

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent) {
            this.messageReceived(ctx, (MessageEvent)e);
        } else if (e instanceof WriteCompletionEvent) {
            WriteCompletionEvent evt = (WriteCompletionEvent)e;
            this.writeComplete(ctx, evt);
        } else if (e instanceof ChildChannelStateEvent) {
            ChildChannelStateEvent evt = (ChildChannelStateEvent)e;
            if (evt.getChildChannel().isOpen()) {
                this.childChannelOpen(ctx, evt);
            } else {
                this.childChannelClosed(ctx, evt);
            }
        } else if (e instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e;
            switch (evt.getState()) {
                case OPEN: {
                    if (Boolean.TRUE.equals(evt.getValue())) {
                        this.channelOpen(ctx, evt);
                        break;
                    }
                    this.channelClosed(ctx, evt);
                    break;
                }
                case BOUND: {
                    if (evt.getValue() != null) {
                        this.channelBound(ctx, evt);
                        break;
                    }
                    this.channelUnbound(ctx, evt);
                    break;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) {
                        this.channelConnected(ctx, evt);
                        break;
                    }
                    this.channelDisconnected(ctx, evt);
                    break;
                }
                case INTEREST_OPS: {
                    this.channelInterestChanged(ctx, evt);
                    break;
                }
                default: {
                    ctx.sendUpstream(e);
                    break;
                }
            }
        } else if (e instanceof ExceptionEvent) {
            this.exceptionCaught(ctx, (ExceptionEvent)e);
        } else {
            ctx.sendUpstream(e);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ChannelPipeline pipeline = ctx.getPipeline();
        ChannelHandler last = pipeline.getLast();
        if (!(last instanceof ChannelUpstreamHandler) && ctx instanceof DefaultChannelPipeline) {
            List<String> names = ctx.getPipeline().getNames();
            for (int i = names.size() - 1; i >= 0; --i) {
                ChannelHandler handler = ctx.getPipeline().get(names.get(i));
                if (!(handler instanceof ChannelUpstreamHandler)) continue;
                last = handler;
                break;
            }
        }
        if (this == last) {
            logger.warn("EXCEPTION, please implement " + this.getClass().getName() + ".exceptionCaught() for proper handling.", e.getCause());
        }
        ctx.sendUpstream(e);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelUnbound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void childChannelClosed(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }
}

