/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.kudu.org.apache.kudu.client.HostAndPort;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.util.NetUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ServerInfo {
    private final String uuid;
    private final HostAndPort hostPort;
    private final InetSocketAddress resolvedAddr;
    private final String location;
    private final boolean local;
    private static final ConcurrentHashMap<InetAddress, Boolean> isLocalAddressCache = new ConcurrentHashMap();

    public ServerInfo(String uuid, HostAndPort hostPort, InetAddress resolvedAddr, String location) {
        Preconditions.checkNotNull(uuid);
        Preconditions.checkArgument(hostPort.getPort() > 0);
        Preconditions.checkNotNull(location);
        this.uuid = uuid;
        this.hostPort = hostPort;
        this.resolvedAddr = new InetSocketAddress(resolvedAddr, hostPort.getPort());
        this.location = location;
        Boolean isLocal = isLocalAddressCache.get(resolvedAddr);
        if (isLocal == null) {
            isLocal = NetUtil.isLocalAddress(resolvedAddr);
            isLocalAddressCache.put(resolvedAddr, isLocal);
        }
        this.local = isLocal;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAndCanonicalizeHostname() {
        try {
            return InetAddress.getByName(this.hostPort.getHost()).getCanonicalHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            return this.hostPort.getHost();
        }
    }

    public HostAndPort getHostAndPort() {
        return this.hostPort;
    }

    public int getPort() {
        return this.hostPort.getPort();
    }

    public String getLocation() {
        return this.location;
    }

    public boolean inSameLocation(String loc) {
        Preconditions.checkNotNull(loc);
        return !loc.isEmpty() && loc.equals(this.location);
    }

    public boolean isLocal() {
        return this.local;
    }

    public InetSocketAddress getResolvedAddress() {
        return this.resolvedAddr;
    }

    public String toString() {
        return this.uuid + "(" + this.hostPort + ")";
    }
}

