/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hive.kudu.org.apache.kudu.client.LocatedTablet;
import org.apache.hive.kudu.org.apache.kudu.client.Partition;
import org.apache.hive.kudu.org.apache.kudu.client.ReplicaSelection;
import org.apache.hive.kudu.org.apache.kudu.client.ServerInfo;
import org.apache.hive.kudu.org.apache.kudu.consensus.Metadata;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Objects;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ComparisonChain;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RemoteTablet
implements Comparable<RemoteTablet> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTablet.class);
    private final String tableId;
    private final String tabletId;
    @GuardedBy(value="tabletServers")
    private final Map<String, ServerInfo> tabletServers;
    private final AtomicReference<List<LocatedTablet.Replica>> replicas = new AtomicReference(ImmutableList.of());
    private final Partition partition;
    @GuardedBy(value="tabletServers")
    private String leaderUuid;

    RemoteTablet(String tableId, String tabletId, Partition partition, List<Master.TabletLocationsPB.ReplicaPB> replicas, List<ServerInfo> serverInfos) {
        this.tabletId = tabletId;
        this.tableId = tableId;
        this.partition = partition;
        this.tabletServers = new HashMap<String, ServerInfo>(serverInfos.size());
        for (ServerInfo serverInfo : serverInfos) {
            this.tabletServers.put(serverInfo.getUuid(), serverInfo);
        }
        ImmutableList.Builder replicasBuilder = new ImmutableList.Builder();
        for (Master.TabletLocationsPB.ReplicaPB replica : replicas) {
            String uuid = replica.getTsInfo().getPermanentUuid().toStringUtf8();
            replicasBuilder.add(new LocatedTablet.Replica(replica));
            if (!replica.getRole().equals(Metadata.RaftPeerPB.Role.LEADER)) continue;
            this.leaderUuid = uuid;
        }
        if (this.leaderUuid == null) {
            LOG.warn("No leader provided for tablet {}", (Object)this.getTabletId());
        }
        this.replicas.set((List<LocatedTablet.Replica>)((Object)replicasBuilder.build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList<String> tsStrings;
        StringBuilder sb = new StringBuilder();
        sb.append(this.tabletId).append("@[");
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            tsStrings = new ArrayList<String>(this.tabletServers.size());
            for (ServerInfo e : this.tabletServers.values()) {
                String flag = e.getUuid().equals(this.leaderUuid) ? "[L]" : "";
                tsStrings.add(e.toString() + flag);
            }
        }
        Collections.sort(tsStrings);
        sb.append(Joiner.on(',').join(tsStrings));
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeTabletClient(String uuid) {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            if (this.leaderUuid != null && this.leaderUuid.equals(uuid)) {
                this.leaderUuid = null;
            }
            if (this.tabletServers.remove(uuid) != null) {
                return true;
            }
            LOG.debug("tablet {} already removed ts {}, size left is {}", new Object[]{this.getTabletId(), uuid, this.tabletServers.size()});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void demoteLeader(String uuid) {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            if (this.leaderUuid == null) {
                LOG.debug("{} couldn't be demoted as the leader for {}, there is no known leader", (Object)uuid, (Object)this.getTabletId());
                return;
            }
            if (this.leaderUuid.equals(uuid)) {
                this.leaderUuid = null;
                LOG.debug("{} was demoted as the leader for {}", (Object)uuid, (Object)this.getTabletId());
            } else {
                LOG.debug("{} wasn't the leader for {}, current leader is {}", new Object[]{uuid, this.getTabletId(), this.leaderUuid});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ServerInfo getLeaderServerInfo() {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            return this.tabletServers.get(this.leaderUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ServerInfo getClosestServerInfo(String location) {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            ServerInfo last = null;
            ServerInfo lastInSameLocation = null;
            Iterator<ServerInfo> iterator = this.tabletServers.values().iterator();
            while (iterator.hasNext()) {
                ServerInfo e;
                last = e = iterator.next();
                if (e.isLocal()) {
                    return e;
                }
                if (!e.inSameLocation(location)) continue;
                lastInSameLocation = e;
            }
            if (lastInSameLocation != null) {
                return lastInSameLocation;
            }
            return last;
        }
    }

    @Nullable
    ServerInfo getReplicaSelectedServerInfo(ReplicaSelection replicaSelection, String location) {
        switch (replicaSelection) {
            case LEADER_ONLY: {
                return this.getLeaderServerInfo();
            }
            case CLOSEST_REPLICA: {
                return this.getClosestServerInfo(location);
            }
        }
        throw new RuntimeException("unknown replica selection mechanism " + (Object)((Object)replicaSelection));
    }

    List<LocatedTablet.Replica> getReplicas() {
        return this.replicas.get();
    }

    public String getTableId() {
        return this.tableId;
    }

    String getTabletId() {
        return this.tabletId;
    }

    public Partition getPartition() {
        return this.partition;
    }

    byte[] getTabletIdAsBytes() {
        return this.tabletId.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public int compareTo(RemoteTablet remoteTablet) {
        if (remoteTablet == null) {
            return 1;
        }
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.tableId), (Comparable<?>)((Object)remoteTablet.tableId)).compare(this.partition, remoteTablet.partition).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTablet)) {
            return false;
        }
        RemoteTablet that = (RemoteTablet)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.tableId, this.partition);
    }
}

