/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.WireProtocol;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.CreateTableOptions;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.client.OperationResponse;
import org.apache.hive.kudu.org.apache.kudu.client.PartialRow;
import org.apache.hive.kudu.org.apache.kudu.client.ProtobufHelper;
import org.apache.hive.kudu.org.apache.kudu.client.RangePartitionBound;
import org.apache.hive.kudu.org.apache.kudu.client.Statistics;
import org.apache.hive.kudu.org.apache.kudu.security.Token;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.tserver.Tserver;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Operation
extends KuduRpc<OperationResponse> {
    private long rowOperationSizeBytes = 0L;
    static final String METHOD = "Write";
    private PartialRow row;
    private Token.SignedTokenPB authzToken;
    boolean ignoreAllDuplicateRows = false;
    boolean ignoreAllNotFoundRows = false;

    Operation(KuduTable table) {
        super(table, null, 0L);
        this.row = table.getSchema().newPartialRow();
    }

    void resetTimeoutMillis(Timer timer, long timeoutMillis) {
        this.timeoutTracker.reset();
        this.timeoutTracker.setTimeout(timeoutMillis);
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.timeoutTask = AsyncKuduClient.newTimeout(timer, new KuduRpc.RpcTimeoutTask(), timeoutMillis);
    }

    void setIgnoreAllDuplicateRows(boolean ignoreAllDuplicateRows) {
        this.ignoreAllDuplicateRows = ignoreAllDuplicateRows;
    }

    void setIgnoreAllNotFoundRows(boolean ignoreAllNotFoundRows) {
        this.ignoreAllNotFoundRows = ignoreAllNotFoundRows;
    }

    abstract ChangeType getChangeType();

    long getRowOperationSizeBytes() {
        if (this.rowOperationSizeBytes == 0L) {
            throw new IllegalStateException("This row hasn't been serialized yet");
        }
        return this.rowOperationSizeBytes;
    }

    @Override
    String serviceName() {
        return "kudu.tserver.TabletServerService";
    }

    @Override
    String method() {
        return METHOD;
    }

    @Override
    boolean needsAuthzToken() {
        return true;
    }

    @Override
    void bindAuthzToken(Token.SignedTokenPB token) {
        this.authzToken = token;
    }

    @Override
    Message createRequestPB() {
        Tserver.WriteRequestPB.Builder builder = Operation.createAndFillWriteRequestPB(ImmutableList.of(this));
        this.rowOperationSizeBytes = (long)builder.getRowOperations().getRows().size() + (long)builder.getRowOperations().getIndirectData().size();
        builder.setTabletId(UnsafeByteOperations.unsafeWrap(this.getTablet().getTabletIdAsBytes()));
        builder.setExternalConsistencyMode(this.externalConsistencyMode.pbVersion());
        if (this.propagatedTimestamp != -1L) {
            builder.setPropagatedTimestamp(this.propagatedTimestamp);
        }
        if (this.authzToken != null) {
            builder.setAuthzToken(this.authzToken);
        }
        return builder.build();
    }

    @Override
    Pair<OperationResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Tserver.WriteResponsePB.Builder builder = Tserver.WriteResponsePB.newBuilder();
        Operation.readProtobuf(callResponse.getPBMessage(), builder);
        Tserver.WriteResponsePB.PerRowErrorPB error = null;
        if (builder.getPerRowErrorsCount() != 0) {
            error = builder.getPerRowErrors(0);
            WireProtocol.AppStatusPB.ErrorCode errorCode = error.getError().getCode();
            if (this.ignoreAllDuplicateRows && errorCode == WireProtocol.AppStatusPB.ErrorCode.ALREADY_PRESENT || this.ignoreAllNotFoundRows && errorCode == WireProtocol.AppStatusPB.ErrorCode.NOT_FOUND) {
                error = null;
            }
        }
        OperationResponse response = new OperationResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, builder.getTimestamp(), this, error);
        return new Pair<OperationResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    public byte[] partitionKey() {
        return this.getTable().getPartitionSchema().encodePartitionKey(this.row);
    }

    @Override
    boolean isRequestTracked() {
        return true;
    }

    public PartialRow getRow() {
        return this.row;
    }

    public void setRow(PartialRow row) {
        Preconditions.checkArgument(row.getSchema() == this.table.getSchema(), "The row's schema must be equal by reference to the table schema");
        this.row = row;
    }

    @Override
    void updateStatistics(Statistics statistics, OperationResponse response) {
        String tabletId = this.getTablet().getTabletId();
        String tableName = this.getTable().getName();
        Statistics.TabletStatistics tabletStatistics = statistics.getTabletStatistics(tableName, tabletId);
        if (response == null) {
            tabletStatistics.incrementStatistic(Statistics.Statistic.OPS_ERRORS, 1L);
            tabletStatistics.incrementStatistic(Statistics.Statistic.RPC_ERRORS, 1L);
            return;
        }
        tabletStatistics.incrementStatistic(Statistics.Statistic.WRITE_RPCS, 1L);
        if (response.hasRowError()) {
            tabletStatistics.incrementStatistic(Statistics.Statistic.OPS_ERRORS, 1L);
        } else {
            tabletStatistics.incrementStatistic(Statistics.Statistic.WRITE_OPS, 1L);
        }
        tabletStatistics.incrementStatistic(Statistics.Statistic.BYTES_WRITTEN, this.getRowOperationSizeBytes());
    }

    static Tserver.WriteRequestPB.Builder createAndFillWriteRequestPB(List<Operation> operations) {
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        Schema schema = operations.get((int)0).table.getSchema();
        WireProtocol.RowOperationsPB rowOps = new OperationsEncoder().encodeOperations(operations);
        if (rowOps == null) {
            return null;
        }
        Tserver.WriteRequestPB.Builder requestBuilder = Tserver.WriteRequestPB.newBuilder();
        requestBuilder.setSchema(ProtobufHelper.schemaToPb(schema, EnumSet.of(ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_COMMENT, ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_ID)));
        requestBuilder.setRowOperations(rowOps);
        return requestBuilder;
    }

    static class OperationsEncoder {
        private Schema schema;
        private ByteBuffer rows;
        private List<ByteBuffer> indirect;
        private long indirectWrittenBytes;

        OperationsEncoder() {
        }

        private void init(Schema schema, int numOperations) {
            this.schema = schema;
            int columnBitSetSize = Bytes.getBitSetSize(schema.getColumnCount());
            int sizePerRow = 1 + schema.getRowSize() + columnBitSetSize;
            if (schema.hasNullableColumns()) {
                sizePerRow += columnBitSetSize;
            }
            this.rows = ByteBuffer.allocate(sizePerRow * numOperations).order(ByteOrder.LITTLE_ENDIAN);
            this.indirect = new ArrayList<ByteBuffer>(schema.getVarLengthColumnCount() * numOperations);
        }

        private WireProtocol.RowOperationsPB toPB() {
            WireProtocol.RowOperationsPB.Builder rowOpsBuilder = WireProtocol.RowOperationsPB.newBuilder();
            this.rows.limit(this.rows.position());
            this.rows.flip();
            rowOpsBuilder.setRows(ByteString.copyFrom(this.rows));
            if (this.indirect.size() > 0) {
                byte[] indirectData = new byte[(int)this.indirectWrittenBytes];
                int offset = 0;
                for (ByteBuffer bb : this.indirect) {
                    int bbSize = bb.remaining();
                    bb.get(indirectData, offset, bbSize);
                    offset += bbSize;
                }
                rowOpsBuilder.setIndirectData(UnsafeByteOperations.unsafeWrap(indirectData));
            }
            return rowOpsBuilder.build();
        }

        private void encodeRow(PartialRow row, ChangeType type) {
            int columnCount = row.getSchema().getColumnCount();
            BitSet columnsBitSet = row.getColumnsBitSet();
            BitSet nullsBitSet = row.getNullsBitSet();
            if (type == ChangeType.DELETE) {
                columnCount = row.getSchema().getPrimaryKeyColumnCount();
                columnsBitSet.clear(this.schema.getPrimaryKeyColumnCount(), columnsBitSet.size() - 1);
                if (this.schema.hasNullableColumns()) {
                    nullsBitSet.clear(this.schema.getPrimaryKeyColumnCount(), nullsBitSet.size() - 1);
                }
            }
            this.rows.put(type.toEncodedByte());
            this.rows.put(Bytes.fromBitSet(columnsBitSet, this.schema.getColumnCount()));
            if (this.schema.hasNullableColumns()) {
                this.rows.put(Bytes.fromBitSet(nullsBitSet, this.schema.getColumnCount()));
            }
            byte[] rowData = row.getRowAlloc();
            int currentRowOffset = 0;
            for (int colIdx = 0; colIdx < columnCount; ++colIdx) {
                ColumnSchema col = this.schema.getColumnByIndex(colIdx);
                if (row.isSet(colIdx) && !row.isSetToNull(colIdx)) {
                    if (col.getType() == Type.STRING || col.getType() == Type.BINARY) {
                        ByteBuffer varLengthData = row.getVarLengthData().get(colIdx);
                        varLengthData.reset();
                        this.rows.putLong(this.indirectWrittenBytes);
                        int bbSize = varLengthData.remaining();
                        this.rows.putLong(bbSize);
                        this.indirect.add(varLengthData);
                        this.indirectWrittenBytes += (long)bbSize;
                    } else {
                        this.rows.put(rowData, currentRowOffset, col.getTypeSize());
                    }
                }
                currentRowOffset += col.getTypeSize();
            }
        }

        public WireProtocol.RowOperationsPB encodeOperations(List<Operation> operations) {
            if (operations == null || operations.isEmpty()) {
                return null;
            }
            this.init(operations.get((int)0).table.getSchema(), operations.size());
            for (Operation operation : operations) {
                this.encodeRow(operation.row, operation.getChangeType());
            }
            return this.toPB();
        }

        public WireProtocol.RowOperationsPB encodeRangePartitions(List<CreateTableOptions.RangePartition> rangePartitions, List<PartialRow> splitRows) {
            if (splitRows.isEmpty() && rangePartitions.isEmpty()) {
                return null;
            }
            Schema schema = splitRows.isEmpty() ? rangePartitions.get(0).getLowerBound().getSchema() : splitRows.get(0).getSchema();
            this.init(schema, splitRows.size() + 2 * rangePartitions.size());
            for (PartialRow row : splitRows) {
                this.encodeRow(row, ChangeType.SPLIT_ROWS);
            }
            for (CreateTableOptions.RangePartition partition : rangePartitions) {
                this.encodeRow(partition.getLowerBound(), partition.getLowerBoundType() == RangePartitionBound.INCLUSIVE_BOUND ? ChangeType.RANGE_LOWER_BOUND : ChangeType.EXCLUSIVE_RANGE_LOWER_BOUND);
                this.encodeRow(partition.getUpperBound(), partition.getUpperBoundType() == RangePartitionBound.EXCLUSIVE_BOUND ? ChangeType.RANGE_UPPER_BOUND : ChangeType.INCLUSIVE_RANGE_UPPER_BOUND);
            }
            return this.toPB();
        }

        public WireProtocol.RowOperationsPB encodeLowerAndUpperBounds(PartialRow lowerBound, PartialRow upperBound, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
            this.init(lowerBound.getSchema(), 2);
            this.encodeRow(lowerBound, lowerBoundType == RangePartitionBound.INCLUSIVE_BOUND ? ChangeType.RANGE_LOWER_BOUND : ChangeType.EXCLUSIVE_RANGE_LOWER_BOUND);
            this.encodeRow(upperBound, upperBoundType == RangePartitionBound.EXCLUSIVE_BOUND ? ChangeType.RANGE_UPPER_BOUND : ChangeType.INCLUSIVE_RANGE_UPPER_BOUND);
            return this.toPB();
        }
    }

    static enum ChangeType {
        INSERT((byte)WireProtocol.RowOperationsPB.Type.INSERT.getNumber()),
        UPDATE((byte)WireProtocol.RowOperationsPB.Type.UPDATE.getNumber()),
        DELETE((byte)WireProtocol.RowOperationsPB.Type.DELETE.getNumber()),
        SPLIT_ROWS((byte)WireProtocol.RowOperationsPB.Type.SPLIT_ROW.getNumber()),
        UPSERT((byte)WireProtocol.RowOperationsPB.Type.UPSERT.getNumber()),
        RANGE_LOWER_BOUND((byte)WireProtocol.RowOperationsPB.Type.RANGE_LOWER_BOUND.getNumber()),
        RANGE_UPPER_BOUND((byte)WireProtocol.RowOperationsPB.Type.RANGE_UPPER_BOUND.getNumber()),
        EXCLUSIVE_RANGE_LOWER_BOUND((byte)WireProtocol.RowOperationsPB.Type.EXCLUSIVE_RANGE_LOWER_BOUND.getNumber()),
        INCLUSIVE_RANGE_UPPER_BOUND((byte)WireProtocol.RowOperationsPB.Type.INCLUSIVE_RANGE_UPPER_BOUND.getNumber());

        private final byte encodedByte;

        private ChangeType(byte encodedByte) {
            this.encodedByte = encodedByte;
        }

        byte toEncodedByte() {
            return this.encodedByte;
        }
    }
}

