/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.NonRecoverableException;
import org.apache.hive.kudu.org.apache.kudu.client.RecoverableException;
import org.apache.hive.kudu.org.apache.kudu.client.RpcOutboundMessage;
import org.apache.hive.kudu.org.apache.kudu.client.SecurityContext;
import org.apache.hive.kudu.org.apache.kudu.client.Status;
import org.apache.hive.kudu.org.apache.kudu.rpc.RpcHeader;
import org.apache.hive.kudu.org.apache.kudu.security.Token;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.Maps;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.Sets;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.Channel;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.Channels;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.MessageEvent;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.ssl.SslHandler;
import org.apache.hive.kudu.org.apache.kudu.util.SecurityUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Negotiator
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Negotiator.class);
    private final SaslClientCallbackHandler SASL_CALLBACK = new SaslClientCallbackHandler();
    private static final ImmutableSet<RpcHeader.RpcFeatureFlag> SUPPORTED_RPC_FEATURES = ImmutableSet.of(RpcHeader.RpcFeatureFlag.APPLICATION_FEATURE_FLAGS, RpcHeader.RpcFeatureFlag.TLS);
    static final int CONNECTION_CTX_CALL_ID = -3;
    static final int SASL_CALL_ID = -33;
    static final String[] PREFERRED_CIPHER_SUITES = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"};
    private final String remoteHostname;
    private final SecurityContext securityContext;
    private final Token.SignedTokenPB authnToken;
    private AuthnTokenNotUsedReason authnTokenNotUsedReason = null;
    private State state = State.INITIAL;
    private SaslClient saslClient;
    private SaslMechanism chosenMech;
    private RpcHeader.AuthenticationTypePB.TypeCase chosenAuthnType;
    private Set<RpcHeader.RpcFeatureFlag> serverFeatures;
    private DecoderEmbedder<ChannelBuffer> sslEmbedder;
    private byte[] nonce;
    private ChannelFuture sslHandshakeFuture;
    private Certificate peerCert;
    @InterfaceAudience.LimitedPrivate(value={"Test"})
    boolean overrideLoopbackForTests;

    public Negotiator(String remoteHostname, SecurityContext securityContext, boolean ignoreAuthnToken) {
        this.remoteHostname = remoteHostname;
        this.securityContext = securityContext;
        Token.SignedTokenPB token = securityContext.getAuthenticationToken();
        if (token != null) {
            if (ignoreAuthnToken) {
                this.authnToken = null;
                this.authnTokenNotUsedReason = AuthnTokenNotUsedReason.FORBIDDEN_BY_POLICY;
            } else if (!securityContext.hasTrustedCerts()) {
                this.authnToken = null;
                this.authnTokenNotUsedReason = AuthnTokenNotUsedReason.NO_TRUSTED_CERTS;
            } else {
                this.authnToken = token;
            }
        } else {
            this.authnToken = null;
            this.authnTokenNotUsedReason = AuthnTokenNotUsedReason.NONE_AVAILABLE;
        }
    }

    public void sendHello(Channel channel) {
        this.sendNegotiateMessage(channel);
    }

    private void sendNegotiateMessage(Channel channel) {
        RpcHeader.NegotiatePB.Builder builder = RpcHeader.NegotiatePB.newBuilder().setStep(RpcHeader.NegotiatePB.NegotiateStep.NEGOTIATE);
        for (RpcHeader.RpcFeatureFlag flag : SUPPORTED_RPC_FEATURES) {
            builder.addSupportedFeatures(flag);
        }
        if (this.isLoopbackConnection(channel)) {
            builder.addSupportedFeatures(RpcHeader.RpcFeatureFlag.TLS_AUTHENTICATION_ONLY);
        }
        builder.addAuthnTypesBuilder().setSasl(RpcHeader.AuthenticationTypePB.Sasl.getDefaultInstance());
        if (this.authnToken != null) {
            builder.addAuthnTypesBuilder().setToken(RpcHeader.AuthenticationTypePB.Token.getDefaultInstance());
        }
        this.state = State.AWAIT_NEGOTIATE;
        this.sendSaslMessage(channel, builder.build());
    }

    private void sendSaslMessage(Channel channel, RpcHeader.NegotiatePB msg) {
        Preconditions.checkNotNull(channel);
        RpcHeader.RequestHeader.Builder builder = RpcHeader.RequestHeader.newBuilder();
        builder.setCallId(-33);
        Channels.write(channel, new RpcOutboundMessage(builder, msg));
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws IOException {
        Object m3 = evt.getMessage();
        if (!(m3 instanceof CallResponse)) {
            ctx.sendUpstream(evt);
            return;
        }
        this.handleResponse(ctx.getChannel(), (CallResponse)m3);
    }

    private void handleResponse(Channel chan, CallResponse callResponse) throws IOException {
        RpcHeader.ResponseHeader header = callResponse.getHeader();
        if (header.getIsError()) {
            RpcHeader.ErrorStatusPB.Builder errBuilder = RpcHeader.ErrorStatusPB.newBuilder();
            KuduRpc.readProtobuf(callResponse.getPBMessage(), errBuilder);
            RpcHeader.ErrorStatusPB error = errBuilder.build();
            LOG.debug("peer {} sent connection negotiation error: {}", (Object)chan.getRemoteAddress(), (Object)error.getMessage());
            this.state = State.FINISHED;
            chan.getPipeline().remove(this);
            Channels.fireMessageReceived(chan, (Object)new Failure(error));
            return;
        }
        RpcHeader.NegotiatePB response = this.parseSaslMsgResponse(callResponse);
        switch (this.state) {
            case AWAIT_NEGOTIATE: {
                this.handleNegotiateResponse(chan, response);
                break;
            }
            case AWAIT_SASL: {
                this.handleSaslMessage(chan, response);
                break;
            }
            case AWAIT_TOKEN_EXCHANGE: {
                this.handleTokenExchangeResponse(chan, response);
                break;
            }
            case AWAIT_TLS_HANDSHAKE: {
                this.handleTlsMessage(chan, response);
                break;
            }
            default: {
                throw new IllegalStateException("received a message in unexpected state: " + this.state.toString());
            }
        }
    }

    private void handleSaslMessage(Channel chan, RpcHeader.NegotiatePB response) throws IOException {
        switch (response.getStep()) {
            case SASL_CHALLENGE: {
                this.handleChallengeResponse(chan, response);
                break;
            }
            case SASL_SUCCESS: {
                this.handleSuccessResponse(chan, response);
                break;
            }
            default: {
                throw new IllegalStateException("Wrong negotiation step: " + response.getStep());
            }
        }
    }

    private RpcHeader.NegotiatePB parseSaslMsgResponse(CallResponse response) {
        RpcHeader.ResponseHeader responseHeader = response.getHeader();
        int id = responseHeader.getCallId();
        if (id != -33) {
            throw new IllegalStateException("Received a call that wasn't for SASL");
        }
        RpcHeader.NegotiatePB.Builder saslBuilder = RpcHeader.NegotiatePB.newBuilder();
        KuduRpc.readProtobuf(response.getPBMessage(), saslBuilder);
        return saslBuilder.build();
    }

    private void handleNegotiateResponse(Channel chan, RpcHeader.NegotiatePB response) throws IOException {
        Preconditions.checkState(response.getStep() == RpcHeader.NegotiatePB.NegotiateStep.NEGOTIATE, "Expected NEGOTIATE message, got {}", (Object)response.getStep());
        this.serverFeatures = this.getFeatureFlags(response);
        boolean negotiatedTls = this.serverFeatures.contains(RpcHeader.RpcFeatureFlag.TLS);
        this.chosenAuthnType = this.chooseAuthenticationType(response);
        if (this.chosenAuthnType == RpcHeader.AuthenticationTypePB.TypeCase.SASL) {
            this.chooseAndInitializeSaslMech(response);
        }
        if (negotiatedTls) {
            this.startTlsHandshake(chan);
        } else {
            this.startAuthentication(chan);
        }
    }

    private boolean isLoopbackConnection(Channel channel) {
        if (this.overrideLoopbackForTests) {
            return true;
        }
        try {
            InetAddress local = ((InetSocketAddress)channel.getLocalAddress()).getAddress();
            InetAddress remote = ((InetSocketAddress)channel.getRemoteAddress()).getAddress();
            return local.equals(remote);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private void chooseAndInitializeSaslMech(RpcHeader.NegotiatePB response) throws KuduException {
        this.securityContext.refreshSubject();
        HashMap<String, String> errorsByMech = Maps.newHashMap();
        HashSet<SaslMechanism> serverMechs = Sets.newHashSet();
        block10: for (RpcHeader.NegotiatePB.SaslMechanism mech : response.getSaslMechanismsList()) {
            switch (mech.getMechanism().toUpperCase()) {
                case "GSSAPI": {
                    serverMechs.add(SaslMechanism.GSSAPI);
                    continue block10;
                }
                case "PLAIN": {
                    serverMechs.add(SaslMechanism.PLAIN);
                    continue block10;
                }
            }
            errorsByMech.put(mech.getMechanism(), "unrecognized mechanism");
        }
        for (SaslMechanism clientMech : SaslMechanism.values()) {
            if (clientMech.equals((Object)SaslMechanism.GSSAPI)) {
                Subject s2 = this.securityContext.getSubject();
                if (s2 == null || s2.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
                    errorsByMech.put(clientMech.name(), "client does not have Kerberos credentials (tgt)");
                    continue;
                }
                if (SecurityUtil.isTgtExpired(s2)) {
                    errorsByMech.put(clientMech.name(), "client Kerberos credentials (TGT) have expired");
                    continue;
                }
            }
            if (!serverMechs.contains((Object)clientMech)) {
                errorsByMech.put(clientMech.name(), "not advertised by server");
                continue;
            }
            HashMap<String, String> props = Maps.newHashMap();
            if (clientMech == SaslMechanism.GSSAPI) {
                props.put("javax.security.sasl.qop", "auth-int");
            }
            try {
                this.saslClient = Sasl.createSaslClient(new String[]{clientMech.name()}, null, "kudu", this.remoteHostname, props, this.SASL_CALLBACK);
                this.chosenMech = clientMech;
                break;
            }
            catch (SaslException e) {
                errorsByMech.put(clientMech.name(), e.getMessage());
            }
        }
        if (this.chosenMech != null) {
            LOG.debug("SASL mechanism {} chosen for peer {}", (Object)this.chosenMech.name(), (Object)this.remoteHostname);
            return;
        }
        String message = serverMechs.size() == 1 && serverMechs.contains((Object)SaslMechanism.GSSAPI) ? "server requires authentication, but " + (String)errorsByMech.get(SaslMechanism.GSSAPI.name()) : "client/server supported SASL mechanism mismatch: [" + Joiner.on(", ").withKeyValueSeparator(": ").join(errorsByMech) + "]";
        if (this.authnTokenNotUsedReason != null) {
            message = message + ". Authentication tokens were not used because " + this.authnTokenNotUsedReason.msg;
        }
        if (this.authnToken != null) {
            throw new RecoverableException(Status.NotAuthorized(message));
        }
        throw new NonRecoverableException(Status.NotAuthorized(message));
    }

    private RpcHeader.AuthenticationTypePB.TypeCase chooseAuthenticationType(RpcHeader.NegotiatePB response) {
        Preconditions.checkArgument(response.getAuthnTypesCount() <= 1, "Expected server to reply with at most one authn type");
        if (response.getAuthnTypesCount() == 0) {
            return RpcHeader.AuthenticationTypePB.TypeCase.SASL;
        }
        RpcHeader.AuthenticationTypePB.TypeCase type = response.getAuthnTypes(0).getTypeCase();
        switch (type) {
            case SASL: {
                if (this.authnToken == null) break;
                this.authnTokenNotUsedReason = AuthnTokenNotUsedReason.NOT_CHOSEN_BY_SERVER;
                break;
            }
            case TOKEN: {
                if (this.authnToken != null) break;
                throw new IllegalArgumentException("server chose token authentication but client had no valid token");
            }
            default: {
                throw new IllegalArgumentException("server chose bad authn type " + this.chosenAuthnType);
            }
        }
        return type;
    }

    private Set<RpcHeader.RpcFeatureFlag> getFeatureFlags(RpcHeader.NegotiatePB response) {
        ImmutableSet.Builder features = ImmutableSet.builder();
        for (RpcHeader.RpcFeatureFlag feature : response.getSupportedFeaturesList()) {
            if (feature == RpcHeader.RpcFeatureFlag.UNKNOWN) continue;
            features.add(feature);
        }
        return features.build();
    }

    private void startTlsHandshake(Channel chan) throws SSLException {
        SSLEngine engine;
        switch (this.chosenAuthnType) {
            case SASL: {
                engine = this.securityContext.createSSLEngineTrustAll();
                break;
            }
            case TOKEN: {
                engine = this.securityContext.createSSLEngine();
                break;
            }
            default: {
                throw new AssertionError((Object)"unreachable");
            }
        }
        engine.setUseClientMode(true);
        HashSet<String> supported = Sets.newHashSet(engine.getSupportedCipherSuites());
        ArrayList<String> toEnable = Lists.newArrayList();
        for (String cipher : PREFERRED_CIPHER_SUITES) {
            if (!supported.contains(cipher)) continue;
            toEnable.add(cipher);
        }
        if (toEnable.isEmpty()) {
            throw new RuntimeException("No preferred cipher suites were supported. Supported suites: " + Joiner.on(',').join(supported));
        }
        engine.setEnabledCipherSuites(toEnable.toArray(new String[0]));
        SslHandler handler = new SslHandler(engine);
        handler.setEnableRenegotiation(false);
        this.sslEmbedder = new DecoderEmbedder(handler);
        this.sslHandshakeFuture = handler.handshake();
        this.state = State.AWAIT_TLS_HANDSHAKE;
        boolean sent = this.sendPendingOutboundTls(chan);
        assert (sent);
    }

    private void handleTlsMessage(Channel chan, RpcHeader.NegotiatePB response) throws IOException {
        boolean isAuthOnly;
        Preconditions.checkState(response.getStep() == RpcHeader.NegotiatePB.NegotiateStep.TLS_HANDSHAKE);
        Preconditions.checkArgument(!response.getTlsHandshake().isEmpty(), "empty TLS message from server");
        this.sslEmbedder.offer(ChannelBuffers.copiedBuffer(response.getTlsHandshake().asReadOnlyByteBuffer()));
        if (this.sendPendingOutboundTls(chan)) {
            return;
        }
        SslHandler handler = (SslHandler)this.sslEmbedder.getPipeline().getFirst();
        Certificate[] certs = handler.getEngine().getSession().getPeerCertificates();
        if (certs.length == 0) {
            throw new SSLPeerUnverifiedException("no peer cert found");
        }
        boolean bl = isAuthOnly = this.serverFeatures.contains(RpcHeader.RpcFeatureFlag.TLS_AUTHENTICATION_ONLY) && this.isLoopbackConnection(chan);
        if (!isAuthOnly) {
            chan.getPipeline().addFirst("tls", handler);
        }
        this.startAuthentication(chan);
    }

    private boolean sendPendingOutboundTls(Channel chan) {
        ArrayList<ByteString> bufs = Lists.newArrayList();
        while (this.sslEmbedder.peek() != null) {
            bufs.add(ByteString.copyFrom(((ChannelBuffer)this.sslEmbedder.poll()).toByteBuffer()));
        }
        ByteString data = ByteString.copyFrom(bufs);
        if (this.sslHandshakeFuture.isDone()) {
            assert (data.isEmpty());
            return false;
        }
        assert (data.size() > 0);
        this.sendTunneledTls(chan, data);
        return true;
    }

    private void sendTunneledTls(Channel chan, ByteString buf) {
        this.sendSaslMessage(chan, RpcHeader.NegotiatePB.newBuilder().setStep(RpcHeader.NegotiatePB.NegotiateStep.TLS_HANDSHAKE).setTlsHandshake(buf).build());
    }

    private void startAuthentication(Channel chan) throws SaslException, NonRecoverableException {
        switch (this.chosenAuthnType) {
            case SASL: {
                this.sendSaslInitiate(chan);
                break;
            }
            case TOKEN: {
                this.sendTokenExchange(chan);
                break;
            }
            default: {
                throw new AssertionError((Object)"unreachable");
            }
        }
    }

    private void sendTokenExchange(Channel chan) {
        Preconditions.checkNotNull(this.authnToken);
        Preconditions.checkNotNull(this.sslHandshakeFuture);
        Preconditions.checkState(this.sslHandshakeFuture.isSuccess());
        RpcHeader.NegotiatePB.Builder builder = RpcHeader.NegotiatePB.newBuilder().setStep(RpcHeader.NegotiatePB.NegotiateStep.TOKEN_EXCHANGE).setAuthnToken(this.authnToken);
        this.state = State.AWAIT_TOKEN_EXCHANGE;
        this.sendSaslMessage(chan, builder.build());
    }

    private void handleTokenExchangeResponse(Channel chan, RpcHeader.NegotiatePB response) throws SaslException {
        Preconditions.checkArgument(response.getStep() == RpcHeader.NegotiatePB.NegotiateStep.TOKEN_EXCHANGE, "expected TOKEN_EXCHANGE, got step: {}", (Object)response.getStep());
        this.finish(chan);
    }

    private void sendSaslInitiate(Channel chan) throws SaslException, NonRecoverableException {
        RpcHeader.NegotiatePB.Builder builder = RpcHeader.NegotiatePB.newBuilder();
        if (this.saslClient.hasInitialResponse()) {
            byte[] initialResponse = this.evaluateChallenge(new byte[0]);
            builder.setToken(UnsafeByteOperations.unsafeWrap(initialResponse));
        }
        builder.setStep(RpcHeader.NegotiatePB.NegotiateStep.SASL_INITIATE);
        builder.addSaslMechanismsBuilder().setMechanism(this.chosenMech.name());
        this.state = State.AWAIT_SASL;
        this.sendSaslMessage(chan, builder.build());
    }

    private void handleChallengeResponse(Channel chan, RpcHeader.NegotiatePB response) throws SaslException, NonRecoverableException {
        byte[] saslToken = this.evaluateChallenge(response.getToken().toByteArray());
        if (saslToken == null) {
            throw new IllegalStateException("Not expecting an empty token");
        }
        RpcHeader.NegotiatePB.Builder builder = RpcHeader.NegotiatePB.newBuilder();
        builder.setToken(UnsafeByteOperations.unsafeWrap(saslToken));
        builder.setStep(RpcHeader.NegotiatePB.NegotiateStep.SASL_RESPONSE);
        this.sendSaslMessage(chan, builder.build());
    }

    private void verifyChannelBindings(RpcHeader.NegotiatePB response) throws IOException {
        byte[] expected = SecurityUtil.getEndpointChannelBindings(this.peerCert);
        if (!response.hasChannelBindings()) {
            throw new SSLPeerUnverifiedException("no channel bindings provided by remote peer");
        }
        byte[] provided = response.getChannelBindings().toByteArray();
        if (provided.length < 4) {
            throw new SSLPeerUnverifiedException("invalid too-short channel bindings");
        }
        byte[] unwrapped = this.saslClient.unwrap(provided, 4, provided.length - 4);
        if (!Bytes.equals(expected, unwrapped)) {
            throw new SSLPeerUnverifiedException("invalid channel bindings provided by remote peer");
        }
    }

    private void handleSuccessResponse(Channel chan, RpcHeader.NegotiatePB response) throws IOException {
        Preconditions.checkState(this.saslClient.isComplete(), "server sent SASL_SUCCESS step, but SASL negotiation is not complete");
        if (this.chosenMech == SaslMechanism.GSSAPI) {
            if (response.hasNonce()) {
                this.nonce = response.getNonce().toByteArray();
            }
            if (this.peerCert != null) {
                this.verifyChannelBindings(response);
            }
        }
        this.finish(chan);
    }

    private void finish(Channel chan) throws SaslException {
        this.state = State.FINISHED;
        chan.getPipeline().remove(this);
        Channels.write(chan, this.makeConnectionContext());
        LOG.debug("Authenticated connection {} using {}/{}", new Object[]{chan, this.chosenAuthnType, this.chosenMech});
        Channels.fireMessageReceived(chan, (Object)new Success(this.serverFeatures));
    }

    private RpcOutboundMessage makeConnectionContext() throws SaslException {
        RpcHeader.ConnectionContextPB.Builder builder = RpcHeader.ConnectionContextPB.newBuilder();
        RpcHeader.UserInformationPB.Builder userBuilder = RpcHeader.UserInformationPB.newBuilder();
        String user = this.securityContext.getRealUser();
        userBuilder.setEffectiveUser(user);
        userBuilder.setRealUser(user);
        builder.setDEPRECATEDUserInfo(userBuilder.build());
        if (this.nonce != null) {
            byte[] encodedNonce = this.saslClient.wrap(this.nonce, 0, this.nonce.length);
            ByteBuffer buf = ByteBuffer.allocate(encodedNonce.length + 4);
            buf.order(ByteOrder.BIG_ENDIAN);
            buf.putInt(encodedNonce.length);
            buf.put(encodedNonce);
            builder.setEncodedNonce(UnsafeByteOperations.unsafeWrap(buf.array()));
        }
        RpcHeader.ConnectionContextPB pb = builder.build();
        RpcHeader.RequestHeader.Builder header = RpcHeader.RequestHeader.newBuilder().setCallId(-3);
        return new RpcOutboundMessage(header, pb);
    }

    private byte[] evaluateChallenge(final byte[] challenge) throws SaslException, NonRecoverableException {
        try {
            return Subject.doAs(this.securityContext.getSubject(), new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws SaslException {
                    return Negotiator.this.saslClient.evaluateChallenge(challenge);
                }
            });
        }
        catch (PrivilegedActionException e) {
            SaslException saslException = (SaslException)e.getCause();
            Throwable cause = saslException.getCause();
            if (cause instanceof GSSException && ((GSSException)cause).getMajor() == 13) {
                throw new NonRecoverableException(Status.ConfigurationError("Server requires Kerberos, but this client is not authenticated (missing or expired TGT)"), (Throwable)saslException);
            }
            throw saslException;
        }
    }

    static class Failure {
        final RpcHeader.ErrorStatusPB status;

        public Failure(RpcHeader.ErrorStatusPB status) {
            this.status = status;
        }
    }

    static class Success {
        final Set<RpcHeader.RpcFeatureFlag> serverFeatures;

        public Success(Set<RpcHeader.RpcFeatureFlag> serverFeatures) {
            this.serverFeatures = serverFeatures;
        }
    }

    private class SaslClientCallbackHandler
    implements CallbackHandler {
        private SaslClientCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(Negotiator.this.securityContext.getRealUser());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(new char[0]);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
        }
    }

    private static enum AuthnTokenNotUsedReason {
        NONE_AVAILABLE("no token is available"),
        NO_TRUSTED_CERTS("no TLS certificates are trusted by the client"),
        FORBIDDEN_BY_POLICY("this connection will be used to acquire a new token and therefore requires primary credentials"),
        NOT_CHOSEN_BY_SERVER("the server chose not to accept token authentication");

        final String msg;

        private AuthnTokenNotUsedReason(String msg) {
            this.msg = msg;
        }
    }

    private static enum State {
        INITIAL,
        AWAIT_NEGOTIATE,
        AWAIT_TLS_HANDSHAKE,
        AWAIT_TOKEN_EXCHANGE,
        AWAIT_SASL,
        FINISHED;

    }

    private static enum SaslMechanism {
        GSSAPI,
        PLAIN;

    }
}

