/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.client.Partition;
import org.apache.hive.kudu.org.apache.kudu.client.RemoteTablet;
import org.apache.hive.kudu.org.apache.kudu.consensus.Metadata;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LocatedTablet {
    private final Partition partition;
    private final byte[] tabletId;
    private final List<Replica> replicas;

    @InterfaceAudience.LimitedPrivate(value={"Tests"})
    public LocatedTablet(RemoteTablet tablet) {
        this.partition = tablet.getPartition();
        this.tabletId = tablet.getTabletIdAsBytes();
        this.replicas = tablet.getReplicas();
    }

    public List<Replica> getReplicas() {
        return this.replicas;
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    public Partition getPartition() {
        return this.partition;
    }

    @Deprecated
    public byte[] getStartKey() {
        return this.getPartition().getPartitionKeyStart();
    }

    @Deprecated
    public byte[] getEndKey() {
        return this.getPartition().getPartitionKeyEnd();
    }

    public byte[] getTabletId() {
        return this.tabletId;
    }

    public Replica getLeaderReplica() {
        return this.getOneOfRoleOrNull(Metadata.RaftPeerPB.Role.LEADER);
    }

    private Replica getOneOfRoleOrNull(Metadata.RaftPeerPB.Role role) {
        for (Replica r : this.replicas) {
            if (!r.getRoleAsEnum().equals(role)) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        return Bytes.pretty(this.tabletId) + " " + this.partition.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Replica {
        private final Master.TabletLocationsPB.ReplicaPB pb;

        Replica(Master.TabletLocationsPB.ReplicaPB pb) {
            this.pb = pb;
        }

        public String getRpcHost() {
            if (this.pb.getTsInfo().getRpcAddressesList().isEmpty()) {
                return null;
            }
            return this.pb.getTsInfo().getRpcAddressesList().get(0).getHost();
        }

        public Integer getRpcPort() {
            if (this.pb.getTsInfo().getRpcAddressesList().isEmpty()) {
                return null;
            }
            return this.pb.getTsInfo().getRpcAddressesList().get(0).getPort();
        }

        private Metadata.RaftPeerPB.Role getRoleAsEnum() {
            return this.pb.getRole();
        }

        public String getRole() {
            return this.pb.getRole().toString();
        }

        public String toString() {
            return this.pb.toString();
        }
    }
}

