/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.ArrayList;
import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.client.ListTablesResponse;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ListTablesRequest
extends KuduRpc<ListTablesResponse> {
    private final String nameFilter;

    ListTablesRequest(KuduTable masterTable, String nameFilter, Timer timer, long timeoutMillis) {
        super(masterTable, timer, timeoutMillis);
        this.nameFilter = nameFilter;
    }

    @Override
    Message createRequestPB() {
        Master.ListTablesRequestPB.Builder builder = Master.ListTablesRequestPB.newBuilder();
        if (this.nameFilter != null) {
            builder.setNameFilter(this.nameFilter);
        }
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "ListTables";
    }

    @Override
    Pair<ListTablesResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.ListTablesResponsePB.Builder respBuilder = Master.ListTablesResponsePB.newBuilder();
        ListTablesRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        int tablesCount = respBuilder.getTablesCount();
        ArrayList<ListTablesResponse.TableInfo> tableInfos = new ArrayList<ListTablesResponse.TableInfo>(tablesCount);
        for (Master.ListTablesResponsePB.TableInfo infoPb : respBuilder.getTablesList()) {
            tableInfos.add(new ListTablesResponse.TableInfo(infoPb.getId().toStringUtf8(), infoPb.getName()));
        }
        ListTablesResponse response = new ListTablesResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, tableInfos);
        return new Pair<ListTablesResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

