/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.hive.kudu.com.stumbleupon.async.Deferred;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.client.AlterTableOptions;
import org.apache.hive.kudu.org.apache.kudu.client.AlterTableResponse;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduSession;
import org.apache.hive.kudu.org.apache.kudu.client.CreateTableOptions;
import org.apache.hive.kudu.org.apache.kudu.client.DeleteTableResponse;
import org.apache.hive.kudu.org.apache.kudu.client.HiveMetastoreConfig;
import org.apache.hive.kudu.org.apache.kudu.client.HostAndPort;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduScanToken;
import org.apache.hive.kudu.org.apache.kudu.client.KuduScanner;
import org.apache.hive.kudu.org.apache.kudu.client.KuduSession;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.client.ListTablesResponse;
import org.apache.hive.kudu.org.apache.kudu.client.ListTabletServersResponse;
import org.apache.hive.kudu.org.apache.kudu.client.ServerInfo;
import org.apache.hive.kudu.org.apache.kudu.client.Statistics;
import org.apache.hive.kudu.org.apache.kudu.client.TableLocationsCache;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncKuduClient.class);
    public static final long NO_TIMESTAMP = -1L;
    @InterfaceAudience.LimitedPrivate(value={"Test"})
    final AsyncKuduClient asyncClient;

    KuduClient(AsyncKuduClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public void updateLastPropagatedTimestamp(long lastPropagatedTimestamp) {
        this.asyncClient.updateLastPropagatedTimestamp(lastPropagatedTimestamp);
    }

    public long getLastPropagatedTimestamp() {
        return this.asyncClient.getLastPropagatedTimestamp();
    }

    public boolean hasLastPropagatedTimestamp() {
        return this.asyncClient.hasLastPropagatedTimestamp();
    }

    public String getLocationString() {
        return this.asyncClient.getLocationString();
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    @InterfaceStability.Unstable
    public HiveMetastoreConfig getHiveMetastoreConfig() throws KuduException {
        return KuduClient.joinAndHandleException(this.asyncClient.getHiveMetastoreConfig());
    }

    public KuduTable createTable(String name, Schema schema, CreateTableOptions builder) throws KuduException {
        Deferred<KuduTable> d = this.asyncClient.createTable(name, schema, builder);
        return KuduClient.joinAndHandleException(d);
    }

    public boolean isCreateTableDone(String name) throws KuduException {
        Master.TableIdentifierPB.Builder table = Master.TableIdentifierPB.newBuilder().setTableName(name);
        Deferred<KuduTable> d = this.asyncClient.getDelayedIsCreateTableDoneDeferred(table, null, null);
        try {
            KuduClient.joinAndHandleException(d);
        }
        catch (KuduException e) {
            if (e.getStatus().isTimedOut()) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public DeleteTableResponse deleteTable(String name) throws KuduException {
        Deferred<DeleteTableResponse> d = this.asyncClient.deleteTable(name);
        return KuduClient.joinAndHandleException(d);
    }

    public AlterTableResponse alterTable(String name, AlterTableOptions ato) throws KuduException {
        Deferred<AlterTableResponse> d = this.asyncClient.alterTable(name, ato);
        return KuduClient.joinAndHandleException(d);
    }

    public boolean isAlterTableDone(String name) throws KuduException {
        Master.TableIdentifierPB.Builder table = Master.TableIdentifierPB.newBuilder().setTableName(name);
        Deferred<AlterTableResponse> d = this.asyncClient.getDelayedIsAlterTableDoneDeferred(table, null, null);
        try {
            KuduClient.joinAndHandleException(d);
        }
        catch (KuduException e) {
            if (e.getStatus().isTimedOut()) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public ListTabletServersResponse listTabletServers() throws KuduException {
        Deferred<ListTabletServersResponse> d = this.asyncClient.listTabletServers();
        return KuduClient.joinAndHandleException(d);
    }

    public ListTablesResponse getTablesList() throws KuduException {
        return this.getTablesList(null);
    }

    public ListTablesResponse getTablesList(String nameFilter) throws KuduException {
        Deferred<ListTablesResponse> d = this.asyncClient.getTablesList(nameFilter);
        return KuduClient.joinAndHandleException(d);
    }

    public boolean tableExists(String name) throws KuduException {
        Deferred<Boolean> d = this.asyncClient.tableExists(name);
        return KuduClient.joinAndHandleException(d);
    }

    KuduTable openTableById(String id) throws KuduException {
        Deferred<KuduTable> d = this.asyncClient.openTableById(id);
        return KuduClient.joinAndHandleException(d);
    }

    public KuduTable openTable(String name) throws KuduException {
        Deferred<KuduTable> d = this.asyncClient.openTable(name);
        return KuduClient.joinAndHandleException(d);
    }

    public KuduSession newSession() {
        AsyncKuduSession session = this.asyncClient.newSession();
        return new KuduSession(session);
    }

    public boolean isStatisticsEnabled() {
        return this.asyncClient.isStatisticsEnabled();
    }

    public Statistics getStatistics() {
        return this.asyncClient.getStatistics();
    }

    public KuduScanner.KuduScannerBuilder newScannerBuilder(KuduTable table) {
        return new KuduScanner.KuduScannerBuilder(this.asyncClient, table);
    }

    public KuduScanToken.KuduScanTokenBuilder newScanTokenBuilder(KuduTable table) {
        return new KuduScanToken.KuduScanTokenBuilder(this.asyncClient, table);
    }

    @Override
    public void close() throws KuduException {
        try {
            this.asyncClient.close();
        }
        catch (Exception e) {
            throw KuduException.transformException(e);
        }
    }

    public void shutdown() throws KuduException {
        Deferred<ArrayList<Void>> d = this.asyncClient.shutdown();
        KuduClient.joinAndHandleException(d);
    }

    @InterfaceStability.Unstable
    public byte[] exportAuthenticationCredentials() throws KuduException {
        return KuduClient.joinAndHandleException(this.asyncClient.exportAuthenticationCredentials());
    }

    @InterfaceStability.Unstable
    public void importAuthenticationCredentials(byte[] authnData) {
        this.asyncClient.importAuthenticationCredentials(authnData);
    }

    public long getDefaultOperationTimeoutMs() {
        return this.asyncClient.getDefaultOperationTimeoutMs();
    }

    public long getDefaultAdminOperationTimeoutMs() {
        return this.asyncClient.getDefaultAdminOperationTimeoutMs();
    }

    public String getMasterAddressesAsString() {
        return this.asyncClient.getMasterAddressesAsString();
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    public HostAndPort findLeaderMasterServer() throws KuduException {
        TableLocationsCache.Entry entry = this.asyncClient.getTableLocationEntry("Kudu Master", null);
        if (entry == null) {
            this.listTabletServers();
            entry = this.asyncClient.getTableLocationEntry("Kudu Master", null);
        }
        Preconditions.checkNotNull(entry);
        Preconditions.checkState(!entry.isNonCoveredRange());
        ServerInfo info = entry.getTablet().getLeaderServerInfo();
        Preconditions.checkNotNull(info);
        return info.getHostAndPort();
    }

    static <R> R joinAndHandleException(Deferred<R> deferred) throws KuduException {
        try {
            return deferred.join();
        }
        catch (Exception e) {
            throw KuduException.transformException(e);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static final class KuduClientBuilder {
        private AsyncKuduClient.AsyncKuduClientBuilder clientBuilder;

        public KuduClientBuilder(String masterAddresses) {
            this.clientBuilder = new AsyncKuduClient.AsyncKuduClientBuilder(masterAddresses);
        }

        public KuduClientBuilder(List<String> masterAddresses) {
            this.clientBuilder = new AsyncKuduClient.AsyncKuduClientBuilder(masterAddresses);
        }

        public KuduClientBuilder defaultAdminOperationTimeoutMs(long timeoutMs) {
            this.clientBuilder.defaultAdminOperationTimeoutMs(timeoutMs);
            return this;
        }

        public KuduClientBuilder defaultOperationTimeoutMs(long timeoutMs) {
            this.clientBuilder.defaultOperationTimeoutMs(timeoutMs);
            return this;
        }

        @Deprecated
        public KuduClientBuilder defaultSocketReadTimeoutMs(long timeoutMs) {
            LOG.info("defaultSocketReadTimeoutMs is deprecated");
            return this;
        }

        public KuduClientBuilder disableStatistics() {
            this.clientBuilder.disableStatistics();
            return this;
        }

        public KuduClientBuilder nioExecutors(Executor bossExecutor, Executor workerExecutor) {
            this.clientBuilder.nioExecutors(bossExecutor, workerExecutor);
            return this;
        }

        public KuduClientBuilder bossCount(int bossCount) {
            this.clientBuilder.bossCount(bossCount);
            return this;
        }

        public KuduClientBuilder workerCount(int workerCount) {
            this.clientBuilder.workerCount(workerCount);
            return this;
        }

        public KuduClient build() {
            AsyncKuduClient client = this.clientBuilder.build();
            return new KuduClient(client);
        }
    }
}

