/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.rpc.RpcHeader;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.Channel;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.hive.kudu.org.apache.kudu.shaded.org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.apache.hive.kudu.org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class CallResponse {
    private final ChannelBuffer buf;
    private final RpcHeader.ResponseHeader header;
    private final int totalResponseSize;
    private Slice message = null;

    CallResponse(ChannelBuffer buf) {
        this.buf = buf;
        this.totalResponseSize = buf.readableBytes();
        int headerSize = Bytes.readVarInt32(buf);
        Slice headerSlice = CallResponse.nextBytes(buf, headerSize);
        RpcHeader.ResponseHeader.Builder builder = RpcHeader.ResponseHeader.newBuilder();
        KuduRpc.readProtobuf(headerSlice, builder);
        this.header = builder.build();
    }

    public RpcHeader.ResponseHeader getHeader() {
        return this.header;
    }

    public int getTotalResponseSize() {
        return this.totalResponseSize;
    }

    public Slice getPBMessage() {
        int mainLength;
        this.cacheMessage();
        int n = mainLength = this.header.getSidecarOffsetsCount() == 0 ? this.message.length() : this.header.getSidecarOffsets(0);
        if (mainLength < 0 || mainLength > this.message.length()) {
            throw new IllegalStateException("Main protobuf message invalid. Length is " + mainLength + " while the size of the message excluding the header is " + this.message.length());
        }
        return CallResponse.subslice(this.message, 0, mainLength);
    }

    public Slice getSidecar(int sidecar) {
        this.cacheMessage();
        List<Integer> sidecarList = this.header.getSidecarOffsetsList();
        if (sidecar < 0 || sidecar > sidecarList.size()) {
            throw new IllegalArgumentException("Sidecar " + sidecar + " not valid, response has " + sidecarList.size() + " sidecars");
        }
        int prevOffset = sidecarList.get(sidecar);
        int nextOffset = sidecar + 1 == sidecarList.size() ? this.message.length() : sidecarList.get(sidecar + 1).intValue();
        int length = nextOffset - prevOffset;
        if (prevOffset < 0 || length < 0 || prevOffset + length > this.message.length()) {
            throw new IllegalStateException("Sidecar " + sidecar + " invalid (offset = " + prevOffset + ", length = " + length + "). The size of the message excluding the header is " + this.message.length());
        }
        return CallResponse.subslice(this.message, prevOffset, length);
    }

    private void cacheMessage() {
        if (this.message != null) {
            return;
        }
        int length = Bytes.readVarInt32(this.buf);
        this.message = CallResponse.nextBytes(this.buf, length);
    }

    private static Slice subslice(Slice parent, int offset, int length) {
        return new Slice(parent.getRawArray(), parent.getRawOffset() + offset, length);
    }

    private static Slice nextBytes(ChannelBuffer buf, int length) {
        int offset;
        byte[] payload;
        if (buf.hasArray()) {
            payload = buf.array();
            offset = buf.arrayOffset() + buf.readerIndex();
            buf.skipBytes(length);
        } else {
            payload = new byte[length];
            buf.readBytes(payload);
            offset = 0;
        }
        return new Slice(payload, offset, length);
    }

    static class Decoder
    extends OneToOneDecoder {
        Decoder() {
        }

        @Override
        protected Object decode(ChannelHandlerContext ctx, Channel channel, Object message) throws Exception {
            if (!(message instanceof ChannelBuffer)) {
                return message;
            }
            return new CallResponse((ChannelBuffer)message);
        }
    }
}

