/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kudu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.kudu.KuduHiveUtils;
import org.apache.hadoop.hive.kudu.KuduWritable;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.client.KuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.PartialRow;

@SerDeSpec(schemaProps={"kudu.table_name"})
public class KuduSerDe
extends AbstractSerDe {
    private ObjectInspector objectInspector;
    private Schema schema;

    public void initialize(Configuration sysConf, Properties tblProps) throws SerDeException {
        Configuration conf = KuduHiveUtils.createOverlayedConf(sysConf, tblProps);
        String tableName = conf.get("kudu.table_name");
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new SerDeException("kudu.table_name is not set.");
        }
        try (KuduClient client = KuduHiveUtils.getKuduClient(conf);){
            if (!client.tableExists(tableName)) {
                throw new SerDeException("Kudu table does not exist: " + tableName);
            }
            this.schema = client.openTable(tableName).getSchema();
        }
        catch (IOException ex) {
            throw new SerDeException((Throwable)ex);
        }
        this.objectInspector = KuduSerDe.createObjectInspector(this.schema);
    }

    private static ObjectInspector createObjectInspector(Schema schema) throws SerDeException {
        Preconditions.checkNotNull((Object)schema);
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<AbstractPrimitiveWritableObjectInspector> fieldInspectors = new ArrayList<AbstractPrimitiveWritableObjectInspector>();
        ArrayList<String> fieldComments = new ArrayList<String>();
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            ColumnSchema col = schema.getColumnByIndex(i);
            PrimitiveTypeInfo typeInfo = KuduHiveUtils.toHiveType(col.getType(), col.getTypeAttributes());
            fieldNames.add(col.getName());
            fieldInspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo));
            fieldComments.add(col.getComment());
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldInspectors, fieldComments);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ObjectInspector getObjectInspector() {
        return this.objectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return KuduWritable.class;
    }

    public KuduWritable serialize(Object obj, ObjectInspector objectInspector) throws SerDeException {
        Preconditions.checkArgument((objectInspector.getCategory() == ObjectInspector.Category.STRUCT ? 1 : 0) != 0);
        StructObjectInspector soi = (StructObjectInspector)objectInspector;
        List writableObj = soi.getStructFieldsDataAsList(obj);
        List fields = soi.getAllStructFieldRefs();
        PartialRow row = this.schema.newPartialRow();
        block13: for (int i = 0; i < this.schema.getColumnCount(); ++i) {
            StructField field = (StructField)fields.get(i);
            Object value = writableObj.get(i);
            if (value == null) {
                row.setNull(i);
                continue;
            }
            Type type = this.schema.getColumnByIndex(i).getType();
            ObjectInspector inspector = field.getFieldObjectInspector();
            switch (type) {
                case BOOL: {
                    boolean boolVal = ((BooleanObjectInspector)inspector).get(value);
                    row.addBoolean(i, boolVal);
                    continue block13;
                }
                case INT8: {
                    byte byteVal = ((ByteObjectInspector)inspector).get(value);
                    row.addByte(i, byteVal);
                    continue block13;
                }
                case INT16: {
                    short shortVal = ((ShortObjectInspector)inspector).get(value);
                    row.addShort(i, shortVal);
                    continue block13;
                }
                case INT32: {
                    int intVal = ((IntObjectInspector)inspector).get(value);
                    row.addInt(i, intVal);
                    continue block13;
                }
                case INT64: {
                    long longVal = ((LongObjectInspector)inspector).get(value);
                    row.addLong(i, longVal);
                    continue block13;
                }
                case UNIXTIME_MICROS: {
                    Timestamp timestampVal = ((TimestampObjectInspector)inspector).getPrimitiveJavaObject(value).toSqlTimestamp();
                    row.addTimestamp(i, timestampVal);
                    continue block13;
                }
                case DECIMAL: {
                    HiveDecimal decimalVal = ((HiveDecimalObjectInspector)inspector).getPrimitiveJavaObject(value);
                    row.addDecimal(i, decimalVal.bigDecimalValue());
                    continue block13;
                }
                case FLOAT: {
                    float floatVal = ((FloatObjectInspector)inspector).get(value);
                    row.addFloat(i, floatVal);
                    continue block13;
                }
                case DOUBLE: {
                    double doubleVal = ((DoubleObjectInspector)inspector).get(value);
                    row.addDouble(i, doubleVal);
                    continue block13;
                }
                case STRING: {
                    String stringVal = ((StringObjectInspector)inspector).getPrimitiveJavaObject(value);
                    row.addString(i, stringVal);
                    continue block13;
                }
                case BINARY: {
                    byte[] bytesVal = ((BinaryObjectInspector)inspector).getPrimitiveJavaObject(value);
                    row.addBinary(i, bytesVal);
                    continue block13;
                }
                default: {
                    throw new SerDeException("Unsupported column type: " + type.name());
                }
            }
        }
        return new KuduWritable(row);
    }

    public Object deserialize(Writable writable) throws SerDeException {
        KuduWritable input = (KuduWritable)writable;
        ArrayList<Object> output = new ArrayList<Object>();
        block13: for (int i = 0; i < this.schema.getColumnCount(); ++i) {
            if (!input.isSet(i)) continue;
            Object javaObj = input.getValueObject(i);
            ColumnSchema col = this.schema.getColumnByIndex(i);
            PrimitiveTypeInfo typeInfo = KuduHiveUtils.toHiveType(col.getType(), col.getTypeAttributes());
            if (javaObj == null) {
                output.add(null);
                continue;
            }
            switch (typeInfo.getPrimitiveCategory()) {
                case BOOLEAN: {
                    output.add(new BooleanWritable(((Boolean)javaObj).booleanValue()));
                    continue block13;
                }
                case BYTE: {
                    output.add(new ByteWritable(((Byte)javaObj).byteValue()));
                    continue block13;
                }
                case SHORT: {
                    output.add(new ShortWritable(((Short)javaObj).shortValue()));
                    continue block13;
                }
                case INT: {
                    output.add(new IntWritable(((Integer)javaObj).intValue()));
                    continue block13;
                }
                case LONG: {
                    output.add(new LongWritable(((Long)javaObj).longValue()));
                    continue block13;
                }
                case TIMESTAMP: {
                    Timestamp sqlTs = (Timestamp)javaObj;
                    org.apache.hadoop.hive.common.type.Timestamp hiveTs = org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)sqlTs.getTime(), (int)sqlTs.getNanos());
                    output.add(new TimestampWritableV2(hiveTs));
                    continue block13;
                }
                case DECIMAL: {
                    HiveDecimal hiveDecimal = HiveDecimal.create((BigDecimal)((BigDecimal)javaObj));
                    output.add(new HiveDecimalWritable(hiveDecimal));
                    continue block13;
                }
                case FLOAT: {
                    output.add(new FloatWritable(((Float)javaObj).floatValue()));
                    continue block13;
                }
                case DOUBLE: {
                    output.add(new DoubleWritable(((Double)javaObj).doubleValue()));
                    continue block13;
                }
                case STRING: {
                    output.add(new Text((String)javaObj));
                    continue block13;
                }
                case BINARY: {
                    output.add(new BytesWritable((byte[])javaObj));
                    continue block13;
                }
                default: {
                    throw new SerDeException("Unsupported type: " + typeInfo.getPrimitiveCategory());
                }
            }
        }
        return output;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

