/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kudu;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.kudu.KuduHiveUtils;
import org.apache.hadoop.hive.kudu.KuduPredicateHandler;
import org.apache.hadoop.hive.kudu.KuduWritable;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.client.KuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduPredicate;
import org.apache.hive.kudu.org.apache.kudu.client.KuduScanToken;
import org.apache.hive.kudu.org.apache.kudu.client.KuduScanner;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.client.LocatedTablet;
import org.apache.hive.kudu.org.apache.kudu.client.RowResult;

public class KuduInputFormat
extends InputFormat<NullWritable, KuduWritable>
implements org.apache.hadoop.mapred.InputFormat<NullWritable, KuduWritable> {
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        return this.computeSplits(context.getConfiguration()).stream().map(is -> is).collect(Collectors.toList());
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        List<KuduInputSplit> splits = this.computeSplits((Configuration)conf);
        return splits.toArray(new org.apache.hadoop.mapred.InputSplit[0]);
    }

    private List<KuduInputSplit> computeSplits(Configuration conf) throws IOException {
        try (KuduClient client = KuduHiveUtils.getKuduClient(conf);){
            Job job = Job.getInstance((Configuration)conf);
            JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
            Path[] paths = FileInputFormat.getInputPaths((JobContext)jobContext);
            Path dummyPath = paths[0];
            String tableName = conf.get("kudu.table_name");
            if (StringUtils.isEmpty((CharSequence)tableName)) {
                throw new IllegalArgumentException("kudu.table_name is not set.");
            }
            if (!client.tableExists(tableName)) {
                throw new IllegalArgumentException("Kudu table does not exist: " + tableName);
            }
            KuduTable table = client.openTable(tableName);
            List<KuduPredicate> predicates = KuduPredicateHandler.getPredicates(conf, table.getSchema());
            KuduScanToken.KuduScanTokenBuilder tokenBuilder = (KuduScanToken.KuduScanTokenBuilder)client.newScanTokenBuilder(table).setProjectedColumnNames(this.getProjectedColumns(conf));
            for (KuduPredicate predicate : predicates) {
                tokenBuilder.addPredicate(predicate);
            }
            Object tokens = tokenBuilder.build();
            ArrayList<KuduInputSplit> splits = new ArrayList<KuduInputSplit>(tokens.size());
            Object object = tokens.iterator();
            while (object.hasNext()) {
                KuduScanToken token = (KuduScanToken)object.next();
                ArrayList<String> locations = new ArrayList<String>(token.getTablet().getReplicas().size());
                for (LocatedTablet.Replica replica : token.getTablet().getReplicas()) {
                    locations.add(replica.getRpcHost());
                }
                splits.add(new KuduInputSplit(token, dummyPath, locations.toArray(new String[0])));
            }
            object = splits;
            return object;
        }
    }

    private List<String> getProjectedColumns(Configuration conf) throws IOException {
        String[] columnNamesArr = conf.getStrings("columns");
        if (null == columnNamesArr) {
            throw new IOException("Hive column names must be provided to InputFormat in the Configuration");
        }
        ArrayList<String> columns = new ArrayList<String>(Arrays.asList(columnNamesArr));
        VirtualColumn.removeVirtualColumns(columns);
        return columns;
    }

    public RecordReader<NullWritable, KuduWritable> createRecordReader(InputSplit split, TaskAttemptContext context) {
        Preconditions.checkArgument((boolean)(split instanceof KuduInputSplit));
        return new KuduRecordReader();
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, KuduWritable> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        Preconditions.checkArgument((boolean)(split instanceof KuduInputSplit));
        KuduRecordReader recordReader = new KuduRecordReader();
        recordReader.initialize((KuduInputSplit)split, (Configuration)conf);
        return recordReader;
    }

    static class KuduRecordReader
    extends RecordReader<NullWritable, KuduWritable>
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, KuduWritable> {
        private volatile boolean initialized = false;
        private KuduClient client;
        private KuduScanner scanner;
        private Iterator<RowResult> iterator;
        private RowResult currentValue;
        private KuduWritable currentWritable;
        private long pos;

        KuduRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
            Preconditions.checkArgument((boolean)(split instanceof KuduInputSplit));
            this.initialize((KuduInputSplit)split, context.getConfiguration());
        }

        private synchronized void initialize(KuduInputSplit split, Configuration conf) throws IOException {
            if (!this.initialized) {
                byte[] serializedScanToken = split.getSerializedScanToken();
                this.client = KuduHiveUtils.getKuduClient(conf);
                this.scanner = KuduScanToken.deserializeIntoScanner(serializedScanToken, this.client);
                this.iterator = this.scanner.iterator();
                this.currentValue = null;
                this.currentWritable = new KuduWritable(this.scanner.getProjectionSchema().newPartialRow());
                this.pos = 0L;
                this.initialized = true;
            }
        }

        public boolean nextKeyValue() {
            if (this.iterator.hasNext()) {
                this.currentValue = this.iterator.next();
                this.currentWritable.setRow(this.currentValue);
                ++this.pos;
                return true;
            }
            this.currentValue = null;
            return false;
        }

        public NullWritable getCurrentKey() {
            return NullWritable.get();
        }

        public KuduWritable getCurrentValue() {
            Preconditions.checkNotNull((Object)this.currentValue);
            return this.currentWritable;
        }

        public boolean next(NullWritable nullWritable, KuduWritable kuduWritable) {
            if (this.nextKeyValue()) {
                kuduWritable.setRow(this.currentValue);
                return true;
            }
            return false;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public KuduWritable createValue() {
            return new KuduWritable(this.scanner.getProjectionSchema().newPartialRow());
        }

        public void close() throws IOException {
            try {
                this.scanner.close();
            }
            catch (KuduException e) {
                throw new IOException(e);
            }
            this.client.shutdown();
        }

        public long getPos() {
            return this.pos;
        }

        public float getProgress() {
            return 0.0f;
        }
    }

    static class KuduInputSplit
    extends FileSplit
    implements org.apache.hadoop.mapred.InputSplit {
        private byte[] serializedScanToken;
        private String[] locations;

        KuduInputSplit() {
            super(null, 0L, 0L, (String[])null);
        }

        KuduInputSplit(KuduScanToken token, Path dummyPath, String[] locations) throws IOException {
            super(dummyPath, 0L, 0L, locations);
            this.serializedScanToken = token.serialize();
            this.locations = locations;
        }

        byte[] getSerializedScanToken() {
            return this.serializedScanToken;
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return this.locations;
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.serializedScanToken = Bytes.readByteArray(in);
            this.locations = new String[in.readInt()];
            for (int i = 0; i < this.locations.length; ++i) {
                byte[] str = Bytes.readByteArray(in);
                this.locations[i] = Bytes.getString(str);
            }
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            Bytes.writeByteArray(out, this.serializedScanToken);
            out.writeInt(this.locations.length);
            for (String location : this.locations) {
                byte[] str = Bytes.fromString(location);
                Bytes.writeByteArray(out, str);
            }
        }
    }
}

