/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.listener;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AcidWriteEvent;
import org.apache.hadoop.hive.metastore.events.AddForeignKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddNotNullConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AddPrimaryKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddUniqueConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DeletePartitionColumnStatEvent;
import org.apache.hadoop.hive.metastore.events.DeleteTableColumnStatEvent;
import org.apache.hadoop.hive.metastore.events.DropConstraintEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.events.UpdatePartitionColumnStatEvent;
import org.apache.hadoop.hive.metastore.events.UpdateTableColumnStatEvent;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.AcidWriteMessage;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DropConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.MessageSerializer;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDeletePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDeleteTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONUpdatePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONUpdateTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbNotificationListener
extends TransactionalMetaStoreEventListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)DbNotificationListener.class.getName());
    private static CleanerThread cleaner = null;
    private Configuration conf;
    private MessageEncoder msgEncoder;

    private static synchronized void init(Configuration conf) throws MetaException {
        if (cleaner == null) {
            cleaner = new CleanerThread(conf, RawStoreProxy.getProxy((Configuration)conf, (Configuration)conf, (String)MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.RAW_STORE_IMPL), (int)999999));
            cleaner.start();
        }
    }

    public DbNotificationListener(Configuration config) throws MetaException {
        super(config);
        this.conf = config;
        DbNotificationListener.init(this.conf);
        this.msgEncoder = MessageFactory.getDefaultInstance((Configuration)this.conf);
    }

    public void onConfigChange(ConfigChangeEvent tableEvent) throws MetaException {
        long time;
        String key = tableEvent.getKey();
        if (key.equals(MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL.toString()) || key.equals(MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL.getHiveName())) {
            time = MetastoreConf.convertTimeStr((String)tableEvent.getNewValue(), (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.SECONDS);
            MetastoreConf.setTimeVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL, (long)time, (TimeUnit)TimeUnit.SECONDS);
            cleaner.setTimeToLive(MetastoreConf.getTimeVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL, (TimeUnit)TimeUnit.SECONDS));
        }
        if (key.equals(MetastoreConf.ConfVars.EVENT_DB_LISTENER_CLEAN_INTERVAL.toString()) || key.equals(MetastoreConf.ConfVars.EVENT_DB_LISTENER_CLEAN_INTERVAL.getHiveName())) {
            time = MetastoreConf.convertTimeStr((String)tableEvent.getNewValue(), (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.SECONDS);
            MetastoreConf.setTimeVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_CLEAN_INTERVAL, (long)time, (TimeUnit)TimeUnit.SECONDS);
            cleaner.setCleanupInterval(MetastoreConf.getTimeVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_CLEAN_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        FileIterator fileIter = MetaStoreUtils.isExternalTable((Table)t) ? null : new FileIterator(t.getSd().getLocation());
        CreateTableMessage msg = MessageBuilder.getInstance().buildCreateTableMessage(t, (Iterator)fileIter);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_TABLE.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(t.isSetCatName() ? t.getCatName() : "hive");
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        DropTableMessage msg = MessageBuilder.getInstance().buildDropTableMessage(t);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_TABLE.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(t.isSetCatName() ? t.getCatName() : "hive");
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        Table before = tableEvent.getOldTable();
        Table after = tableEvent.getNewTable();
        AlterTableMessage msg = MessageBuilder.getInstance().buildAlterTableMessage(before, after, tableEvent.getIsTruncateOp(), tableEvent.getWriteId());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_TABLE.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(after.isSetCatName() ? after.getCatName() : "hive");
        event.setDbName(after.getDbName());
        event.setTableName(after.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        PartitionFilesIterator fileIter = MetaStoreUtils.isExternalTable((Table)t) ? null : new PartitionFilesIterator(partitionEvent.getPartitionIterator(), t);
        AddPartitionMessage msg = MessageBuilder.getInstance().buildAddPartitionMessage(t, partitionEvent.getPartitionIterator(), (Iterator)fileIter);
        MessageSerializer serializer = this.msgEncoder.getSerializer();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_PARTITION.toString(), serializer.serialize((EventMessage)msg));
        event.setCatName(t.isSetCatName() ? t.getCatName() : "hive");
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        DropPartitionMessage msg = MessageBuilder.getInstance().buildDropPartitionMessage(t, partitionEvent.getPartitionIterator());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_PARTITION.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(t.isSetCatName() ? t.getCatName() : "hive");
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
        Partition before = partitionEvent.getOldPartition();
        Partition after = partitionEvent.getNewPartition();
        AlterPartitionMessage msg = MessageBuilder.getInstance().buildAlterPartitionMessage(partitionEvent.getTable(), before, after, partitionEvent.getIsTruncateOp(), partitionEvent.getWriteId());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_PARTITION.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(before.isSetCatName() ? before.getCatName() : "hive");
        event.setDbName(before.getDbName());
        event.setTableName(before.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        CreateDatabaseMessage msg = MessageBuilder.getInstance().buildCreateDatabaseMessage(db);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_DATABASE.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(db.isSetCatalogName() ? db.getCatalogName() : "hive");
        event.setDbName(db.getName());
        this.process(event, (ListenerEvent)dbEvent);
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        DropDatabaseMessage msg = MessageBuilder.getInstance().buildDropDatabaseMessage(db);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_DATABASE.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(db.isSetCatalogName() ? db.getCatalogName() : "hive");
        event.setDbName(db.getName());
        this.process(event, (ListenerEvent)dbEvent);
    }

    public void onAlterDatabase(AlterDatabaseEvent dbEvent) throws MetaException {
        Database oldDb = dbEvent.getOldDatabase();
        Database newDb = dbEvent.getNewDatabase();
        AlterDatabaseMessage msg = MessageBuilder.getInstance().buildAlterDatabaseMessage(oldDb, newDb);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_DATABASE.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(oldDb.isSetCatalogName() ? oldDb.getCatalogName() : "hive");
        event.setDbName(oldDb.getName());
        this.process(event, (ListenerEvent)dbEvent);
    }

    public void onCreateFunction(CreateFunctionEvent fnEvent) throws MetaException {
        Function fn = fnEvent.getFunction();
        CreateFunctionMessage msg = MessageBuilder.getInstance().buildCreateFunctionMessage(fn);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_FUNCTION.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(fn.isSetCatName() ? fn.getCatName() : "hive");
        event.setDbName(fn.getDbName());
        this.process(event, (ListenerEvent)fnEvent);
    }

    public void onDropFunction(DropFunctionEvent fnEvent) throws MetaException {
        Function fn = fnEvent.getFunction();
        DropFunctionMessage msg = MessageBuilder.getInstance().buildDropFunctionMessage(fn);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_FUNCTION.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(fn.isSetCatName() ? fn.getCatName() : "hive");
        event.setDbName(fn.getDbName());
        this.process(event, (ListenerEvent)fnEvent);
    }

    public void onInsert(InsertEvent insertEvent) throws MetaException {
        Table tableObj = insertEvent.getTableObj();
        InsertMessage msg = MessageBuilder.getInstance().buildInsertMessage(tableObj, insertEvent.getPartitionObj(), insertEvent.isReplace(), (Iterator)new FileChksumIterator(insertEvent.getFiles(), insertEvent.getFileChecksums()));
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.INSERT.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(tableObj.isSetCatName() ? tableObj.getCatName() : "hive");
        event.setDbName(tableObj.getDbName());
        event.setTableName(tableObj.getTableName());
        this.process(event, (ListenerEvent)insertEvent);
    }

    public void onOpenTxn(OpenTxnEvent openTxnEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        if (openTxnEvent.getTxnType() == TxnType.READ_ONLY) {
            return;
        }
        int lastTxnIdx = openTxnEvent.getTxnIds().size() - 1;
        OpenTxnMessage msg = MessageBuilder.getInstance().buildOpenTxnMessage((Long)openTxnEvent.getTxnIds().get(0), (Long)openTxnEvent.getTxnIds().get(lastTxnIdx));
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.OPEN_TXN.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        try {
            this.addNotificationLog(event, (ListenerEvent)openTxnEvent, dbConn, sqlGenerator);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to execute direct SQL " + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void onCommitTxn(CommitTxnEvent commitTxnEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        if (commitTxnEvent.getTxnType() == TxnType.READ_ONLY) {
            return;
        }
        CommitTxnMessage msg = MessageBuilder.getInstance().buildCommitTxnMessage(commitTxnEvent.getTxnId());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.COMMIT_TXN.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        try {
            this.addNotificationLog(event, (ListenerEvent)commitTxnEvent, dbConn, sqlGenerator);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to execute direct SQL " + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void onAbortTxn(AbortTxnEvent abortTxnEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        if (abortTxnEvent.getTxnType() == TxnType.READ_ONLY) {
            return;
        }
        AbortTxnMessage msg = MessageBuilder.getInstance().buildAbortTxnMessage(abortTxnEvent.getTxnId());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ABORT_TXN.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        try {
            this.addNotificationLog(event, (ListenerEvent)abortTxnEvent, dbConn, sqlGenerator);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to execute direct SQL " + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void onLoadPartitionDone(LoadPartitionDoneEvent partSetDoneEvent) throws MetaException {
    }

    public void onAddPrimaryKey(AddPrimaryKeyEvent addPrimaryKeyEvent) throws MetaException {
        List cols = addPrimaryKeyEvent.getPrimaryKeyCols();
        if (cols.size() > 0) {
            AddPrimaryKeyMessage msg = MessageBuilder.getInstance().buildAddPrimaryKeyMessage(addPrimaryKeyEvent.getPrimaryKeyCols());
            NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_PRIMARYKEY.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
            event.setCatName(((SQLPrimaryKey)cols.get(0)).isSetCatName() ? ((SQLPrimaryKey)cols.get(0)).getCatName() : "hive");
            event.setDbName(((SQLPrimaryKey)cols.get(0)).getTable_db());
            event.setTableName(((SQLPrimaryKey)cols.get(0)).getTable_name());
            this.process(event, (ListenerEvent)addPrimaryKeyEvent);
        }
    }

    public void onAddForeignKey(AddForeignKeyEvent addForeignKeyEvent) throws MetaException {
        List cols = addForeignKeyEvent.getForeignKeyCols();
        if (cols.size() > 0) {
            AddForeignKeyMessage msg = MessageBuilder.getInstance().buildAddForeignKeyMessage(addForeignKeyEvent.getForeignKeyCols());
            NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_FOREIGNKEY.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
            event.setCatName(((SQLForeignKey)cols.get(0)).isSetCatName() ? ((SQLForeignKey)cols.get(0)).getCatName() : "hive");
            event.setDbName(((SQLForeignKey)cols.get(0)).getPktable_db());
            event.setTableName(((SQLForeignKey)cols.get(0)).getPktable_name());
            this.process(event, (ListenerEvent)addForeignKeyEvent);
        }
    }

    public void onAddUniqueConstraint(AddUniqueConstraintEvent addUniqueConstraintEvent) throws MetaException {
        List cols = addUniqueConstraintEvent.getUniqueConstraintCols();
        if (cols.size() > 0) {
            AddUniqueConstraintMessage msg = MessageBuilder.getInstance().buildAddUniqueConstraintMessage(addUniqueConstraintEvent.getUniqueConstraintCols());
            NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_UNIQUECONSTRAINT.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
            event.setCatName(((SQLUniqueConstraint)cols.get(0)).isSetCatName() ? ((SQLUniqueConstraint)cols.get(0)).getCatName() : "hive");
            event.setDbName(((SQLUniqueConstraint)cols.get(0)).getTable_db());
            event.setTableName(((SQLUniqueConstraint)cols.get(0)).getTable_name());
            this.process(event, (ListenerEvent)addUniqueConstraintEvent);
        }
    }

    public void onAddNotNullConstraint(AddNotNullConstraintEvent addNotNullConstraintEvent) throws MetaException {
        List cols = addNotNullConstraintEvent.getNotNullConstraintCols();
        if (cols.size() > 0) {
            AddNotNullConstraintMessage msg = MessageBuilder.getInstance().buildAddNotNullConstraintMessage(addNotNullConstraintEvent.getNotNullConstraintCols());
            NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_NOTNULLCONSTRAINT.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
            event.setCatName(((SQLNotNullConstraint)cols.get(0)).isSetCatName() ? ((SQLNotNullConstraint)cols.get(0)).getCatName() : "hive");
            event.setDbName(((SQLNotNullConstraint)cols.get(0)).getTable_db());
            event.setTableName(((SQLNotNullConstraint)cols.get(0)).getTable_name());
            this.process(event, (ListenerEvent)addNotNullConstraintEvent);
        }
    }

    public void onDropConstraint(DropConstraintEvent dropConstraintEvent) throws MetaException {
        String dbName = dropConstraintEvent.getDbName();
        String tableName = dropConstraintEvent.getTableName();
        String constraintName = dropConstraintEvent.getConstraintName();
        DropConstraintMessage msg = MessageBuilder.getInstance().buildDropConstraintMessage(dbName, tableName, constraintName);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_CONSTRAINT.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(dropConstraintEvent.getCatName());
        event.setDbName(dbName);
        event.setTableName(tableName);
        this.process(event, (ListenerEvent)dropConstraintEvent);
    }

    public void onAllocWriteId(AllocWriteIdEvent allocWriteIdEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        String tableName = allocWriteIdEvent.getTableName();
        String dbName = allocWriteIdEvent.getDbName();
        AllocWriteIdMessage msg = MessageBuilder.getInstance().buildAllocWriteIdMessage(allocWriteIdEvent.getTxnToWriteIdList(), dbName, tableName);
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALLOC_WRITE_ID.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setTableName(tableName);
        event.setDbName(dbName);
        try {
            this.addNotificationLog(event, (ListenerEvent)allocWriteIdEvent, dbConn, sqlGenerator);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to execute direct SQL " + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void onAcidWrite(AcidWriteEvent acidWriteEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        AcidWriteMessage msg = MessageBuilder.getInstance().buildAcidWriteMessage(acidWriteEvent, (Iterator)new FileChksumIterator(acidWriteEvent.getFiles(), acidWriteEvent.getChecksums(), acidWriteEvent.getSubDirs()));
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ACID_WRITE.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setMessageFormat(this.msgEncoder.getMessageFormat());
        event.setDbName(acidWriteEvent.getDatabase());
        event.setTableName(acidWriteEvent.getTable());
        try {
            this.addWriteNotificationLog(event, acidWriteEvent, dbConn, sqlGenerator, msg);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to add write notification log " + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void onUpdateTableColumnStat(UpdateTableColumnStatEvent updateTableColumnStatEvent) throws MetaException {
        JSONUpdateTableColumnStatMessage msg = MessageBuilder.getInstance().buildUpdateTableColumnStatMessage(updateTableColumnStatEvent.getColStats(), updateTableColumnStatEvent.getTableObj(), updateTableColumnStatEvent.getTableParameters(), updateTableColumnStatEvent.getWriteId());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.UPDATE_TABLE_COLUMN_STAT.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        ColumnStatisticsDesc statDesc = updateTableColumnStatEvent.getColStats().getStatsDesc();
        event.setCatName(statDesc.isSetCatName() ? statDesc.getCatName() : "hive");
        event.setDbName(statDesc.getDbName());
        event.setTableName(statDesc.getTableName());
        this.process(event, (ListenerEvent)updateTableColumnStatEvent);
    }

    public void onDeleteTableColumnStat(DeleteTableColumnStatEvent deleteTableColumnStatEvent) throws MetaException {
        JSONDeleteTableColumnStatMessage msg = MessageBuilder.getInstance().buildDeleteTableColumnStatMessage(deleteTableColumnStatEvent.getDBName(), deleteTableColumnStatEvent.getColName());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DELETE_TABLE_COLUMN_STAT.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(deleteTableColumnStatEvent.getCatName());
        event.setDbName(deleteTableColumnStatEvent.getDBName());
        event.setTableName(deleteTableColumnStatEvent.getTableName());
        this.process(event, (ListenerEvent)deleteTableColumnStatEvent);
    }

    public void onUpdatePartitionColumnStat(UpdatePartitionColumnStatEvent updatePartColStatEvent) throws MetaException {
        JSONUpdatePartitionColumnStatMessage msg = MessageBuilder.getInstance().buildUpdatePartitionColumnStatMessage(updatePartColStatEvent.getPartColStats(), updatePartColStatEvent.getPartVals(), updatePartColStatEvent.getPartParameters(), updatePartColStatEvent.getTableObj(), updatePartColStatEvent.getWriteId());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.UPDATE_PARTITION_COLUMN_STAT.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        ColumnStatisticsDesc statDesc = updatePartColStatEvent.getPartColStats().getStatsDesc();
        event.setCatName(statDesc.isSetCatName() ? statDesc.getCatName() : "hive");
        event.setDbName(statDesc.getDbName());
        event.setTableName(statDesc.getTableName());
        this.process(event, (ListenerEvent)updatePartColStatEvent);
    }

    public void onDeletePartitionColumnStat(DeletePartitionColumnStatEvent deletePartColStatEvent) throws MetaException {
        JSONDeletePartitionColumnStatMessage msg = MessageBuilder.getInstance().buildDeletePartitionColumnStatMessage(deletePartColStatEvent.getDBName(), deletePartColStatEvent.getColName(), deletePartColStatEvent.getPartName(), deletePartColStatEvent.getPartVals());
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DELETE_PARTITION_COLUMN_STAT.toString(), this.msgEncoder.getSerializer().serialize((EventMessage)msg));
        event.setCatName(deletePartColStatEvent.getCatName());
        event.setDbName(deletePartColStatEvent.getDBName());
        event.setTableName(deletePartColStatEvent.getTableName());
        this.process(event, (ListenerEvent)deletePartColStatEvent);
    }

    public boolean doesAddEventsToNotificationLogTable() {
        return true;
    }

    private int now() {
        long millis = System.currentTimeMillis();
        if ((millis /= 1000L) > Integer.MAX_VALUE) {
            LOG.warn("We've passed max int value in seconds since the epoch, all notification times will be the same!");
            return Integer.MAX_VALUE;
        }
        return (int)millis;
    }

    private static void closeStmt(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close statement " + e.getMessage());
        }
    }

    private static void close(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            LOG.warn("Failed to close result set " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextNLId(Statement stmt, SQLGenerator sqlGenerator, String sequence) throws SQLException, MetaException {
        String s = sqlGenerator.addForUpdateClause("select \"NEXT_VAL\" from \"SEQUENCE_TABLE\" where \"SEQUENCE_NAME\" = " + DbNotificationListener.quoteString(sequence));
        LOG.debug("Going to execute query <" + s + ">");
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction database not properly configured, can't find next NL id.");
            }
            long nextNLId = rs.getLong(1);
            long updatedNLId = nextNLId + 1L;
            s = "update \"SEQUENCE_TABLE\" set \"NEXT_VAL\" = " + updatedNLId + " where \"SEQUENCE_NAME\" = " + DbNotificationListener.quoteString(sequence);
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            long l = nextNLId;
            return l;
        }
        finally {
            DbNotificationListener.close(rs);
        }
    }

    private void addWriteNotificationLog(NotificationEvent event, AcidWriteEvent acidWriteEvent, Connection dbConn, SQLGenerator sqlGenerator, AcidWriteMessage msg) throws MetaException, SQLException {
        ResultSet rs;
        PreparedStatement pst;
        Statement stmt;
        block8: {
            String existingFiles;
            String s;
            String files;
            String partitionObj;
            String tableObj;
            block9: {
                LOG.debug("DbNotificationListener: adding write notification log for : {}", (Object)event.getMessage());
                assert (dbConn != null && sqlGenerator != null);
                stmt = null;
                pst = null;
                rs = null;
                String dbName = acidWriteEvent.getDatabase();
                String tblName = acidWriteEvent.getTable();
                String partition = acidWriteEvent.getPartition();
                tableObj = msg.getTableObjStr();
                partitionObj = msg.getPartitionObjStr();
                files = ReplChangeManager.joinWithSeparator((Iterable)msg.getFiles());
                stmt = dbConn.createStatement();
                if (sqlGenerator.getDbProduct() == DatabaseProduct.MYSQL) {
                    stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
                }
                s = sqlGenerator.addForUpdateClause("select \"WNL_FILES\", \"WNL_ID\" from \"TXN_WRITE_NOTIFICATION_LOG\" where \"WNL_DATABASE\" = ? and \"WNL_TABLE\" = ?  and \"WNL_PARTITION\" = ? and \"WNL_TXNID\" = " + Long.toString(acidWriteEvent.getTxnId()));
                List<String> params = Arrays.asList(dbName, tblName, partition);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                LOG.debug("Going to execute query <" + s.replaceAll("\\?", "{}") + ">", new Object[]{DbNotificationListener.quoteString(dbName), DbNotificationListener.quoteString(tblName), DbNotificationListener.quoteString(partition)});
                rs = pst.executeQuery();
                if (!rs.next()) {
                    long nextNLId = this.getNextNLId(stmt, sqlGenerator, "org.apache.hadoop.hive.metastore.model.MTxnWriteNotificationLog");
                    s = "insert into \"TXN_WRITE_NOTIFICATION_LOG\" (\"WNL_ID\", \"WNL_TXNID\", \"WNL_WRITEID\", \"WNL_DATABASE\", \"WNL_TABLE\", \"WNL_PARTITION\", \"WNL_TABLE_OBJ\", \"WNL_PARTITION_OBJ\", \"WNL_FILES\", \"WNL_EVENT_TIME\") VALUES (?,?,?,?,?,?,?,?,?,?)";
                    DbNotificationListener.closeStmt(pst);
                    int currentTime = this.now();
                    pst = dbConn.prepareStatement(sqlGenerator.addEscapeCharacters(s));
                    pst.setLong(1, nextNLId);
                    pst.setLong(2, acidWriteEvent.getTxnId());
                    pst.setLong(3, acidWriteEvent.getWriteId());
                    pst.setString(4, dbName);
                    pst.setString(5, tblName);
                    pst.setString(6, partition);
                    pst.setString(7, tableObj);
                    pst.setString(8, partitionObj);
                    pst.setString(9, files);
                    pst.setInt(10, currentTime);
                    LOG.info("Going to execute insert <" + s.replaceAll("\\?", "{}") + ">", new Object[]{nextNLId, acidWriteEvent.getTxnId(), acidWriteEvent.getWriteId(), DbNotificationListener.quoteString(dbName), DbNotificationListener.quoteString(tblName), DbNotificationListener.quoteString(partition), DbNotificationListener.quoteString(tableObj), DbNotificationListener.quoteString(partitionObj), DbNotificationListener.quoteString(files), currentTime});
                    pst.execute();
                    break block8;
                }
                existingFiles = rs.getString(1);
                if (!existingFiles.contains(sqlGenerator.addEscapeCharacters(files))) break block9;
                LOG.info("file list " + files + " already present");
                DbNotificationListener.closeStmt(stmt);
                DbNotificationListener.closeStmt(pst);
                DbNotificationListener.close(rs);
                return;
            }
            try {
                long nlId = rs.getLong(2);
                int currentTime = this.now();
                files = ReplChangeManager.joinWithSeparator((Iterable)Lists.newArrayList((Object[])new String[]{files, existingFiles}));
                s = "update \"TXN_WRITE_NOTIFICATION_LOG\" set \"WNL_TABLE_OBJ\" = ? , \"WNL_PARTITION_OBJ\" = ? , \"WNL_FILES\" = ? , \"WNL_EVENT_TIME\" = ? where \"WNL_ID\" = ?";
                DbNotificationListener.closeStmt(pst);
                pst = dbConn.prepareStatement(sqlGenerator.addEscapeCharacters(s));
                pst.setString(1, tableObj);
                pst.setString(2, partitionObj);
                pst.setString(3, files);
                pst.setInt(4, currentTime);
                pst.setLong(5, nlId);
                LOG.info("Going to execute update <" + s.replaceAll("\\?", "{}") + ">", new Object[]{DbNotificationListener.quoteString(tableObj), DbNotificationListener.quoteString(partitionObj), DbNotificationListener.quoteString(files), currentTime, nlId});
                pst.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    LOG.warn("failed to add write notification log" + e.getMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    DbNotificationListener.closeStmt(stmt);
                    DbNotificationListener.closeStmt(pst);
                    DbNotificationListener.close(rs);
                    throw throwable;
                }
            }
        }
        DbNotificationListener.closeStmt(stmt);
        DbNotificationListener.closeStmt(pst);
        DbNotificationListener.close(rs);
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }

    private void addNotificationLog(NotificationEvent event, ListenerEvent listenerEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException, SQLException {
        LOG.debug("DbNotificationListener: adding notification log for : {}", (Object)event.getMessage());
        if (dbConn == null || sqlGenerator == null) {
            LOG.info("connection or sql generator is not set so executing sql via DN");
            this.process(event, listenerEvent);
            return;
        }
        Statement stmt = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            String catName;
            String tableName;
            stmt = dbConn.createStatement();
            event.setMessageFormat(this.msgEncoder.getMessageFormat());
            if (sqlGenerator.getDbProduct() == DatabaseProduct.MYSQL) {
                stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
            }
            if (sqlGenerator.getDbProduct() == DatabaseProduct.DERBY) {
                String lockingQuery = "lock table \"NOTIFICATION_SEQUENCE\" in exclusive mode";
                LOG.info("Going to execute query <" + lockingQuery + ">");
                stmt.executeUpdate(lockingQuery);
            }
            String s = sqlGenerator.addForUpdateClause("select \"NEXT_EVENT_ID\"  from \"NOTIFICATION_SEQUENCE\"");
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction database not properly configured, can't find next event id.");
            }
            long nextEventId = rs.getLong(1);
            long updatedEventid = nextEventId + 1L;
            s = "update \"NOTIFICATION_SEQUENCE\" set \"NEXT_EVENT_ID\" = " + updatedEventid;
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            long nextNLId = this.getNextNLId(stmt, sqlGenerator, "org.apache.hadoop.hive.metastore.model.MNotificationLog");
            ArrayList<String> params = new ArrayList<String>();
            String columns = "\"NL_ID\"";
            String insertVal = "" + nextNLId;
            columns = columns + ", \"EVENT_ID\"";
            insertVal = insertVal + "," + nextEventId;
            columns = columns + ", \"EVENT_TIME\"";
            insertVal = insertVal + "," + this.now();
            columns = columns + ", \"EVENT_TYPE\"";
            insertVal = insertVal + ", ?";
            params.add(event.getEventType());
            columns = columns + ", \"MESSAGE\"";
            insertVal = insertVal + ", ?";
            params.add(event.getMessage());
            columns = columns + ", \"MESSAGE_FORMAT\"";
            insertVal = insertVal + ", ?";
            params.add(event.getMessageFormat());
            String dbName = event.getDbName();
            if (dbName != null) {
                assert (dbName.equals(dbName.toLowerCase()));
                columns = columns + ", \"DB_NAME\"";
                insertVal = insertVal + ", ?";
                params.add(dbName);
            }
            if ((tableName = event.getTableName()) != null) {
                assert (tableName.equals(tableName.toLowerCase()));
                columns = columns + ", \"TBL_NAME\"";
                insertVal = insertVal + ", ?";
                params.add(tableName);
            }
            if ((catName = event.getCatName()) != null) {
                assert (catName.equals(catName.toLowerCase()));
                columns = columns + ", \"CAT_NAME\"";
                insertVal = insertVal + ", ?";
                params.add(catName);
            }
            s = "insert into \"NOTIFICATION_LOG\" (" + columns + ") VALUES (" + insertVal + ")";
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            LOG.debug("Going to execute insert <" + s + "> with parameters (" + String.join((CharSequence)", ", params) + ")");
            pst.execute();
            event.setEventId(nextEventId);
            if (event.isSetEventId()) {
                listenerEvent.putParameter("DB_NOTIFICATION_EVENT_ID_KEY_NAME", Long.toString(event.getEventId()));
            }
        }
        catch (SQLException e) {
            try {
                LOG.warn("failed to add notification log" + e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                DbNotificationListener.closeStmt(stmt);
                DbNotificationListener.closeStmt(pst);
                DbNotificationListener.close(rs);
                throw throwable;
            }
        }
        DbNotificationListener.closeStmt(stmt);
        DbNotificationListener.closeStmt(pst);
        DbNotificationListener.close(rs);
    }

    private void process(NotificationEvent event, ListenerEvent listenerEvent) throws MetaException {
        event.setMessageFormat(this.msgEncoder.getMessageFormat());
        LOG.debug("DbNotificationListener: Processing : {}:{}", (Object)event.getEventId(), (Object)event.getMessage());
        HiveMetaStore.HMSHandler.getMSForConf((Configuration)this.conf).addNotificationEvent(event);
        if (event.isSetEventId()) {
            listenerEvent.putParameter("DB_NOTIFICATION_EVENT_ID_KEY_NAME", Long.toString(event.getEventId()));
        }
    }

    private static class CleanerThread
    extends Thread {
        private RawStore rs;
        private int ttl;
        private long sleepTime;

        CleanerThread(Configuration conf, RawStore rs) {
            super("DB-Notification-Cleaner");
            this.rs = rs;
            this.setTimeToLive(MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL, (TimeUnit)TimeUnit.SECONDS));
            this.setCleanupInterval(MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_CLEAN_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS));
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.rs.cleanNotificationEvents(this.ttl);
                    this.rs.cleanWriteNotificationEvents(this.ttl);
                }
                catch (Exception ex) {
                    LOG.warn("Exception received while cleaning notifications: ", (Throwable)ex);
                }
                LOG.debug("Cleaner thread done");
                try {
                    Thread.sleep(this.sleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.info("Cleaner thread sleep interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        public void setTimeToLive(long configTtl) {
            this.ttl = configTtl > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)configTtl;
        }

        public void setCleanupInterval(long configInterval) {
            this.sleepTime = configInterval;
        }
    }

    class FileChksumIterator
    implements Iterator<String> {
        private List<String> files;
        private List<String> chksums;
        private List<String> subDirs;
        int i = 0;

        FileChksumIterator(List<String> files, List<String> chksums) {
            this(files, chksums, null);
        }

        FileChksumIterator(List<String> files, List<String> chksums, List<String> subDirs) {
            this.files = files;
            this.chksums = chksums;
            this.subDirs = subDirs;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.files.size();
        }

        @Override
        public String next() {
            String result;
            try {
                result = ReplChangeManager.encodeFileUri((String)this.files.get(this.i), this.chksums != null && !this.chksums.isEmpty() ? this.chksums.get(this.i) : null, this.subDirs != null ? this.subDirs.get(this.i) : null);
            }
            catch (IOException e) {
                LOG.error("Encoding file URI failed with error " + e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
            ++this.i;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class PartitionFilesIterator
    implements Iterator<PartitionFiles> {
        private Iterator<Partition> partitionIter;
        private Table t;

        PartitionFilesIterator(Iterator<Partition> partitionIter, Table t) {
            this.partitionIter = partitionIter;
            this.t = t;
        }

        @Override
        public boolean hasNext() {
            return this.partitionIter.hasNext();
        }

        @Override
        public PartitionFiles next() {
            try {
                Iterator<Object> fileIterator;
                Partition p = this.partitionIter.next();
                if (!TxnUtils.isTransactionalTable((Table)this.t)) {
                    ArrayList files = Lists.newArrayList((Iterator)new FileIterator(p.getSd().getLocation()));
                    fileIterator = files.iterator();
                } else {
                    fileIterator = Collections.emptyIterator();
                }
                PartitionFiles partitionFiles = new PartitionFiles(Warehouse.makePartName((List)this.t.getPartitionKeys(), (List)p.getValues()), fileIterator);
                return partitionFiles;
            }
            catch (MetaException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class FileIterator
    implements Iterator<String> {
        PathFilter VALID_FILES_FILTER = new PathFilter(){

            public boolean accept(Path p) {
                try {
                    if (!FileIterator.this.fs.isFile(p)) {
                        return false;
                    }
                    String name = p.getName();
                    return !name.startsWith("_") && !name.startsWith(".");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        private FileSystem fs;
        private FileStatus[] files;
        private int i = 0;

        FileIterator(String locString) {
            try {
                if (locString != null) {
                    Path loc = new Path(locString);
                    this.fs = loc.getFileSystem(DbNotificationListener.this.conf);
                    this.files = this.fs.listStatus(loc, this.VALID_FILES_FILTER);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.files == null) {
                return false;
            }
            return this.i < this.files.length;
        }

        @Override
        public String next() {
            try {
                FileStatus file = this.files[this.i];
                ++this.i;
                return ReplChangeManager.encodeFileUri((String)file.getPath().toString(), (String)ReplChangeManager.checksumFor((Path)file.getPath(), (FileSystem)this.fs), null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

