/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TxnUtils.class);

    public static ValidTxnList createValidTxnListForCleaner(GetOpenTxnsResponse txns, long minOpenTxnGLB) {
        long txnId;
        long highWaterMark = minOpenTxnGLB - 1L;
        long[] abortedTxns = new long[txns.getOpen_txnsSize()];
        BitSet abortedBits = BitSet.valueOf(txns.getAbortedBits());
        int i = 0;
        Iterator iterator = txns.getOpen_txns().iterator();
        while (iterator.hasNext() && (txnId = ((Long)iterator.next()).longValue()) <= highWaterMark) {
            if (abortedBits.get(i)) {
                abortedTxns[i] = txnId;
            } else assert (false) : JavaUtils.txnIdToString((long)txnId) + " is open and <= hwm:" + highWaterMark;
            ++i;
        }
        abortedTxns = Arrays.copyOf(abortedTxns, i);
        BitSet bitSet = new BitSet(abortedTxns.length);
        bitSet.set(0, abortedTxns.length);
        return new ValidReadTxnList(abortedTxns, bitSet, highWaterMark, Long.MAX_VALUE);
    }

    public static ValidCompactorWriteIdList createValidCompactWriteIdList(TableValidWriteIds tableValidWriteIds) {
        String fullTableName = tableValidWriteIds.getFullTableName();
        long highWater = tableValidWriteIds.getWriteIdHighWaterMark();
        long minOpenWriteId = Long.MAX_VALUE;
        List invalids = tableValidWriteIds.getInvalidWriteIds();
        BitSet abortedBits = BitSet.valueOf(tableValidWriteIds.getAbortedBits());
        long[] exceptions = new long[invalids.size()];
        int i = 0;
        Iterator iterator = invalids.iterator();
        while (iterator.hasNext()) {
            long writeId = (Long)iterator.next();
            if (abortedBits.get(i)) {
                exceptions[i++] = writeId;
                continue;
            }
            minOpenWriteId = Math.min(minOpenWriteId, writeId);
        }
        if (i < exceptions.length) {
            exceptions = Arrays.copyOf(exceptions, i);
        }
        highWater = minOpenWriteId == Long.MAX_VALUE ? highWater : minOpenWriteId - 1L;
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0, exceptions.length);
        if (minOpenWriteId == Long.MAX_VALUE) {
            return new ValidCompactorWriteIdList(fullTableName, exceptions, bitSet, highWater);
        }
        return new ValidCompactorWriteIdList(fullTableName, exceptions, bitSet, highWater, minOpenWriteId);
    }

    public static TxnStore getTxnStore(Configuration conf) {
        String className = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_STORE_IMPL);
        try {
            TxnStore handler = (TxnStore)JavaUtils.getClass((String)className, TxnStore.class).newInstance();
            handler.setConf(conf);
            return handler;
        }
        catch (Exception e) {
            LOG.error("Unable to instantiate raw store directly in fastpath mode", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isTransactionalTable(Table table) {
        if (table == null) {
            return false;
        }
        Map parameters = table.getParameters();
        if (parameters == null) {
            return false;
        }
        String tableIsTransactional = (String)parameters.get("transactional");
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static boolean isTransactionalTable(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        String tableIsTransactional = parameters.get("transactional");
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static boolean isAcidTable(Table table) {
        return TxnUtils.isTransactionalTable(table) && "default".equals(table.getParameters().get("transactional_properties"));
    }

    public static String getFullTableName(String dbName, String tableName) {
        return dbName.toLowerCase() + "." + tableName.toLowerCase();
    }

    public static String[] getDbTableName(String fullTableName) {
        return fullTableName.split("\\.");
    }

    public static List<Integer> buildQueryWithINClause(Configuration conf, List<String> queries, StringBuilder prefix, StringBuilder suffix, List<Long> inList, String inColumn, boolean addParens, boolean notIn) {
        ArrayList<String> inListStrings = new ArrayList<String>(inList.size());
        for (Long aLong : inList) {
            inListStrings.add(aLong.toString());
        }
        return TxnUtils.buildQueryWithINClauseStrings(conf, queries, prefix, suffix, inListStrings, inColumn, addParens, notIn);
    }

    public static List<Integer> buildQueryWithINClauseStrings(Configuration conf, List<String> queries, StringBuilder prefix, StringBuilder suffix, List<String> inList, String inColumn, boolean addParens, boolean notIn) {
        int maxQueryLength = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH);
        int batchSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_IN_CLAUSE);
        if (inList == null || inList.size() == 0 || maxQueryLength <= 0 || batchSize <= 0) {
            throw new IllegalArgumentException("The IN list is empty!");
        }
        int inListSize = inList.size();
        StringBuilder buf = new StringBuilder();
        int cursor4InListArray = 0;
        int cursor4InClauseElements = 0;
        int cursor4queryOfInClauses = 0;
        boolean nextItemNeeded = true;
        boolean newInclausePrefixJustAppended = false;
        StringBuilder nextValue = new StringBuilder("");
        StringBuilder newInclausePrefix = new StringBuilder(notIn ? " and " + inColumn + " not in (" : " or " + inColumn + " in (");
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int currentCount = 0;
        while (cursor4InListArray < inListSize || !nextItemNeeded) {
            int querySize;
            if (cursor4queryOfInClauses == 0) {
                buf.append((CharSequence)prefix);
                if (addParens) {
                    buf.append("(");
                }
                buf.append(inColumn);
                if (notIn) {
                    buf.append(" not in (");
                } else {
                    buf.append(" in (");
                }
                ++cursor4queryOfInClauses;
                newInclausePrefixJustAppended = false;
            }
            if (nextItemNeeded) {
                nextValue.setLength(0);
                nextValue.append(String.valueOf(inList.get(cursor4InListArray++)));
                nextItemNeeded = false;
            }
            if ((querySize = TxnUtils.querySizeExpected(buf.length(), nextValue.length(), suffix.length(), addParens)) > maxQueryLength * 1024) {
                if (cursor4queryOfInClauses == 1 && cursor4InClauseElements == 0) {
                    throw new IllegalArgumentException("The current " + MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH.getVarname() + " is set too small to have one IN clause with single value!");
                }
                if (notIn) {
                    throw new IllegalArgumentException("The NOT IN list has too many elements for the current " + MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH.getVarname() + "!");
                }
                if (newInclausePrefixJustAppended) {
                    buf.delete(buf.length() - newInclausePrefix.length(), buf.length());
                }
                buf.setCharAt(buf.length() - 1, ')');
                if (addParens) {
                    buf.append(")");
                }
                buf.append((CharSequence)suffix);
                queries.add(buf.toString());
                ret.add(currentCount);
                buf.setLength(0);
                currentCount = 0;
                cursor4InClauseElements = 0;
                cursor4queryOfInClauses = 0;
                querySize = 0;
                newInclausePrefixJustAppended = false;
                continue;
            }
            if (cursor4InClauseElements >= batchSize - 1 && cursor4InClauseElements != 0) {
                buf.setCharAt(buf.length() - 1, ')');
                buf.append(newInclausePrefix.toString());
                newInclausePrefixJustAppended = true;
                ++cursor4queryOfInClauses;
                cursor4InClauseElements = 0;
                continue;
            }
            buf.append(nextValue.toString()).append(",");
            ++currentCount;
            nextItemNeeded = true;
            newInclausePrefixJustAppended = false;
            ++cursor4InClauseElements;
        }
        if (newInclausePrefixJustAppended) {
            buf.delete(buf.length() - newInclausePrefix.length(), buf.length());
        }
        buf.setCharAt(buf.length() - 1, ')');
        if (addParens) {
            buf.append(")");
        }
        buf.append((CharSequence)suffix);
        queries.add(buf.toString());
        ret.add(currentCount);
        return ret;
    }

    private static int querySizeExpected(int sizeSoFar, int sizeNextItem, int suffixSize, boolean addParens) {
        int size = sizeSoFar + sizeNextItem + suffixSize;
        if (addParens) {
            ++size;
        }
        return size;
    }
}

