/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenSecretManager;
import org.apache.hadoop.hive.metastore.security.DelegationTokenStore;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.security.token.delegation.MetastoreDelegationTokenSupport;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenStoreDelegationTokenSecretManager
extends DelegationTokenSecretManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TokenStoreDelegationTokenSecretManager.class.getName());
    private final long keyUpdateInterval;
    private final long tokenRemoverScanInterval;
    private Thread tokenRemoverThread;
    private final DelegationTokenStore tokenStore;

    public TokenStoreDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, DelegationTokenStore sharedStore) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.keyUpdateInterval = delegationKeyUpdateInterval;
        this.tokenRemoverScanInterval = delegationTokenRemoverScanInterval;
        this.tokenStore = sharedStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, DelegationKey> reloadKeys() {
        String[] allKeys = this.tokenStore.getMasterKeys();
        HashMap<Integer, DelegationKey> keys = new HashMap<Integer, DelegationKey>(allKeys.length);
        for (String keyStr : allKeys) {
            DelegationKey key = new DelegationKey();
            try {
                TokenStoreDelegationTokenSecretManager.decodeWritable((Writable)key, keyStr);
                keys.put(key.getKeyId(), key);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load master key.", (Throwable)ex);
            }
        }
        TokenStoreDelegationTokenSecretManager tokenStoreDelegationTokenSecretManager = this;
        synchronized (tokenStoreDelegationTokenSecretManager) {
            this.allKeys.clear();
            this.allKeys.putAll(keys);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrievePassword(DelegationTokenIdentifier identifier) throws SecretManager.InvalidToken {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = this.tokenStore.getToken(identifier);
        if (info == null) {
            throw new SecretManager.InvalidToken("token expired or does not exist: " + identifier);
        }
        TokenStoreDelegationTokenSecretManager tokenStoreDelegationTokenSecretManager = this;
        synchronized (tokenStoreDelegationTokenSecretManager) {
            byte[] byArray;
            try {
                this.currentTokens.put(identifier, info);
                byArray = super.retrievePassword((AbstractDelegationTokenIdentifier)identifier);
                this.currentTokens.remove(identifier);
            }
            catch (Throwable throwable) {
                this.currentTokens.remove(identifier);
                throw throwable;
            }
            return byArray;
        }
    }

    public DelegationTokenIdentifier cancelToken(Token<DelegationTokenIdentifier> token, String canceller) throws IOException {
        DelegationTokenIdentifier id = this.getTokenIdentifier(token);
        LOGGER.info("Token cancellation requested for identifier: " + id);
        this.tokenStore.removeToken(id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] createPassword(DelegationTokenIdentifier id) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info;
        byte[] password;
        TokenStoreDelegationTokenSecretManager tokenStoreDelegationTokenSecretManager = this;
        synchronized (tokenStoreDelegationTokenSecretManager) {
            password = super.createPassword((AbstractDelegationTokenIdentifier)id);
            info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.remove(id);
            if (info == null) {
                throw new IllegalStateException("Failed to retrieve token after creation");
            }
        }
        this.tokenStore.addToken(id, info);
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renewToken(Token<DelegationTokenIdentifier> token, String renewer) throws IOException {
        DelegationTokenIdentifier id = this.getTokenIdentifier(token);
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.tokenStore.getToken(id);
        if (tokenInfo == null) {
            throw new SecretManager.InvalidToken("token does not exist: " + id);
        }
        if (!this.allKeys.containsKey(id.getMasterKeyId())) {
            LOGGER.info("Unknown master key (id={}), (re)loading keys from token store.", (Object)id.getMasterKeyId());
            this.reloadKeys();
        }
        TokenStoreDelegationTokenSecretManager tokenStoreDelegationTokenSecretManager = this;
        synchronized (tokenStoreDelegationTokenSecretManager) {
            long l;
            this.currentTokens.put(id, tokenInfo);
            try {
                long res = super.renewToken(token, renewer);
                this.tokenStore.removeToken(id);
                this.tokenStore.addToken(id, (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(id));
                l = res;
                this.currentTokens.remove(id);
            }
            catch (Throwable throwable) {
                this.currentTokens.remove(id);
                throw throwable;
            }
            return l;
        }
    }

    public static String encodeWritable(Writable key) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        key.write((DataOutput)dos);
        dos.flush();
        return Base64.encodeBase64URLSafeString((byte[])bos.toByteArray());
    }

    public static void decodeWritable(Writable w, String idStr) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(Base64.decodeBase64((String)idStr)));
        w.readFields((DataInput)in);
    }

    protected void logUpdateMasterKey(DelegationKey key) throws IOException {
        int keySeq = this.tokenStore.addMasterKey(TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)key));
        DelegationKey keyWithSeq = new DelegationKey(keySeq, key.getExpiryDate(), key.getKey());
        String keyStr = TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)keyWithSeq);
        this.tokenStore.updateMasterKey(keySeq, keyStr);
        TokenStoreDelegationTokenSecretManager.decodeWritable((Writable)key, keyStr);
        LOGGER.info("New master key with key id={}", (Object)key.getKeyId());
        super.logUpdateMasterKey(key);
    }

    public synchronized void startThreads() throws IOException {
        try {
            Method m = AbstractDelegationTokenSecretManager.class.getDeclaredMethod("updateCurrentKey", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize master key", e);
        }
        this.running = true;
        this.tokenRemoverThread = new Daemon((Runnable)new ExpiredTokenRemover());
        this.tokenRemoverThread.start();
    }

    public synchronized void stopThreads() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stopping expired delegation token remover thread");
        }
        this.running = false;
        if (this.tokenRemoverThread != null) {
            this.tokenRemoverThread.interrupt();
        }
    }

    protected void removeExpiredTokens() {
        long now = System.currentTimeMillis();
        for (DelegationTokenIdentifier id : this.tokenStore.getAllDelegationTokenIdentifiers()) {
            if (now > id.getMaxDate()) {
                this.tokenStore.removeToken(id);
                continue;
            }
            AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.tokenStore.getToken(id);
            if (tokenInfo == null || now <= tokenInfo.getRenewDate()) continue;
            this.tokenStore.removeToken(id);
        }
    }

    protected void rollMasterKeyExt() throws IOException {
        Map<Integer, DelegationKey> keys = this.reloadKeys();
        int currentKeyId = this.currentId;
        MetastoreDelegationTokenSupport.rollMasterKey((AbstractDelegationTokenSecretManager)this);
        List<DelegationKey> keysAfterRoll = Arrays.asList(this.getAllKeys());
        for (DelegationKey key : keysAfterRoll) {
            keys.remove(key.getKeyId());
            if (key.getKeyId() != currentKeyId) continue;
            this.tokenStore.updateMasterKey(currentKeyId, TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)key));
        }
        for (DelegationKey expiredKey : keys.values()) {
            LOGGER.info("Removing expired key id={}", (Object)expiredKey.getKeyId());
            try {
                this.tokenStore.removeMasterKey(expiredKey.getKeyId());
            }
            catch (Exception e) {
                LOGGER.error("Error removing expired key id={}", (Object)expiredKey.getKeyId(), (Object)e);
            }
        }
    }

    protected class ExpiredTokenRemover
    extends Thread {
        private long lastMasterKeyUpdate;
        private long lastTokenCacheCleanup;

        protected ExpiredTokenRemover() {
        }

        @Override
        public void run() {
            LOGGER.info("Starting expired delegation token remover thread, tokenRemoverScanInterval=" + TokenStoreDelegationTokenSecretManager.this.tokenRemoverScanInterval / 60000L + " min(s)");
            while (TokenStoreDelegationTokenSecretManager.this.running) {
                try {
                    long now = System.currentTimeMillis();
                    if (this.lastMasterKeyUpdate + TokenStoreDelegationTokenSecretManager.this.keyUpdateInterval < now) {
                        try {
                            TokenStoreDelegationTokenSecretManager.this.rollMasterKeyExt();
                            this.lastMasterKeyUpdate = now;
                        }
                        catch (IOException e) {
                            LOGGER.error("Master key updating failed. " + StringUtils.stringifyException((Throwable)e));
                        }
                    }
                    if (this.lastTokenCacheCleanup + TokenStoreDelegationTokenSecretManager.this.tokenRemoverScanInterval < now) {
                        TokenStoreDelegationTokenSecretManager.this.removeExpiredTokens();
                        this.lastTokenCacheCleanup = now;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.error("InterruptedException received for ExpiredTokenRemover thread " + ie);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("ExpiredTokenRemover thread received unexpected exception. " + t, t);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.error("InterruptedException received for ExpiredTokenRemover thread during wait in exception sleep " + ie);
                    }
                }
            }
        }
    }
}

