/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoneCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BoneCPDataSourceProvider.class);
    public static final String BONECP = "bonecp";
    private static final String CONNECTION_TIMEOUT_PROPERTY = "bonecp.connectionTimeoutInMs";
    private static final String PARTITION_COUNT_PROPERTY = "bonecp.partitionCount";

    @Override
    public DataSource create(Configuration hdpConfig) throws SQLException {
        BoneCPConfig config;
        LOG.debug("Creating BoneCP connection pool for the MetaStore");
        String driverUrl = DataSourceProvider.getMetastoreJdbcDriverUrl(hdpConfig);
        String user = DataSourceProvider.getMetastoreJdbcUser(hdpConfig);
        String passwd = DataSourceProvider.getMetastoreJdbcPasswd(hdpConfig);
        int maxPoolSize = MetastoreConf.getIntVar((Configuration)hdpConfig, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS);
        Properties properties = DataSourceProvider.getPrefixedProperties(hdpConfig, BONECP);
        long connectionTimeout = hdpConfig.getLong(CONNECTION_TIMEOUT_PROPERTY, 30000L);
        String partitionCount = properties.getProperty(PARTITION_COUNT_PROPERTY, "1");
        try {
            config = new BoneCPConfig(properties);
        }
        catch (Exception e) {
            throw new SQLException("Cannot create BoneCP configuration: ", e);
        }
        config.setJdbcUrl(driverUrl);
        config.setUser(user);
        config.setPassword(passwd);
        config.setConnectionTimeoutInMs(connectionTimeout);
        config.setMaxConnectionsPerPartition(maxPoolSize);
        config.setPartitionCount(Integer.parseInt(partitionCount));
        Properties connProperties = new Properties();
        DatabaseProduct dbProduct = DatabaseProduct.determineDatabaseProduct(driverUrl);
        switch (dbProduct) {
            case MYSQL: {
                connProperties.put("allowMultiQueries", (Object)true);
                connProperties.put("rewriteBatchedStatements", (Object)true);
                break;
            }
            case POSTGRES: {
                connProperties.put("reWriteBatchedInserts", (Object)true);
            }
        }
        config.setDriverProperties(connProperties);
        if (dbProduct == DatabaseProduct.MYSQL) {
            config.setInitSQL("SET @@session.sql_mode=ANSI_QUOTES");
        }
        return this.initMetrics(new BoneCPDataSource(config));
    }

    @Override
    public boolean mayReturnClosedConnection() {
        return true;
    }

    @Override
    public String getPoolingType() {
        return BONECP;
    }

    private BoneCPDataSource initMetrics(BoneCPDataSource ds) {
        MetricRegistry registry = Metrics.getRegistry();
        if (registry != null) {
            registry.registerAll((MetricSet)new BoneCPMetrics(ds));
        }
        return ds;
    }

    private static class BoneCPMetrics
    implements MetricSet {
        private BoneCPDataSource ds;
        private Optional<String> poolName;

        private BoneCPMetrics(BoneCPDataSource ds) {
            this.ds = ds;
            this.poolName = Optional.ofNullable(ds.getPoolName());
        }

        private String name(String gaugeName) {
            return this.poolName.orElse("BoneCP") + ".pool." + gaugeName;
        }

        public Map<String, Metric> getMetrics() {
            HashMap<String, Object> gauges = new HashMap<String, Object>();
            gauges.put(this.name("TotalConnections"), new Gauge<Integer>(){

                public Integer getValue() {
                    if (ds.getPool() != null) {
                        return ds.getPool().getStatistics().getTotalCreatedConnections();
                    }
                    return 0;
                }
            });
            gauges.put(this.name("IdleConnections"), new Gauge<Integer>(){

                public Integer getValue() {
                    if (ds.getPool() != null) {
                        return ds.getPool().getStatistics().getTotalFree();
                    }
                    return 0;
                }
            });
            gauges.put(this.name("ActiveConnections"), new Gauge<Integer>(){

                public Integer getValue() {
                    if (ds.getPool() != null) {
                        return ds.getPool().getStatistics().getTotalLeased();
                    }
                    return 0;
                }
            });
            gauges.put(this.name("WaitTimeAvg"), new Gauge<Double>(){

                public Double getValue() {
                    if (ds.getPool() != null) {
                        return ds.getPool().getStatistics().getConnectionWaitTimeAvg();
                    }
                    return 0.0;
                }
            });
            return Collections.unmodifiableMap(gauges);
        }
    }
}

