/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;

public class TimestampColumnStatsMerger
extends ColumnStatsMerger {
    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        TimestampColumnStatsDataInspector aggregateData = ColumnsStatsUtils.timestampInspectorFromStats(aggregateColStats);
        TimestampColumnStatsDataInspector newData = ColumnsStatsUtils.timestampInspectorFromStats(newColStats);
        this.setLowValue(aggregateData, newData);
        this.setHighValue(aggregateData, newData);
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        if (aggregateData.getNdvEstimator() == null || newData.getNdvEstimator() == null) {
            aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
        } else {
            NumDistinctValueEstimator oldEst = aggregateData.getNdvEstimator();
            NumDistinctValueEstimator newEst = newData.getNdvEstimator();
            long ndv = -1L;
            if (oldEst.canMerge(newEst)) {
                oldEst.mergeEstimators(newEst);
                ndv = oldEst.estimateNumDistinctValues();
                aggregateData.setNdvEstimator(oldEst);
            } else {
                ndv = Math.max(aggregateData.getNumDVs(), newData.getNumDVs());
            }
            this.LOG.debug("Use bitvector to merge column " + aggregateColStats.getColName() + "'s ndvs of " + aggregateData.getNumDVs() + " and " + newData.getNumDVs() + " to be " + ndv);
            aggregateData.setNumDVs(ndv);
        }
        aggregateColStats.getStatsData().setTimestampStats((TimestampColumnStatsData)aggregateData);
    }

    public void setLowValue(TimestampColumnStatsDataInspector aggregateData, TimestampColumnStatsDataInspector newData) {
        if (!aggregateData.isSetLowValue() && !newData.isSetLowValue()) {
            return;
        }
        Timestamp aggregateLowValue = aggregateData.getLowValue();
        Timestamp newLowValue = newData.getLowValue();
        Timestamp mergedLowValue = null;
        mergedLowValue = aggregateData.isSetLowValue() && newData.isSetLowValue() ? (aggregateLowValue.compareTo(newLowValue) > 0 ? newLowValue : aggregateLowValue) : (aggregateLowValue == null ? newLowValue : aggregateLowValue);
        aggregateData.setLowValue(mergedLowValue);
    }

    public void setHighValue(TimestampColumnStatsDataInspector aggregateData, TimestampColumnStatsDataInspector newData) {
        if (!aggregateData.isSetHighValue() && !newData.isSetHighValue()) {
            return;
        }
        Timestamp aggregateHighValue = aggregateData.getHighValue();
        Timestamp newHighValue = newData.getHighValue();
        Timestamp mergedHighValue = null;
        mergedHighValue = aggregateData.isSetHighValue() && newData.isSetHighValue() ? (aggregateHighValue.compareTo(newHighValue) > 0 ? aggregateHighValue : newHighValue) : (aggregateHighValue == null ? newHighValue : aggregateHighValue);
        aggregateData.setHighValue(mergedHighValue);
    }
}

