/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;

public class DoubleColumnStatsMerger
extends ColumnStatsMerger {
    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        DoubleColumnStatsDataInspector aggregateData = ColumnsStatsUtils.doubleInspectorFromStats(aggregateColStats);
        DoubleColumnStatsDataInspector newData = ColumnsStatsUtils.doubleInspectorFromStats(newColStats);
        this.setLowValue(aggregateData, newData);
        this.setHighValue(aggregateData, newData);
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        if (aggregateData.getNdvEstimator() == null || newData.getNdvEstimator() == null) {
            aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
        } else {
            NumDistinctValueEstimator oldEst = aggregateData.getNdvEstimator();
            NumDistinctValueEstimator newEst = newData.getNdvEstimator();
            long ndv = -1L;
            if (oldEst.canMerge(newEst)) {
                oldEst.mergeEstimators(newEst);
                ndv = oldEst.estimateNumDistinctValues();
                aggregateData.setNdvEstimator(oldEst);
            } else {
                ndv = Math.max(aggregateData.getNumDVs(), newData.getNumDVs());
            }
            this.LOG.debug("Use bitvector to merge column " + aggregateColStats.getColName() + "'s ndvs of " + aggregateData.getNumDVs() + " and " + newData.getNumDVs() + " to be " + ndv);
            aggregateData.setNumDVs(ndv);
        }
        aggregateColStats.getStatsData().setDoubleStats((DoubleColumnStatsData)aggregateData);
    }

    public void setLowValue(DoubleColumnStatsDataInspector aggregateData, DoubleColumnStatsDataInspector newData) {
        if (!aggregateData.isSetLowValue() && !newData.isSetLowValue()) {
            return;
        }
        double lowValue = Math.min(aggregateData.isSetLowValue() ? aggregateData.getLowValue() : Double.MAX_VALUE, newData.isSetLowValue() ? newData.getLowValue() : Double.MAX_VALUE);
        aggregateData.setLowValue(lowValue);
    }

    public void setHighValue(DoubleColumnStatsDataInspector aggregateData, DoubleColumnStatsDataInspector newData) {
        if (!aggregateData.isSetHighValue() && !newData.isSetHighValue()) {
            return;
        }
        double highValue = Math.max(aggregateData.isSetHighValue() ? aggregateData.getHighValue() : Double.MIN_VALUE, newData.isSetHighValue() ? newData.getHighValue() : Double.MIN_VALUE);
        aggregateData.setHighValue(highValue);
    }
}

