/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.cache;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;

public class DateColumnStatsDataInspector
extends DateColumnStatsData {
    private NumDistinctValueEstimator ndvEstimator;

    public DateColumnStatsDataInspector() {
    }

    public DateColumnStatsDataInspector(long numNulls, long numDVs) {
        super(numNulls, numDVs);
    }

    public DateColumnStatsDataInspector(DateColumnStatsDataInspector other) {
        super((DateColumnStatsData)other);
        if (other.ndvEstimator != null) {
            super.setBitVectors(this.ndvEstimator.serialize());
        }
    }

    public DateColumnStatsDataInspector(DateColumnStatsData other) {
        super(other);
    }

    public DateColumnStatsDataInspector deepCopy() {
        return new DateColumnStatsDataInspector(this);
    }

    public byte[] getBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.getBitVectors();
    }

    public ByteBuffer bufferForBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.bufferForBitVectors();
    }

    public void setBitVectors(byte[] bitVectors) {
        super.setBitVectors(bitVectors);
        this.ndvEstimator = null;
    }

    public void setBitVectors(ByteBuffer bitVectors) {
        super.setBitVectors(bitVectors);
        this.ndvEstimator = null;
    }

    public void unsetBitVectors() {
        super.unsetBitVectors();
        this.ndvEstimator = null;
    }

    public boolean isSetBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.isSetBitVectors();
    }

    public void setBitVectorsIsSet(boolean value) {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        super.setBitVectorsIsSet(value);
    }

    public NumDistinctValueEstimator getNdvEstimator() {
        if (this.isSetBitVectors() && this.getBitVectors().length != 0) {
            this.updateNdvEstimator();
        }
        return this.ndvEstimator;
    }

    public void setNdvEstimator(NumDistinctValueEstimator ndvEstimator) {
        super.unsetBitVectors();
        this.ndvEstimator = ndvEstimator;
    }

    private void updateBitVectors() {
        super.setBitVectors(this.ndvEstimator.serialize());
        this.ndvEstimator = null;
    }

    private void updateNdvEstimator() {
        this.ndvEstimator = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator(super.getBitVectors());
        super.unsetBitVectors();
    }
}

