/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.columnstats.aggr.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.TimestampColumnStatsMerger;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampColumnStatsAggregator
extends ColumnStatsAggregator
implements IExtrapolatePartStatus {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampColumnStatsAggregator.class);

    @Override
    public ColumnStatisticsObj aggregate(List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        ColumnStatisticsObj statsObj = null;
        String colType = null;
        String colName = null;
        boolean doAllPartitionContainStats = partNames.size() == colStatsWithSourceInfo.size();
        NumDistinctValueEstimator ndvEstimator = null;
        for (MetaStoreServerUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
            TimestampColumnStatsDataInspector timestampColumnStats;
            ColumnStatisticsObj cso = csp.getColStatsObj();
            if (statsObj == null) {
                colName = cso.getColName();
                colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
                LOG.trace("doAllPartitionContainStats for column: {} is: {}", (Object)colName, (Object)doAllPartitionContainStats);
            }
            if ((timestampColumnStats = ColumnsStatsUtils.timestampInspectorFromStats(cso)).getNdvEstimator() == null) {
                ndvEstimator = null;
                break;
            }
            NumDistinctValueEstimator estimator = timestampColumnStats.getNdvEstimator();
            if (ndvEstimator == null) {
                ndvEstimator = estimator;
                continue;
            }
            if (ndvEstimator.canMerge(estimator)) continue;
            ndvEstimator = null;
            break;
        }
        if (ndvEstimator != null) {
            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
        }
        LOG.debug("all of the bit vectors can merge for " + colName + " is " + (ndvEstimator != null));
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        if (doAllPartitionContainStats || colStatsWithSourceInfo.size() < 2) {
            TimestampColumnStatsDataInspector aggregateData = null;
            long lowerBound = 0L;
            long higherBound = 0L;
            double densityAvgSum = 0.0;
            for (MetaStoreServerUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                ColumnStatisticsObj cso = csp.getColStatsObj();
                TimestampColumnStatsDataInspector newData = ColumnsStatsUtils.timestampInspectorFromStats(cso);
                higherBound += newData.getNumDVs();
                if (newData.isSetLowValue() && newData.isSetHighValue()) {
                    densityAvgSum += (double)(this.diff(newData.getHighValue(), newData.getLowValue()) / newData.getNumDVs());
                }
                if (ndvEstimator != null) {
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (aggregateData == null) {
                    aggregateData = newData.deepCopy();
                    continue;
                }
                TimestampColumnStatsMerger merger = new TimestampColumnStatsMerger();
                merger.setLowValue(aggregateData, newData);
                merger.setHighValue(aggregateData, newData);
                aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
            }
            if (ndvEstimator != null) {
                aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
            } else {
                long estimation;
                if (this.useDensityFunctionForNDVEstimation) {
                    double densityAvg = densityAvgSum / (double)partNames.size();
                    estimation = (long)((double)this.diff(aggregateData.getHighValue(), aggregateData.getLowValue()) / densityAvg);
                    if (estimation < lowerBound) {
                        estimation = lowerBound;
                    } else if (estimation > higherBound) {
                        estimation = higherBound;
                    }
                } else {
                    estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * this.ndvTuner);
                }
                aggregateData.setNumDVs(estimation);
            }
            columnStatisticsData.setTimestampStats(aggregateData);
        } else {
            LOG.debug("start extrapolation for " + colName);
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap<String, Double> adjustedIndexMap = new HashMap<String, Double>();
            HashMap<String, ColumnStatisticsData> adjustedStatsMap = new HashMap<String, ColumnStatisticsData>();
            double densityAvgSum = 0.0;
            if (ndvEstimator == null) {
                for (MetaStoreServerUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    TimestampColumnStatsData newData = cso.getStatsData().getTimestampStats();
                    if (this.useDensityFunctionForNDVEstimation) {
                        densityAvgSum += (double)(this.diff(newData.getHighValue(), newData.getLowValue()) / newData.getNumDVs());
                    }
                    adjustedIndexMap.put(partName, (double)((Integer)indexMap.get(partName)));
                    adjustedStatsMap.put(partName, cso.getStatsData());
                }
            } else {
                StringBuilder pseudoPartName = new StringBuilder();
                double pseudoIndexSum = 0.0;
                int length = 0;
                int curIndex = -1;
                TimestampColumnStatsDataInspector aggregateData = null;
                for (MetaStoreServerUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    TimestampColumnStatsDataInspector newData = ColumnsStatsUtils.timestampInspectorFromStats(cso);
                    if ((Integer)indexMap.get(partName) != curIndex) {
                        if (length > 0) {
                            adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                            aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                            ColumnStatisticsData csd = new ColumnStatisticsData();
                            csd.setTimestampStats((TimestampColumnStatsData)aggregateData);
                            adjustedStatsMap.put(pseudoPartName.toString(), csd);
                            if (this.useDensityFunctionForNDVEstimation) {
                                densityAvgSum += (double)(this.diff(aggregateData.getHighValue(), aggregateData.getLowValue()) / aggregateData.getNumDVs());
                            }
                            pseudoPartName = new StringBuilder();
                            pseudoIndexSum = 0.0;
                            length = 0;
                            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
                        }
                        aggregateData = null;
                    }
                    curIndex = (Integer)indexMap.get(partName);
                    pseudoPartName.append(partName);
                    pseudoIndexSum += (double)curIndex;
                    ++length;
                    ++curIndex;
                    if (aggregateData == null) {
                        aggregateData = newData.deepCopy();
                    } else {
                        aggregateData.setLowValue(this.min(aggregateData.getLowValue(), newData.getLowValue()));
                        aggregateData.setHighValue(this.max(aggregateData.getHighValue(), newData.getHighValue()));
                        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                    }
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (length > 0) {
                    adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                    aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                    ColumnStatisticsData csd = new ColumnStatisticsData();
                    csd.setTimestampStats(aggregateData);
                    adjustedStatsMap.put(pseudoPartName.toString(), csd);
                    if (this.useDensityFunctionForNDVEstimation) {
                        densityAvgSum += (double)(this.diff(aggregateData.getHighValue(), aggregateData.getLowValue()) / aggregateData.getNumDVs());
                    }
                }
            }
            this.extrapolate(columnStatisticsData, partNames.size(), colStatsWithSourceInfo.size(), adjustedIndexMap, adjustedStatsMap, densityAvgSum / (double)adjustedStatsMap.size());
        }
        LOG.debug("Ndv estimatation for {} is {} # of partitions requested: {} # of partitions found: {}", new Object[]{colName, columnStatisticsData.getTimestampStats().getNumDVs(), partNames.size(), colStatsWithSourceInfo.size()});
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }

    private long diff(Timestamp d1, Timestamp d2) {
        return d1.getSecondsSinceEpoch() - d2.getSecondsSinceEpoch();
    }

    private Timestamp min(Timestamp d1, Timestamp d2) {
        return d1.compareTo(d2) < 0 ? d1 : d2;
    }

    private Timestamp max(Timestamp d1, Timestamp d2) {
        return d1.compareTo(d2) < 0 ? d2 : d1;
    }

    @Override
    public void extrapolate(ColumnStatisticsData extrapolateData, int numParts, int numPartsWithStats, Map<String, Double> adjustedIndexMap, Map<String, ColumnStatisticsData> adjustedStatsMap, double densityAvg) {
        int rightBorderInd = numParts;
        TimestampColumnStatsDataInspector extrapolateTimestampData = new TimestampColumnStatsDataInspector();
        HashMap<String, TimestampColumnStatsData> extractedAdjustedStatsMap = new HashMap<String, TimestampColumnStatsData>();
        for (Map.Entry<String, ColumnStatisticsData> entry : adjustedStatsMap.entrySet()) {
            extractedAdjustedStatsMap.put(entry.getKey(), entry.getValue().getTimestampStats());
        }
        LinkedList list = new LinkedList(extractedAdjustedStatsMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, TimestampColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, TimestampColumnStatsData> o1, Map.Entry<String, TimestampColumnStatsData> o2) {
                return o1.getValue().getLowValue().compareTo(o2.getValue().getLowValue());
            }
        });
        double minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        double maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        long lowValue = 0L;
        long min = ((TimestampColumnStatsData)((Map.Entry)list.get(0)).getValue()).getLowValue().getSecondsSinceEpoch();
        long max = ((TimestampColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getLowValue().getSecondsSinceEpoch();
        lowValue = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)max - (double)(max - min) * maxInd / (maxInd - minInd)) : (long)((double)max - (double)(max - min) * ((double)rightBorderInd - maxInd) / (minInd - maxInd)));
        Collections.sort(list, new Comparator<Map.Entry<String, TimestampColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, TimestampColumnStatsData> o1, Map.Entry<String, TimestampColumnStatsData> o2) {
                return o1.getValue().getHighValue().compareTo(o2.getValue().getHighValue());
            }
        });
        minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        long highValue = 0L;
        min = ((TimestampColumnStatsData)((Map.Entry)list.get(0)).getValue()).getHighValue().getSecondsSinceEpoch();
        max = ((TimestampColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getHighValue().getSecondsSinceEpoch();
        highValue = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)min + (double)(max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)((double)min + (double)(max - min) * minInd / (minInd - maxInd)));
        long numNulls = 0L;
        for (Map.Entry entry : extractedAdjustedStatsMap.entrySet()) {
            numNulls += ((TimestampColumnStatsData)entry.getValue()).getNumNulls();
        }
        numNulls = numNulls * (long)numParts / (long)numPartsWithStats;
        long ndv = 0L;
        Collections.sort(list, new Comparator<Map.Entry<String, TimestampColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, TimestampColumnStatsData> o1, Map.Entry<String, TimestampColumnStatsData> o2) {
                return Long.compare(o1.getValue().getNumDVs(), o2.getValue().getNumDVs());
            }
        });
        long lowerBound = ((TimestampColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
        long higherBound = 0L;
        for (Map.Entry entry : list) {
            higherBound += ((TimestampColumnStatsData)entry.getValue()).getNumDVs();
        }
        if (this.useDensityFunctionForNDVEstimation && densityAvg != 0.0) {
            ndv = (long)((double)(highValue - lowValue) / densityAvg);
            if (ndv < lowerBound) {
                ndv = lowerBound;
            } else if (ndv > higherBound) {
                ndv = higherBound;
            }
        } else {
            minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
            maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
            min = ((TimestampColumnStatsData)((Map.Entry)list.get(0)).getValue()).getNumDVs();
            max = ((TimestampColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
            ndv = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)min + (double)(max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)((double)min + (double)(max - min) * minInd / (minInd - maxInd)));
        }
        extrapolateTimestampData.setLowValue(new Timestamp(lowValue));
        extrapolateTimestampData.setHighValue(new Timestamp(highValue));
        extrapolateTimestampData.setNumNulls(numNulls);
        extrapolateTimestampData.setNumDVs(ndv);
        extrapolateData.setTimestampStats((TimestampColumnStatsData)extrapolateTimestampData);
    }
}

