/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.aggr.BinaryColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.BooleanColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.DateColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.DecimalColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.DoubleColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.LongColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.StringColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.TimestampColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;

public class ColumnStatsAggregatorFactory {
    private ColumnStatsAggregatorFactory() {
    }

    public static ColumnStatsAggregator getColumnStatsAggregator(ColumnStatisticsData._Fields type, boolean useDensityFunctionForNDVEstimation, double ndvTuner) {
        ColumnStatsAggregator agg;
        switch (type) {
            case BOOLEAN_STATS: {
                agg = new BooleanColumnStatsAggregator();
                break;
            }
            case LONG_STATS: {
                agg = new LongColumnStatsAggregator();
                break;
            }
            case DATE_STATS: {
                agg = new DateColumnStatsAggregator();
                break;
            }
            case TIMESTAMP_STATS: {
                agg = new TimestampColumnStatsAggregator();
                break;
            }
            case DOUBLE_STATS: {
                agg = new DoubleColumnStatsAggregator();
                break;
            }
            case STRING_STATS: {
                agg = new StringColumnStatsAggregator();
                break;
            }
            case BINARY_STATS: {
                agg = new BinaryColumnStatsAggregator();
                break;
            }
            case DECIMAL_STATS: {
                agg = new DecimalColumnStatsAggregator();
                break;
            }
            default: {
                throw new RuntimeException("Woh, bad.  Unknown stats type " + type.toString());
            }
        }
        agg.useDensityFunctionForNDVEstimation = useDensityFunctionForNDVEstimation;
        agg.ndvTuner = ndvTuner;
        return agg;
    }

    public static ColumnStatisticsObj newColumnStaticsObj(String colName, String colType, ColumnStatisticsData._Fields type) {
        ColumnStatisticsObj cso = new ColumnStatisticsObj();
        ColumnStatisticsData csd = new ColumnStatisticsData();
        cso.setColName(colName);
        cso.setColType(colType);
        switch (type) {
            case BOOLEAN_STATS: {
                csd.setBooleanStats(new BooleanColumnStatsData());
                break;
            }
            case LONG_STATS: {
                csd.setLongStats((LongColumnStatsData)new LongColumnStatsDataInspector());
                break;
            }
            case DATE_STATS: {
                csd.setDateStats((DateColumnStatsData)new DateColumnStatsDataInspector());
                break;
            }
            case TIMESTAMP_STATS: {
                csd.setTimestampStats((TimestampColumnStatsData)new TimestampColumnStatsDataInspector());
                break;
            }
            case DOUBLE_STATS: {
                csd.setDoubleStats((DoubleColumnStatsData)new DoubleColumnStatsDataInspector());
                break;
            }
            case STRING_STATS: {
                csd.setStringStats((StringColumnStatsData)new StringColumnStatsDataInspector());
                break;
            }
            case BINARY_STATS: {
                csd.setBinaryStats(new BinaryColumnStatsData());
                break;
            }
            case DECIMAL_STATS: {
                csd.setDecimalStats((DecimalColumnStatsData)new DecimalColumnStatsDataInspector());
                break;
            }
            default: {
                throw new RuntimeException("Woh, bad.  Unknown stats type!");
            }
        }
        cso.setStatsData(csd);
        return cso;
    }
}

