/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.metastore.MetastoreDirectSqlUtils;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.api.utils.DecimalUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.model.MPartition;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.model.MTableColumnStatistics;

public class StatObjectConverter {
    public static MTableColumnStatistics convertToMTableColumnStatistics(MTable table, ColumnStatisticsDesc statsDesc, ColumnStatisticsObj statsObj, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException {
        if (statsObj == null || statsDesc == null) {
            throw new InvalidObjectException("Invalid column stats object");
        }
        MTableColumnStatistics mColStats = new MTableColumnStatistics();
        mColStats.setTable(table);
        mColStats.setDbName(statsDesc.getDbName());
        mColStats.setCatName(statsDesc.isSetCatName() ? statsDesc.getCatName() : "hive");
        mColStats.setTableName(statsDesc.getTableName());
        mColStats.setLastAnalyzed(statsDesc.getLastAnalyzed());
        mColStats.setColName(statsObj.getColName());
        mColStats.setColType(statsObj.getColType());
        if (statsObj.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData boolStats = statsObj.getStatsData().getBooleanStats();
            mColStats.setBooleanStats(boolStats.isSetNumTrues() ? Long.valueOf(boolStats.getNumTrues()) : null, boolStats.isSetNumFalses() ? Long.valueOf(boolStats.getNumFalses()) : null, boolStats.isSetNumNulls() ? Long.valueOf(boolStats.getNumNulls()) : null);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStats = statsObj.getStatsData().getLongStats();
            mColStats.setLongStats(longStats.isSetNumNulls() ? Long.valueOf(longStats.getNumNulls()) : null, longStats.isSetNumDVs() ? Long.valueOf(longStats.getNumDVs()) : null, longStats.isSetBitVectors() ? longStats.getBitVectors() : null, longStats.isSetLowValue() ? Long.valueOf(longStats.getLowValue()) : null, longStats.isSetHighValue() ? Long.valueOf(longStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStats = statsObj.getStatsData().getDoubleStats();
            mColStats.setDoubleStats(doubleStats.isSetNumNulls() ? Long.valueOf(doubleStats.getNumNulls()) : null, doubleStats.isSetNumDVs() ? Long.valueOf(doubleStats.getNumDVs()) : null, doubleStats.isSetBitVectors() ? doubleStats.getBitVectors() : null, doubleStats.isSetLowValue() ? Double.valueOf(doubleStats.getLowValue()) : null, doubleStats.isSetHighValue() ? Double.valueOf(doubleStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStats = statsObj.getStatsData().getDecimalStats();
            String low = decimalStats.isSetLowValue() ? DecimalUtils.createJdoDecimalString(decimalStats.getLowValue()) : null;
            String high = decimalStats.isSetHighValue() ? DecimalUtils.createJdoDecimalString(decimalStats.getHighValue()) : null;
            mColStats.setDecimalStats(decimalStats.isSetNumNulls() ? Long.valueOf(decimalStats.getNumNulls()) : null, decimalStats.isSetNumDVs() ? Long.valueOf(decimalStats.getNumDVs()) : null, decimalStats.isSetBitVectors() ? decimalStats.getBitVectors() : null, low, high);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStats = statsObj.getStatsData().getStringStats();
            mColStats.setStringStats(stringStats.isSetNumNulls() ? Long.valueOf(stringStats.getNumNulls()) : null, stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumDVs()) : null, stringStats.isSetBitVectors() ? stringStats.getBitVectors() : null, stringStats.isSetMaxColLen() ? Long.valueOf(stringStats.getMaxColLen()) : null, stringStats.isSetAvgColLen() ? Double.valueOf(stringStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStats = statsObj.getStatsData().getBinaryStats();
            mColStats.setBinaryStats(binaryStats.isSetNumNulls() ? Long.valueOf(binaryStats.getNumNulls()) : null, binaryStats.isSetMaxColLen() ? Long.valueOf(binaryStats.getMaxColLen()) : null, binaryStats.isSetAvgColLen() ? Double.valueOf(binaryStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetDateStats()) {
            DateColumnStatsData dateStats = statsObj.getStatsData().getDateStats();
            mColStats.setDateStats(dateStats.isSetNumNulls() ? Long.valueOf(dateStats.getNumNulls()) : null, dateStats.isSetNumDVs() ? Long.valueOf(dateStats.getNumDVs()) : null, dateStats.isSetBitVectors() ? dateStats.getBitVectors() : null, dateStats.isSetLowValue() ? Long.valueOf(dateStats.getLowValue().getDaysSinceEpoch()) : null, dateStats.isSetHighValue() ? Long.valueOf(dateStats.getHighValue().getDaysSinceEpoch()) : null);
        } else if (statsObj.getStatsData().isSetTimestampStats()) {
            TimestampColumnStatsData timestampStats = statsObj.getStatsData().getTimestampStats();
            mColStats.setTimestampStats(timestampStats.isSetNumNulls() ? Long.valueOf(timestampStats.getNumNulls()) : null, timestampStats.isSetNumDVs() ? Long.valueOf(timestampStats.getNumDVs()) : null, timestampStats.isSetBitVectors() ? timestampStats.getBitVectors() : null, timestampStats.isSetLowValue() ? Long.valueOf(timestampStats.getLowValue().getSecondsSinceEpoch()) : null, timestampStats.isSetHighValue() ? Long.valueOf(timestampStats.getHighValue().getSecondsSinceEpoch()) : null);
        }
        mColStats.setEngine(engine);
        return mColStats;
    }

    public static void setFieldsIntoOldStats(MTableColumnStatistics mStatsObj, MTableColumnStatistics oldStatsObj) {
        if (mStatsObj.getAvgColLen() != null) {
            oldStatsObj.setAvgColLen(mStatsObj.getAvgColLen());
        }
        if (mStatsObj.getLongHighValue() != null) {
            oldStatsObj.setLongHighValue(mStatsObj.getLongHighValue());
        }
        if (mStatsObj.getLongLowValue() != null) {
            oldStatsObj.setLongLowValue(mStatsObj.getLongLowValue());
        }
        if (mStatsObj.getDoubleLowValue() != null) {
            oldStatsObj.setDoubleLowValue(mStatsObj.getDoubleLowValue());
        }
        if (mStatsObj.getDoubleHighValue() != null) {
            oldStatsObj.setDoubleHighValue(mStatsObj.getDoubleHighValue());
        }
        if (mStatsObj.getDecimalLowValue() != null) {
            oldStatsObj.setDecimalLowValue(mStatsObj.getDecimalLowValue());
        }
        if (mStatsObj.getDecimalHighValue() != null) {
            oldStatsObj.setDecimalHighValue(mStatsObj.getDecimalHighValue());
        }
        if (mStatsObj.getMaxColLen() != null) {
            oldStatsObj.setMaxColLen(mStatsObj.getMaxColLen());
        }
        if (mStatsObj.getNumDVs() != null) {
            oldStatsObj.setNumDVs(mStatsObj.getNumDVs());
        }
        if (mStatsObj.getBitVector() != null) {
            oldStatsObj.setBitVector(mStatsObj.getBitVector());
        }
        if (mStatsObj.getNumFalses() != null) {
            oldStatsObj.setNumFalses(mStatsObj.getNumFalses());
        }
        if (mStatsObj.getNumTrues() != null) {
            oldStatsObj.setNumTrues(mStatsObj.getNumTrues());
        }
        if (mStatsObj.getNumNulls() != null) {
            oldStatsObj.setNumNulls(mStatsObj.getNumNulls());
        }
        oldStatsObj.setEngine(mStatsObj.getEngine());
        oldStatsObj.setLastAnalyzed(mStatsObj.getLastAnalyzed());
    }

    public static void setFieldsIntoOldStats(MPartitionColumnStatistics mStatsObj, MPartitionColumnStatistics oldStatsObj) {
        if (mStatsObj.getAvgColLen() != null) {
            oldStatsObj.setAvgColLen(mStatsObj.getAvgColLen());
        }
        if (mStatsObj.getLongHighValue() != null) {
            oldStatsObj.setLongHighValue(mStatsObj.getLongHighValue());
        }
        if (mStatsObj.getDoubleHighValue() != null) {
            oldStatsObj.setDoubleHighValue(mStatsObj.getDoubleHighValue());
        }
        oldStatsObj.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        if (mStatsObj.getLongLowValue() != null) {
            oldStatsObj.setLongLowValue(mStatsObj.getLongLowValue());
        }
        if (mStatsObj.getDoubleLowValue() != null) {
            oldStatsObj.setDoubleLowValue(mStatsObj.getDoubleLowValue());
        }
        if (mStatsObj.getDecimalLowValue() != null) {
            oldStatsObj.setDecimalLowValue(mStatsObj.getDecimalLowValue());
        }
        if (mStatsObj.getDecimalHighValue() != null) {
            oldStatsObj.setDecimalHighValue(mStatsObj.getDecimalHighValue());
        }
        if (mStatsObj.getMaxColLen() != null) {
            oldStatsObj.setMaxColLen(mStatsObj.getMaxColLen());
        }
        if (mStatsObj.getNumDVs() != null) {
            oldStatsObj.setNumDVs(mStatsObj.getNumDVs());
        }
        if (mStatsObj.getBitVector() != null) {
            oldStatsObj.setBitVector(mStatsObj.getBitVector());
        }
        if (mStatsObj.getNumFalses() != null) {
            oldStatsObj.setNumFalses(mStatsObj.getNumFalses());
        }
        if (mStatsObj.getNumTrues() != null) {
            oldStatsObj.setNumTrues(mStatsObj.getNumTrues());
        }
        if (mStatsObj.getNumNulls() != null) {
            oldStatsObj.setNumNulls(mStatsObj.getNumNulls());
        }
        oldStatsObj.setEngine(mStatsObj.getEngine());
    }

    public static ColumnStatisticsObj getTableColumnStatisticsObj(MTableColumnStatistics mStatsObj, boolean enableBitVector) {
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColType(mStatsObj.getColType());
        statsObj.setColName(mStatsObj.getColName());
        String colType = mStatsObj.getColType().toLowerCase();
        ColumnStatisticsData colStatsData = new ColumnStatisticsData();
        if (colType.equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(mStatsObj.getNumFalses().longValue());
            boolStats.setNumTrues(mStatsObj.getNumTrues().longValue());
            boolStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            colStatsData.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            StringColumnStatsDataInspector stringStats = new StringColumnStatsDataInspector();
            stringStats.setNumNulls(mStatsObj.getNumNulls());
            stringStats.setAvgColLen(mStatsObj.getAvgColLen());
            stringStats.setMaxColLen(mStatsObj.getMaxColLen());
            stringStats.setNumDVs(mStatsObj.getNumDVs());
            stringStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setStringStats((StringColumnStatsData)stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            binaryStats.setAvgColLen(mStatsObj.getAvgColLen().doubleValue());
            binaryStats.setMaxColLen(mStatsObj.getMaxColLen().longValue());
            colStatsData.setBinaryStats(binaryStats);
        } else if (colType.equals("bigint") || colType.equals("int") || colType.equals("smallint") || colType.equals("tinyint")) {
            Long longLowValue;
            LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
            longStats.setNumNulls(mStatsObj.getNumNulls());
            Long longHighValue = mStatsObj.getLongHighValue();
            if (longHighValue != null) {
                longStats.setHighValue(longHighValue);
            }
            if ((longLowValue = mStatsObj.getLongLowValue()) != null) {
                longStats.setLowValue(longLowValue);
            }
            longStats.setNumDVs(mStatsObj.getNumDVs());
            longStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setLongStats((LongColumnStatsData)longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            Double doubleLowValue;
            DoubleColumnStatsDataInspector doubleStats = new DoubleColumnStatsDataInspector();
            doubleStats.setNumNulls(mStatsObj.getNumNulls());
            Double doubleHighValue = mStatsObj.getDoubleHighValue();
            if (doubleHighValue != null) {
                doubleStats.setHighValue(doubleHighValue);
            }
            if ((doubleLowValue = mStatsObj.getDoubleLowValue()) != null) {
                doubleStats.setLowValue(doubleLowValue);
            }
            doubleStats.setNumDVs(mStatsObj.getNumDVs());
            doubleStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDoubleStats((DoubleColumnStatsData)doubleStats);
        } else if (colType.startsWith("decimal")) {
            String decimalLowValue;
            DecimalColumnStatsDataInspector decimalStats = new DecimalColumnStatsDataInspector();
            decimalStats.setNumNulls(mStatsObj.getNumNulls());
            String decimalHighValue = mStatsObj.getDecimalHighValue();
            if (decimalHighValue != null) {
                decimalStats.setHighValue(DecimalUtils.createThriftDecimal(decimalHighValue));
            }
            if ((decimalLowValue = mStatsObj.getDecimalLowValue()) != null) {
                decimalStats.setLowValue(DecimalUtils.createThriftDecimal(decimalLowValue));
            }
            decimalStats.setNumDVs(mStatsObj.getNumDVs());
            decimalStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDecimalStats((DecimalColumnStatsData)decimalStats);
        } else if (colType.equals("date")) {
            Long lowValue;
            DateColumnStatsDataInspector dateStats = new DateColumnStatsDataInspector();
            dateStats.setNumNulls(mStatsObj.getNumNulls());
            Long highValue = mStatsObj.getLongHighValue();
            if (highValue != null) {
                dateStats.setHighValue(new Date(highValue.longValue()));
            }
            if ((lowValue = mStatsObj.getLongLowValue()) != null) {
                dateStats.setLowValue(new Date(lowValue.longValue()));
            }
            dateStats.setNumDVs(mStatsObj.getNumDVs());
            dateStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDateStats((DateColumnStatsData)dateStats);
        } else if (colType.equals("timestamp")) {
            Long lowValue;
            TimestampColumnStatsDataInspector timestampStats = new TimestampColumnStatsDataInspector();
            timestampStats.setNumNulls(mStatsObj.getNumNulls());
            Long highValue = mStatsObj.getLongHighValue();
            if (highValue != null) {
                timestampStats.setHighValue(new Timestamp(highValue.longValue()));
            }
            if ((lowValue = mStatsObj.getLongLowValue()) != null) {
                timestampStats.setLowValue(new Timestamp(lowValue.longValue()));
            }
            timestampStats.setNumDVs(mStatsObj.getNumDVs());
            timestampStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setTimestampStats((TimestampColumnStatsData)timestampStats);
        }
        statsObj.setStatsData(colStatsData);
        return statsObj;
    }

    public static ColumnStatisticsDesc getTableColumnStatisticsDesc(MTableColumnStatistics mStatsObj) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setIsTblLevel(true);
        statsDesc.setCatName(mStatsObj.getCatName());
        statsDesc.setDbName(mStatsObj.getDbName());
        statsDesc.setTableName(mStatsObj.getTableName());
        statsDesc.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        return statsDesc;
    }

    public static MPartitionColumnStatistics convertToMPartitionColumnStatistics(MPartition partition, ColumnStatisticsDesc statsDesc, ColumnStatisticsObj statsObj, String engine) throws MetaException, NoSuchObjectException {
        if (statsDesc == null || statsObj == null) {
            return null;
        }
        MPartitionColumnStatistics mColStats = new MPartitionColumnStatistics();
        mColStats.setPartition(partition);
        mColStats.setCatName(statsDesc.isSetCatName() ? statsDesc.getCatName() : "hive");
        mColStats.setDbName(statsDesc.getDbName());
        mColStats.setTableName(statsDesc.getTableName());
        mColStats.setPartitionName(statsDesc.getPartName());
        mColStats.setLastAnalyzed(statsDesc.getLastAnalyzed());
        mColStats.setColName(statsObj.getColName());
        mColStats.setColType(statsObj.getColType());
        if (statsObj.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData boolStats = statsObj.getStatsData().getBooleanStats();
            mColStats.setBooleanStats(boolStats.isSetNumTrues() ? Long.valueOf(boolStats.getNumTrues()) : null, boolStats.isSetNumFalses() ? Long.valueOf(boolStats.getNumFalses()) : null, boolStats.isSetNumNulls() ? Long.valueOf(boolStats.getNumNulls()) : null);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStats = statsObj.getStatsData().getLongStats();
            mColStats.setLongStats(longStats.isSetNumNulls() ? Long.valueOf(longStats.getNumNulls()) : null, longStats.isSetNumDVs() ? Long.valueOf(longStats.getNumDVs()) : null, longStats.isSetBitVectors() ? longStats.getBitVectors() : null, longStats.isSetLowValue() ? Long.valueOf(longStats.getLowValue()) : null, longStats.isSetHighValue() ? Long.valueOf(longStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStats = statsObj.getStatsData().getDoubleStats();
            mColStats.setDoubleStats(doubleStats.isSetNumNulls() ? Long.valueOf(doubleStats.getNumNulls()) : null, doubleStats.isSetNumDVs() ? Long.valueOf(doubleStats.getNumDVs()) : null, doubleStats.isSetBitVectors() ? doubleStats.getBitVectors() : null, doubleStats.isSetLowValue() ? Double.valueOf(doubleStats.getLowValue()) : null, doubleStats.isSetHighValue() ? Double.valueOf(doubleStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStats = statsObj.getStatsData().getDecimalStats();
            String low = decimalStats.isSetLowValue() ? DecimalUtils.createJdoDecimalString(decimalStats.getLowValue()) : null;
            String high = decimalStats.isSetHighValue() ? DecimalUtils.createJdoDecimalString(decimalStats.getHighValue()) : null;
            mColStats.setDecimalStats(decimalStats.isSetNumNulls() ? Long.valueOf(decimalStats.getNumNulls()) : null, decimalStats.isSetNumDVs() ? Long.valueOf(decimalStats.getNumDVs()) : null, decimalStats.isSetBitVectors() ? decimalStats.getBitVectors() : null, low, high);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStats = statsObj.getStatsData().getStringStats();
            mColStats.setStringStats(stringStats.isSetNumNulls() ? Long.valueOf(stringStats.getNumNulls()) : null, stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumDVs()) : null, stringStats.isSetBitVectors() ? stringStats.getBitVectors() : null, stringStats.isSetMaxColLen() ? Long.valueOf(stringStats.getMaxColLen()) : null, stringStats.isSetAvgColLen() ? Double.valueOf(stringStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStats = statsObj.getStatsData().getBinaryStats();
            mColStats.setBinaryStats(binaryStats.isSetNumNulls() ? Long.valueOf(binaryStats.getNumNulls()) : null, binaryStats.isSetMaxColLen() ? Long.valueOf(binaryStats.getMaxColLen()) : null, binaryStats.isSetAvgColLen() ? Double.valueOf(binaryStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetDateStats()) {
            DateColumnStatsData dateStats = statsObj.getStatsData().getDateStats();
            mColStats.setDateStats(dateStats.isSetNumNulls() ? Long.valueOf(dateStats.getNumNulls()) : null, dateStats.isSetNumDVs() ? Long.valueOf(dateStats.getNumDVs()) : null, dateStats.isSetBitVectors() ? dateStats.getBitVectors() : null, dateStats.isSetLowValue() ? Long.valueOf(dateStats.getLowValue().getDaysSinceEpoch()) : null, dateStats.isSetHighValue() ? Long.valueOf(dateStats.getHighValue().getDaysSinceEpoch()) : null);
        } else if (statsObj.getStatsData().isSetTimestampStats()) {
            TimestampColumnStatsData timestampStats = statsObj.getStatsData().getTimestampStats();
            mColStats.setTimestampStats(timestampStats.isSetNumNulls() ? Long.valueOf(timestampStats.getNumNulls()) : null, timestampStats.isSetNumDVs() ? Long.valueOf(timestampStats.getNumDVs()) : null, timestampStats.isSetBitVectors() ? timestampStats.getBitVectors() : null, timestampStats.isSetLowValue() ? Long.valueOf(timestampStats.getLowValue().getSecondsSinceEpoch()) : null, timestampStats.isSetHighValue() ? Long.valueOf(timestampStats.getHighValue().getSecondsSinceEpoch()) : null);
        }
        mColStats.setEngine(engine);
        return mColStats;
    }

    public static ColumnStatisticsObj getPartitionColumnStatisticsObj(MPartitionColumnStatistics mStatsObj, boolean enableBitVector) {
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColType(mStatsObj.getColType());
        statsObj.setColName(mStatsObj.getColName());
        String colType = mStatsObj.getColType().toLowerCase();
        ColumnStatisticsData colStatsData = new ColumnStatisticsData();
        if (colType.equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(mStatsObj.getNumFalses().longValue());
            boolStats.setNumTrues(mStatsObj.getNumTrues().longValue());
            boolStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            colStatsData.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            StringColumnStatsDataInspector stringStats = new StringColumnStatsDataInspector();
            stringStats.setNumNulls(mStatsObj.getNumNulls());
            stringStats.setAvgColLen(mStatsObj.getAvgColLen());
            stringStats.setMaxColLen(mStatsObj.getMaxColLen());
            stringStats.setNumDVs(mStatsObj.getNumDVs());
            stringStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setStringStats((StringColumnStatsData)stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            binaryStats.setAvgColLen(mStatsObj.getAvgColLen().doubleValue());
            binaryStats.setMaxColLen(mStatsObj.getMaxColLen().longValue());
            colStatsData.setBinaryStats(binaryStats);
        } else if (colType.equals("tinyint") || colType.equals("smallint") || colType.equals("int") || colType.equals("bigint")) {
            LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
            longStats.setNumNulls(mStatsObj.getNumNulls());
            if (mStatsObj.getLongHighValue() != null) {
                longStats.setHighValue(mStatsObj.getLongHighValue());
            }
            if (mStatsObj.getLongLowValue() != null) {
                longStats.setLowValue(mStatsObj.getLongLowValue());
            }
            longStats.setNumDVs(mStatsObj.getNumDVs());
            longStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setLongStats((LongColumnStatsData)longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            DoubleColumnStatsDataInspector doubleStats = new DoubleColumnStatsDataInspector();
            doubleStats.setNumNulls(mStatsObj.getNumNulls());
            if (mStatsObj.getDoubleHighValue() != null) {
                doubleStats.setHighValue(mStatsObj.getDoubleHighValue());
            }
            if (mStatsObj.getDoubleLowValue() != null) {
                doubleStats.setLowValue(mStatsObj.getDoubleLowValue());
            }
            doubleStats.setNumDVs(mStatsObj.getNumDVs());
            doubleStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDoubleStats((DoubleColumnStatsData)doubleStats);
        } else if (colType.startsWith("decimal")) {
            DecimalColumnStatsDataInspector decimalStats = new DecimalColumnStatsDataInspector();
            decimalStats.setNumNulls(mStatsObj.getNumNulls());
            if (mStatsObj.getDecimalHighValue() != null) {
                decimalStats.setHighValue(DecimalUtils.createThriftDecimal(mStatsObj.getDecimalHighValue()));
            }
            if (mStatsObj.getDecimalLowValue() != null) {
                decimalStats.setLowValue(DecimalUtils.createThriftDecimal(mStatsObj.getDecimalLowValue()));
            }
            decimalStats.setNumDVs(mStatsObj.getNumDVs());
            decimalStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDecimalStats((DecimalColumnStatsData)decimalStats);
        } else if (colType.equals("date")) {
            Long lowValue;
            DateColumnStatsDataInspector dateStats = new DateColumnStatsDataInspector();
            dateStats.setNumNulls(mStatsObj.getNumNulls());
            Long highValue = mStatsObj.getLongHighValue();
            if (highValue != null) {
                dateStats.setHighValue(new Date(highValue.longValue()));
            }
            if ((lowValue = mStatsObj.getLongLowValue()) != null) {
                dateStats.setLowValue(new Date(lowValue.longValue()));
            }
            dateStats.setNumDVs(mStatsObj.getNumDVs());
            dateStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDateStats((DateColumnStatsData)dateStats);
        } else if (colType.equals("timestamp")) {
            Long lowValue;
            TimestampColumnStatsDataInspector timestampStats = new TimestampColumnStatsDataInspector();
            timestampStats.setNumNulls(mStatsObj.getNumNulls());
            Long highValue = mStatsObj.getLongHighValue();
            if (highValue != null) {
                timestampStats.setHighValue(new Timestamp(highValue.longValue()));
            }
            if ((lowValue = mStatsObj.getLongLowValue()) != null) {
                timestampStats.setLowValue(new Timestamp(lowValue.longValue()));
            }
            timestampStats.setNumDVs(mStatsObj.getNumDVs());
            timestampStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setTimestampStats((TimestampColumnStatsData)timestampStats);
        }
        statsObj.setStatsData(colStatsData);
        return statsObj;
    }

    public static ColumnStatisticsDesc getPartitionColumnStatisticsDesc(MPartitionColumnStatistics mStatsObj) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setIsTblLevel(false);
        statsDesc.setCatName(mStatsObj.getCatName());
        statsDesc.setDbName(mStatsObj.getDbName());
        statsDesc.setTableName(mStatsObj.getTableName());
        statsDesc.setPartName(mStatsObj.getPartitionName());
        statsDesc.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        return statsDesc;
    }

    public static void fillColumnStatisticsData(String colType, ColumnStatisticsData data, Object llow, Object lhigh, Object dlow, Object dhigh, Object declow, Object dechigh, Object nulls, Object dist, Object bitVector, Object avglen, Object maxlen, Object trues, Object falses) throws MetaException {
        if ((colType = colType.toLowerCase()).equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(MetastoreDirectSqlUtils.extractSqlLong(falses).longValue());
            boolStats.setNumTrues(MetastoreDirectSqlUtils.extractSqlLong(trues).longValue());
            boolStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls).longValue());
            data.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            StringColumnStatsDataInspector stringStats = new StringColumnStatsDataInspector();
            stringStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            stringStats.setAvgColLen(MetastoreDirectSqlUtils.extractSqlDouble(avglen));
            stringStats.setMaxColLen(MetastoreDirectSqlUtils.extractSqlLong(maxlen));
            stringStats.setNumDVs(MetastoreDirectSqlUtils.extractSqlLong(dist));
            stringStats.setBitVectors(MetastoreDirectSqlUtils.extractSqlBlob(bitVector));
            data.setStringStats((StringColumnStatsData)stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls).longValue());
            binaryStats.setAvgColLen(MetastoreDirectSqlUtils.extractSqlDouble(avglen).doubleValue());
            binaryStats.setMaxColLen(MetastoreDirectSqlUtils.extractSqlLong(maxlen).longValue());
            data.setBinaryStats(binaryStats);
        } else if (colType.equals("bigint") || colType.equals("int") || colType.equals("smallint") || colType.equals("tinyint")) {
            LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
            longStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (lhigh != null) {
                longStats.setHighValue(MetastoreDirectSqlUtils.extractSqlLong(lhigh));
            }
            if (llow != null) {
                longStats.setLowValue(MetastoreDirectSqlUtils.extractSqlLong(llow));
            }
            longStats.setNumDVs(MetastoreDirectSqlUtils.extractSqlLong(dist));
            longStats.setBitVectors(MetastoreDirectSqlUtils.extractSqlBlob(bitVector));
            data.setLongStats((LongColumnStatsData)longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            DoubleColumnStatsDataInspector doubleStats = new DoubleColumnStatsDataInspector();
            doubleStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (dhigh != null) {
                doubleStats.setHighValue(MetastoreDirectSqlUtils.extractSqlDouble(dhigh));
            }
            if (dlow != null) {
                doubleStats.setLowValue(MetastoreDirectSqlUtils.extractSqlDouble(dlow));
            }
            doubleStats.setNumDVs(MetastoreDirectSqlUtils.extractSqlLong(dist));
            doubleStats.setBitVectors(MetastoreDirectSqlUtils.extractSqlBlob(bitVector));
            data.setDoubleStats((DoubleColumnStatsData)doubleStats);
        } else if (colType.startsWith("decimal")) {
            DecimalColumnStatsDataInspector decimalStats = new DecimalColumnStatsDataInspector();
            decimalStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (dechigh != null) {
                decimalStats.setHighValue(DecimalUtils.createThriftDecimal((String)dechigh));
            }
            if (declow != null) {
                decimalStats.setLowValue(DecimalUtils.createThriftDecimal((String)declow));
            }
            decimalStats.setNumDVs(MetastoreDirectSqlUtils.extractSqlLong(dist));
            decimalStats.setBitVectors(MetastoreDirectSqlUtils.extractSqlBlob(bitVector));
            data.setDecimalStats((DecimalColumnStatsData)decimalStats);
        } else if (colType.equals("date")) {
            DateColumnStatsDataInspector dateStats = new DateColumnStatsDataInspector();
            dateStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (lhigh != null) {
                dateStats.setHighValue(new Date(MetastoreDirectSqlUtils.extractSqlLong(lhigh).longValue()));
            }
            if (llow != null) {
                dateStats.setLowValue(new Date(MetastoreDirectSqlUtils.extractSqlLong(llow).longValue()));
            }
            dateStats.setNumDVs(MetastoreDirectSqlUtils.extractSqlLong(dist));
            dateStats.setBitVectors(MetastoreDirectSqlUtils.extractSqlBlob(bitVector));
            data.setDateStats((DateColumnStatsData)dateStats);
        } else if (colType.equals("timestamp")) {
            TimestampColumnStatsDataInspector timestampStats = new TimestampColumnStatsDataInspector();
            timestampStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (lhigh != null) {
                timestampStats.setHighValue(new Timestamp(MetastoreDirectSqlUtils.extractSqlLong(lhigh).longValue()));
            }
            if (llow != null) {
                timestampStats.setLowValue(new Timestamp(MetastoreDirectSqlUtils.extractSqlLong(llow).longValue()));
            }
            timestampStats.setNumDVs(MetastoreDirectSqlUtils.extractSqlLong(dist));
            timestampStats.setBitVectors(MetastoreDirectSqlUtils.extractSqlBlob(bitVector));
            data.setTimestampStats((TimestampColumnStatsData)timestampStats);
        }
    }

    public static void fillColumnStatisticsData(String colType, ColumnStatisticsData data, Object llow, Object lhigh, Object dlow, Object dhigh, Object declow, Object dechigh, Object nulls, Object dist, Object avglen, Object maxlen, Object trues, Object falses, Object avgLong, Object avgDouble, Object avgDecimal, Object sumDist, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        if ((colType = colType.toLowerCase()).equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(MetastoreDirectSqlUtils.extractSqlLong(falses).longValue());
            boolStats.setNumTrues(MetastoreDirectSqlUtils.extractSqlLong(trues).longValue());
            boolStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls).longValue());
            data.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            StringColumnStatsDataInspector stringStats = new StringColumnStatsDataInspector();
            stringStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            stringStats.setAvgColLen(MetastoreDirectSqlUtils.extractSqlDouble(avglen));
            stringStats.setMaxColLen(MetastoreDirectSqlUtils.extractSqlLong(maxlen));
            stringStats.setNumDVs(MetastoreDirectSqlUtils.extractSqlLong(dist));
            data.setStringStats((StringColumnStatsData)stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls).longValue());
            binaryStats.setAvgColLen(MetastoreDirectSqlUtils.extractSqlDouble(avglen).doubleValue());
            binaryStats.setMaxColLen(MetastoreDirectSqlUtils.extractSqlLong(maxlen).longValue());
            data.setBinaryStats(binaryStats);
        } else if (colType.equals("bigint") || colType.equals("int") || colType.equals("smallint") || colType.equals("tinyint")) {
            long estimation;
            LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
            longStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (lhigh != null) {
                longStats.setHighValue(MetastoreDirectSqlUtils.extractSqlLong(lhigh));
            }
            if (llow != null) {
                longStats.setLowValue(MetastoreDirectSqlUtils.extractSqlLong(llow));
            }
            long lowerBound = MetastoreDirectSqlUtils.extractSqlLong(dist);
            long higherBound = MetastoreDirectSqlUtils.extractSqlLong(sumDist);
            long rangeBound = Long.MAX_VALUE;
            if (lhigh != null && llow != null) {
                rangeBound = MetastoreDirectSqlUtils.extractSqlLong(lhigh) - MetastoreDirectSqlUtils.extractSqlLong(llow) + 1L;
            }
            if (useDensityFunctionForNDVEstimation && lhigh != null && llow != null && avgLong != null && MetastoreDirectSqlUtils.extractSqlDouble(avgLong) != 0.0) {
                estimation = MetastoreDirectSqlUtils.extractSqlLong((double)(MetastoreDirectSqlUtils.extractSqlLong(lhigh) - MetastoreDirectSqlUtils.extractSqlLong(llow)) / MetastoreDirectSqlUtils.extractSqlDouble(avgLong));
                if (estimation < lowerBound) {
                    estimation = lowerBound;
                } else if (estimation > higherBound) {
                    estimation = higherBound;
                }
            } else {
                estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner);
            }
            estimation = Math.min(estimation, rangeBound);
            longStats.setNumDVs(estimation);
            data.setLongStats((LongColumnStatsData)longStats);
        } else if (colType.equals("date")) {
            long estimation;
            DateColumnStatsDataInspector dateStats = new DateColumnStatsDataInspector();
            dateStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (lhigh != null) {
                dateStats.setHighValue(new Date(MetastoreDirectSqlUtils.extractSqlLong(lhigh).longValue()));
            }
            if (llow != null) {
                dateStats.setLowValue(new Date(MetastoreDirectSqlUtils.extractSqlLong(llow).longValue()));
            }
            long lowerBound = MetastoreDirectSqlUtils.extractSqlLong(dist);
            long higherBound = MetastoreDirectSqlUtils.extractSqlLong(sumDist);
            long rangeBound = Long.MAX_VALUE;
            if (lhigh != null && llow != null) {
                rangeBound = MetastoreDirectSqlUtils.extractSqlLong(lhigh) - MetastoreDirectSqlUtils.extractSqlLong(llow) + 1L;
            }
            if (useDensityFunctionForNDVEstimation && lhigh != null && llow != null && avgLong != null && MetastoreDirectSqlUtils.extractSqlDouble(avgLong) != 0.0) {
                estimation = MetastoreDirectSqlUtils.extractSqlLong((double)(MetastoreDirectSqlUtils.extractSqlLong(lhigh) - MetastoreDirectSqlUtils.extractSqlLong(llow)) / MetastoreDirectSqlUtils.extractSqlDouble(avgLong));
                if (estimation < lowerBound) {
                    estimation = lowerBound;
                } else if (estimation > higherBound) {
                    estimation = higherBound;
                }
            } else {
                estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner);
            }
            estimation = Math.min(estimation, rangeBound);
            dateStats.setNumDVs(estimation);
            data.setDateStats((DateColumnStatsData)dateStats);
        } else if (colType.equals("timestamp")) {
            long estimation;
            TimestampColumnStatsDataInspector timestampStats = new TimestampColumnStatsDataInspector();
            timestampStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (lhigh != null) {
                timestampStats.setHighValue(new Timestamp(MetastoreDirectSqlUtils.extractSqlLong(lhigh).longValue()));
            }
            if (llow != null) {
                timestampStats.setLowValue(new Timestamp(MetastoreDirectSqlUtils.extractSqlLong(llow).longValue()));
            }
            long lowerBound = MetastoreDirectSqlUtils.extractSqlLong(dist);
            long higherBound = MetastoreDirectSqlUtils.extractSqlLong(sumDist);
            long rangeBound = Long.MAX_VALUE;
            if (lhigh != null && llow != null) {
                rangeBound = MetastoreDirectSqlUtils.extractSqlLong(lhigh) - MetastoreDirectSqlUtils.extractSqlLong(llow) + 1L;
            }
            if (useDensityFunctionForNDVEstimation && lhigh != null && llow != null && avgLong != null && MetastoreDirectSqlUtils.extractSqlDouble(avgLong) != 0.0) {
                estimation = MetastoreDirectSqlUtils.extractSqlLong((double)(MetastoreDirectSqlUtils.extractSqlLong(lhigh) - MetastoreDirectSqlUtils.extractSqlLong(llow)) / MetastoreDirectSqlUtils.extractSqlDouble(avgLong));
                if (estimation < lowerBound) {
                    estimation = lowerBound;
                } else if (estimation > higherBound) {
                    estimation = higherBound;
                }
            } else {
                estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner);
            }
            estimation = Math.min(estimation, rangeBound);
            timestampStats.setNumDVs(estimation);
            data.setTimestampStats((TimestampColumnStatsData)timestampStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            DoubleColumnStatsDataInspector doubleStats = new DoubleColumnStatsDataInspector();
            doubleStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            if (dhigh != null) {
                doubleStats.setHighValue(MetastoreDirectSqlUtils.extractSqlDouble(dhigh));
            }
            if (dlow != null) {
                doubleStats.setLowValue(MetastoreDirectSqlUtils.extractSqlDouble(dlow));
            }
            long lowerBound = MetastoreDirectSqlUtils.extractSqlLong(dist);
            long higherBound = MetastoreDirectSqlUtils.extractSqlLong(sumDist);
            if (useDensityFunctionForNDVEstimation && dhigh != null && dlow != null && avgDouble != null && MetastoreDirectSqlUtils.extractSqlDouble(avgDouble) != 0.0) {
                long estimation = MetastoreDirectSqlUtils.extractSqlLong((double)(MetastoreDirectSqlUtils.extractSqlLong(dhigh) - MetastoreDirectSqlUtils.extractSqlLong(dlow)) / MetastoreDirectSqlUtils.extractSqlDouble(avgDouble));
                if (estimation < lowerBound) {
                    doubleStats.setNumDVs(lowerBound);
                } else if (estimation > higherBound) {
                    doubleStats.setNumDVs(higherBound);
                } else {
                    doubleStats.setNumDVs(estimation);
                }
            } else {
                doubleStats.setNumDVs((long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner));
            }
            data.setDoubleStats((DoubleColumnStatsData)doubleStats);
        } else if (colType.startsWith("decimal")) {
            DecimalColumnStatsDataInspector decimalStats = new DecimalColumnStatsDataInspector();
            decimalStats.setNumNulls(MetastoreDirectSqlUtils.extractSqlLong(nulls));
            Decimal low = null;
            Decimal high = null;
            BigDecimal blow = null;
            BigDecimal bhigh = null;
            if (dechigh instanceof BigDecimal) {
                bhigh = (BigDecimal)dechigh;
                high = DecimalUtils.getDecimal(ByteBuffer.wrap(bhigh.unscaledValue().toByteArray()), (short)bhigh.scale());
            } else if (dechigh instanceof String) {
                bhigh = new BigDecimal((String)dechigh);
                high = DecimalUtils.createThriftDecimal((String)dechigh);
            }
            decimalStats.setHighValue(high);
            if (declow instanceof BigDecimal) {
                blow = (BigDecimal)declow;
                low = DecimalUtils.getDecimal(ByteBuffer.wrap(blow.unscaledValue().toByteArray()), (short)blow.scale());
            } else if (dechigh instanceof String) {
                blow = new BigDecimal((String)declow);
                low = DecimalUtils.createThriftDecimal((String)declow);
            }
            decimalStats.setLowValue(low);
            long lowerBound = MetastoreDirectSqlUtils.extractSqlLong(dist);
            long higherBound = MetastoreDirectSqlUtils.extractSqlLong(sumDist);
            if (useDensityFunctionForNDVEstimation && dechigh != null && declow != null && avgDecimal != null && MetastoreDirectSqlUtils.extractSqlDouble(avgDecimal) != 0.0) {
                long estimation = MetastoreDirectSqlUtils.extractSqlLong(MetastoreDirectSqlUtils.extractSqlLong((double)bhigh.subtract(blow).floatValue() / MetastoreDirectSqlUtils.extractSqlDouble(avgDecimal)));
                if (estimation < lowerBound) {
                    decimalStats.setNumDVs(lowerBound);
                } else if (estimation > higherBound) {
                    decimalStats.setNumDVs(higherBound);
                } else {
                    decimalStats.setNumDVs(estimation);
                }
            } else {
                decimalStats.setNumDVs((long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner));
            }
            data.setDecimalStats((DecimalColumnStatsData)decimalStats);
        }
    }

    public static void setFieldsIntoOldStats(ColumnStatisticsObj oldStatObj, ColumnStatisticsObj newStatObj) {
        ColumnStatisticsData._Fields typeOld;
        ColumnStatisticsData._Fields typeNew = (ColumnStatisticsData._Fields)newStatObj.getStatsData().getSetField();
        typeNew = typeNew == (typeOld = (ColumnStatisticsData._Fields)oldStatObj.getStatsData().getSetField()) ? typeNew : null;
        switch (typeNew) {
            case BOOLEAN_STATS: {
                BooleanColumnStatsData oldBooleanStatsData = oldStatObj.getStatsData().getBooleanStats();
                BooleanColumnStatsData newBooleanStatsData = newStatObj.getStatsData().getBooleanStats();
                if (newBooleanStatsData.isSetNumTrues()) {
                    oldBooleanStatsData.setNumTrues(newBooleanStatsData.getNumTrues());
                }
                if (newBooleanStatsData.isSetNumFalses()) {
                    oldBooleanStatsData.setNumFalses(newBooleanStatsData.getNumFalses());
                }
                if (newBooleanStatsData.isSetNumNulls()) {
                    oldBooleanStatsData.setNumNulls(newBooleanStatsData.getNumNulls());
                }
                if (!newBooleanStatsData.isSetBitVectors()) break;
                oldBooleanStatsData.setBitVectors(newBooleanStatsData.getBitVectors());
                break;
            }
            case LONG_STATS: {
                LongColumnStatsData oldLongStatsData = oldStatObj.getStatsData().getLongStats();
                LongColumnStatsData newLongStatsData = newStatObj.getStatsData().getLongStats();
                if (newLongStatsData.isSetHighValue()) {
                    oldLongStatsData.setHighValue(newLongStatsData.getHighValue());
                }
                if (newLongStatsData.isSetLowValue()) {
                    oldLongStatsData.setLowValue(newLongStatsData.getLowValue());
                }
                if (newLongStatsData.isSetNumNulls()) {
                    oldLongStatsData.setNumNulls(newLongStatsData.getNumNulls());
                }
                if (newLongStatsData.isSetNumDVs()) {
                    oldLongStatsData.setNumDVs(newLongStatsData.getNumDVs());
                }
                if (!newLongStatsData.isSetBitVectors()) break;
                oldLongStatsData.setBitVectors(newLongStatsData.getBitVectors());
                break;
            }
            case DOUBLE_STATS: {
                DoubleColumnStatsData oldDoubleStatsData = oldStatObj.getStatsData().getDoubleStats();
                DoubleColumnStatsData newDoubleStatsData = newStatObj.getStatsData().getDoubleStats();
                if (newDoubleStatsData.isSetHighValue()) {
                    oldDoubleStatsData.setHighValue(newDoubleStatsData.getHighValue());
                }
                if (newDoubleStatsData.isSetLowValue()) {
                    oldDoubleStatsData.setLowValue(newDoubleStatsData.getLowValue());
                }
                if (newDoubleStatsData.isSetNumNulls()) {
                    oldDoubleStatsData.setNumNulls(newDoubleStatsData.getNumNulls());
                }
                if (newDoubleStatsData.isSetNumDVs()) {
                    oldDoubleStatsData.setNumDVs(newDoubleStatsData.getNumDVs());
                }
                if (!newDoubleStatsData.isSetBitVectors()) break;
                oldDoubleStatsData.setBitVectors(newDoubleStatsData.getBitVectors());
                break;
            }
            case STRING_STATS: {
                StringColumnStatsData oldStringStatsData = oldStatObj.getStatsData().getStringStats();
                StringColumnStatsData newStringStatsData = newStatObj.getStatsData().getStringStats();
                if (newStringStatsData.isSetMaxColLen()) {
                    oldStringStatsData.setMaxColLen(newStringStatsData.getMaxColLen());
                }
                if (newStringStatsData.isSetAvgColLen()) {
                    oldStringStatsData.setAvgColLen(newStringStatsData.getAvgColLen());
                }
                if (newStringStatsData.isSetNumNulls()) {
                    oldStringStatsData.setNumNulls(newStringStatsData.getNumNulls());
                }
                if (newStringStatsData.isSetNumDVs()) {
                    oldStringStatsData.setNumDVs(newStringStatsData.getNumDVs());
                }
                if (!newStringStatsData.isSetBitVectors()) break;
                oldStringStatsData.setBitVectors(newStringStatsData.getBitVectors());
                break;
            }
            case BINARY_STATS: {
                BinaryColumnStatsData oldBinaryStatsData = oldStatObj.getStatsData().getBinaryStats();
                BinaryColumnStatsData newBinaryStatsData = newStatObj.getStatsData().getBinaryStats();
                if (newBinaryStatsData.isSetMaxColLen()) {
                    oldBinaryStatsData.setMaxColLen(newBinaryStatsData.getMaxColLen());
                }
                if (newBinaryStatsData.isSetAvgColLen()) {
                    oldBinaryStatsData.setAvgColLen(newBinaryStatsData.getAvgColLen());
                }
                if (newBinaryStatsData.isSetNumNulls()) {
                    oldBinaryStatsData.setNumNulls(newBinaryStatsData.getNumNulls());
                }
                if (!newBinaryStatsData.isSetBitVectors()) break;
                oldBinaryStatsData.setBitVectors(newBinaryStatsData.getBitVectors());
                break;
            }
            case DECIMAL_STATS: {
                DecimalColumnStatsData oldDecimalStatsData = oldStatObj.getStatsData().getDecimalStats();
                DecimalColumnStatsData newDecimalStatsData = newStatObj.getStatsData().getDecimalStats();
                if (newDecimalStatsData.isSetHighValue()) {
                    oldDecimalStatsData.setHighValue(newDecimalStatsData.getHighValue());
                }
                if (newDecimalStatsData.isSetLowValue()) {
                    oldDecimalStatsData.setLowValue(newDecimalStatsData.getLowValue());
                }
                if (newDecimalStatsData.isSetNumNulls()) {
                    oldDecimalStatsData.setNumNulls(newDecimalStatsData.getNumNulls());
                }
                if (newDecimalStatsData.isSetNumDVs()) {
                    oldDecimalStatsData.setNumDVs(newDecimalStatsData.getNumDVs());
                }
                if (!newDecimalStatsData.isSetBitVectors()) break;
                oldDecimalStatsData.setBitVectors(newDecimalStatsData.getBitVectors());
                break;
            }
            case DATE_STATS: {
                DateColumnStatsData oldDateStatsData = oldStatObj.getStatsData().getDateStats();
                DateColumnStatsData newDateStatsData = newStatObj.getStatsData().getDateStats();
                if (newDateStatsData.isSetHighValue()) {
                    oldDateStatsData.setHighValue(newDateStatsData.getHighValue());
                }
                if (newDateStatsData.isSetLowValue()) {
                    oldDateStatsData.setLowValue(newDateStatsData.getLowValue());
                }
                if (newDateStatsData.isSetNumNulls()) {
                    oldDateStatsData.setNumNulls(newDateStatsData.getNumNulls());
                }
                if (newDateStatsData.isSetNumDVs()) {
                    oldDateStatsData.setNumDVs(newDateStatsData.getNumDVs());
                }
                if (!newDateStatsData.isSetBitVectors()) break;
                oldDateStatsData.setBitVectors(newDateStatsData.getBitVectors());
                break;
            }
            case TIMESTAMP_STATS: {
                TimestampColumnStatsData oldTimestampStatsData = oldStatObj.getStatsData().getTimestampStats();
                TimestampColumnStatsData newTimestampStatsData = newStatObj.getStatsData().getTimestampStats();
                if (newTimestampStatsData.isSetHighValue()) {
                    oldTimestampStatsData.setHighValue(newTimestampStatsData.getHighValue());
                }
                if (newTimestampStatsData.isSetLowValue()) {
                    oldTimestampStatsData.setLowValue(newTimestampStatsData.getLowValue());
                }
                if (newTimestampStatsData.isSetNumNulls()) {
                    oldTimestampStatsData.setNumNulls(newTimestampStatsData.getNumNulls());
                }
                if (newTimestampStatsData.isSetNumDVs()) {
                    oldTimestampStatsData.setNumDVs(newTimestampStatsData.getNumDVs());
                }
                if (!newTimestampStatsData.isSetBitVectors()) break;
                oldTimestampStatsData.setBitVectors(newTimestampStatsData.getBitVectors());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stats type: " + typeNew.toString());
            }
        }
    }
}

