/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeStatsCleanerTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeStatsCleanerTask.class);
    private Configuration conf;

    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.RUNTIME_STATS_CLEAN_FREQUENCY, (TimeUnit)unit);
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void run() {
        try {
            RawStore ms = HiveMetaStore.HMSHandler.getMSForConf(this.conf);
            int maxRetainSecs = (int)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.RUNTIME_STATS_MAX_AGE, (TimeUnit)TimeUnit.SECONDS);
            int deleteCnt = ms.deleteRuntimeStats(maxRetainSecs);
            if ((long)deleteCnt > 0L) {
                LOG.info("Number of deleted entries: " + deleteCnt);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while trying to delete: " + e.getMessage(), (Throwable)e);
        }
    }
}

