/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.FileNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreFS;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreFsImpl
implements MetaStoreFS {
    public static final Logger LOG = LoggerFactory.getLogger((String)"hive.metastore.hivemetastoreFsimpl");

    public boolean deleteDir(FileSystem fs, Path f, boolean recursive, boolean ifPurge, Configuration conf) throws MetaException {
        try {
            if (FileUtils.moveToTrash((FileSystem)fs, (Path)f, (Configuration)conf, (boolean)ifPurge)) {
                return true;
            }
            if (fs.exists(f)) {
                throw new MetaException("Unable to delete directory: " + f);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException((Exception)e);
            return false;
        }
    }
}

