/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;

public class AcidEventListener
extends MetaStoreEventListener {
    private TxnStore txnHandler;
    private Configuration conf;

    public AcidEventListener(Configuration configuration) {
        super(configuration);
        this.conf = configuration;
    }

    @Override
    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        this.txnHandler = this.getTxnHandler();
        this.txnHandler.cleanupRecords(HiveObjectType.DATABASE, dbEvent.getDatabase(), null, null);
    }

    @Override
    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        if (TxnUtils.isTransactionalTable(tableEvent.getTable())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.cleanupRecords(HiveObjectType.TABLE, null, tableEvent.getTable(), null);
        }
    }

    @Override
    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        if (TxnUtils.isTransactionalTable(partitionEvent.getTable())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.cleanupRecords(HiveObjectType.PARTITION, null, partitionEvent.getTable(), partitionEvent.getPartitionIterator());
        }
    }

    @Override
    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        if (!TxnUtils.isTransactionalTable(tableEvent.getNewTable())) {
            return;
        }
        Table oldTable = tableEvent.getOldTable();
        Table newTable = tableEvent.getNewTable();
        if (!(oldTable.getCatName().equalsIgnoreCase(newTable.getCatName()) && oldTable.getDbName().equalsIgnoreCase(newTable.getDbName()) && oldTable.getTableName().equalsIgnoreCase(newTable.getTableName()))) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(oldTable.getCatName(), oldTable.getDbName(), oldTable.getTableName(), null, newTable.getCatName(), newTable.getDbName(), newTable.getTableName(), null);
        }
    }

    @Override
    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
        String newPartName;
        if (!TxnUtils.isTransactionalTable(partitionEvent.getTable())) {
            return;
        }
        Partition oldPart = partitionEvent.getOldPartition();
        Partition newPart = partitionEvent.getNewPartition();
        Table t = partitionEvent.getTable();
        String oldPartName = Warehouse.makePartName((List)t.getPartitionKeys(), (List)oldPart.getValues());
        if (!oldPartName.equals(newPartName = Warehouse.makePartName((List)t.getPartitionKeys(), (List)newPart.getValues()))) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(t.getCatName(), t.getDbName(), t.getTableName(), oldPartName, t.getCatName(), t.getDbName(), t.getTableName(), newPartName);
        }
    }

    @Override
    public void onAlterDatabase(AlterDatabaseEvent dbEvent) throws MetaException {
        Database oldDb = dbEvent.getOldDatabase();
        Database newDb = dbEvent.getNewDatabase();
        if (!oldDb.getCatalogName().equalsIgnoreCase(newDb.getCatalogName()) || !oldDb.getName().equalsIgnoreCase(newDb.getName())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(oldDb.getCatalogName(), oldDb.getName(), null, null, newDb.getCatalogName(), newDb.getName(), null, null);
        }
    }

    private TxnStore getTxnHandler() {
        boolean hackOn = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST) || MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST);
        String origTxnMgr = null;
        boolean origConcurrency = false;
        if (hackOn) {
            origTxnMgr = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_TXN_MANAGER);
            origConcurrency = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        }
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
        if (hackOn) {
            MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_TXN_MANAGER, (String)origTxnMgr);
            MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)origConcurrency);
        }
        return this.txnHandler;
    }
}

