/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Visitor;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rules.FilterToCalcRule;
import org.apache.calcite.rel.rules.ProjectToCalcRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.ArrayBindable;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.runtime.Typed;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.tools.RelBuilder;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Fork(value=1, jvmArgsPrepend={"-Xmx1024m"})
@Measurement(iterations=10, time=1)
@Warmup(iterations=0)
@Threads(value=1)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.Throughput})
public class CodeGenerationBenchmark {
    @Benchmark
    public Bindable<?> getBindableNoCache(QueryState state) throws Exception {
        PlanInfo info = state.planInfos[state.nextPlan()];
        return (Bindable)info.cbe.createInstance((Reader)new StringReader(info.javaCode));
    }

    @Benchmark
    public Bindable<?> getBindableWithCache(QueryState jState, CacheState chState) throws Exception {
        PlanInfo info = jState.planInfos[jState.nextPlan()];
        Cache<String, Bindable> cache = chState.cache;
        EnumerableInterpretable.StaticFieldDetector detector = new EnumerableInterpretable.StaticFieldDetector();
        info.classExpr.accept((Visitor)detector);
        if (!detector.containsStaticField) {
            return (Bindable)cache.get((Object)info.javaCode, () -> (Bindable)info.cbe.createInstance((Reader)new StringReader(info.javaCode)));
        }
        throw new IllegalStateException("Benchmark queries should not arrive here");
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(CodeGenerationBenchmark.class.getName()).addProfiler(GCProfiler.class).detectJvmArgs().build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class CacheState {
        @Param(value={"10", "100", "1000"})
        int cacheSize;
        Cache<String, Bindable> cache;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.cache = CacheBuilder.newBuilder().maximumSize((long)this.cacheSize).concurrencyLevel(1).build();
        }
    }

    private static class PlanInfo {
        ClassDeclaration classExpr;
        IClassBodyEvaluator cbe;
        String javaCode;

        private PlanInfo() {
        }
    }

    @State(value=Scope.Thread)
    public static class QueryState {
        @Param(value={"1", "10", "100", "1000"})
        int queries;
        @Param(value={"1", "10", "20"})
        int joins;
        @Param(value={"1", "10", "100"})
        int whereClauseDisjunctions;
        PlanInfo[] planInfos;
        private int currentPlan = 0;

        @Setup(value=Level.Trial)
        public void setup() {
            this.planInfos = new PlanInfo[this.queries];
            VolcanoPlanner planner = new VolcanoPlanner();
            planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
            planner.addRule((RelOptRule)FilterToCalcRule.INSTANCE);
            planner.addRule((RelOptRule)ProjectToCalcRule.INSTANCE);
            planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_CALC_RULE);
            planner.addRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
            planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_VALUES_RULE);
            JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
            RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)typeFactory));
            RelTraitSet desiredTraits = cluster.traitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(cluster, null);
            for (int i = 0; i < this.queries; ++i) {
                Class[] classArray;
                ICompilerFactory compilerFactory;
                relBuilder.values(new String[]{"id", "name"}, new Object[]{1, "Value0"});
                for (int j = 1; j <= this.joins; ++j) {
                    relBuilder.values(new String[]{"id", "name"}, new Object[]{j, "Value" + j}).join(JoinRelType.INNER, new String[]{"id"});
                }
                ArrayList<RexNode> disjunctions = new ArrayList<RexNode>();
                for (int j = 0; j < this.whereClauseDisjunctions; ++j) {
                    disjunctions.add(relBuilder.equals((RexNode)relBuilder.field("name"), relBuilder.literal((Object)("name" + j))));
                }
                disjunctions.add(relBuilder.equals((RexNode)relBuilder.field("id"), relBuilder.literal((Object)i)));
                RelNode query = relBuilder.filter(new RexNode[]{relBuilder.or(disjunctions)}).project(new RexNode[]{relBuilder.field("name")}).build();
                RelNode query0 = planner.changeTraits(query, desiredTraits);
                planner.setRoot(query0);
                PlanInfo info = new PlanInfo();
                EnumerableRel plan = (EnumerableRel)planner.findBestExp();
                EnumerableRelImplementor relImplementor = new EnumerableRelImplementor(plan.getCluster().getRexBuilder(), new HashMap());
                info.classExpr = relImplementor.implementRoot(plan, EnumerableRel.Prefer.ARRAY);
                info.javaCode = Expressions.toString((List)info.classExpr.memberDeclarations, (String)"\n", (boolean)false);
                try {
                    compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to instantiate java compiler", e);
                }
                IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
                cbe.setClassName(info.classExpr.name);
                cbe.setExtendedClass(Utilities.class);
                if (plan.getRowType().getFieldCount() == 1) {
                    Class[] classArray2 = new Class[2];
                    classArray2[0] = Bindable.class;
                    classArray = classArray2;
                    classArray2[1] = Typed.class;
                } else {
                    Class[] classArray3 = new Class[1];
                    classArray = classArray3;
                    classArray3[0] = ArrayBindable.class;
                }
                cbe.setImplementedInterfaces(classArray);
                cbe.setParentClassLoader(EnumerableInterpretable.class.getClassLoader());
                info.cbe = cbe;
                this.planInfos[i] = info;
            }
        }

        int nextPlan() {
            int ret = this.currentPlan;
            this.currentPlan = (this.currentPlan + 1) % this.queries;
            return ret;
        }
    }
}

