/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.benchmarks;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.benchmarks.FlightRecorderProfiler;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=7, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=7, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class ParserBenchmark {
    @Param(value={"1000"})
    int length;
    @Param(value={"true"})
    boolean comments;
    String sql;
    SqlParser parser;

    @Setup
    public void setup() throws SqlParseException {
        StringBuilder sb = new StringBuilder((int)((double)this.length * 1.2));
        sb.append("select 1");
        Random rnd = new Random();
        rnd.setSeed(424242L);
        while (sb.length() < this.length) {
            block6: for (int i = 0; i < 7 && sb.length() < this.length; ++i) {
                sb.append(", ");
                switch (rnd.nextInt(3)) {
                    case 0: {
                        sb.append("?");
                        continue block6;
                    }
                    case 1: {
                        sb.append(rnd.nextInt());
                        continue block6;
                    }
                    case 2: {
                        sb.append('\'').append(rnd.nextLong()).append(rnd.nextLong()).append('\'');
                    }
                }
            }
            if (this.comments && sb.length() < this.length) {
                sb.append("// sb.append('\\'').append(rnd.nextLong()).append(rnd.nextLong()).append(rnd.nextLong())");
            }
            sb.append('\n');
        }
        sb.append(" from dual");
        this.parser = SqlParser.create((String)"values(1)");
        this.sql = sb.toString();
    }

    @Benchmark
    public SqlNode parseCached() throws SqlParseException {
        return this.parser.parseQuery(this.sql);
    }

    @Benchmark
    public SqlNode parseNonCached() throws SqlParseException {
        return SqlParser.create((String)this.sql).parseQuery();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ParserBenchmark.class.getSimpleName()).addProfiler(GCProfiler.class).addProfiler(FlightRecorderProfiler.class).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

