/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.splunk;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.splunk.SplunkPushDownRule;
import org.apache.calcite.adapter.splunk.SplunkTable;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.util.Util;

public class SplunkTableScan
extends TableScan
implements EnumerableRel {
    final SplunkTable splunkTable;
    final String search;
    final String earliest;
    final String latest;
    final List<String> fieldList;
    private static final Method METHOD = Types.lookupMethod(SplunkTable.SplunkTableQueryable.class, (String)"createQuery", (Class[])new Class[]{String.class, String.class, String.class, List.class});

    protected SplunkTableScan(RelOptCluster cluster, RelOptTable table, SplunkTable splunkTable, String search, String earliest, String latest, List<String> fieldList) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), table);
        this.splunkTable = splunkTable;
        this.search = search;
        this.earliest = earliest;
        this.latest = latest;
        this.fieldList = fieldList;
        assert (splunkTable != null);
        assert (search != null);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", (Object)this.table.getQualifiedName()).item("earliest", (Object)this.earliest).item("latest", (Object)this.latest).item("fieldList", this.fieldList);
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)SplunkPushDownRule.FILTER);
        planner.addRule((RelOptRule)SplunkPushDownRule.FILTER_ON_PROJECT);
        planner.addRule((RelOptRule)SplunkPushDownRule.PROJECT);
        planner.addRule((RelOptRule)SplunkPushDownRule.PROJECT_ON_FILTER);
    }

    public RelDataType deriveRowType() {
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (String field : this.fieldList) {
            builder.add(this.table.getRowType().getField(field, true, false));
        }
        return builder.build();
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ImmutableMap map = ImmutableMap.builder().put((Object)"search", (Object)this.search).put((Object)"earliest", Util.first((Object)this.earliest, (Object)"")).put((Object)"latest", Util.first((Object)this.latest, (Object)"")).put((Object)"fieldList", this.fieldList).build();
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            System.out.println("Splunk: " + map);
        }
        Hook.QUERY_PLAN.run((Object)map);
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferCustom());
        BlockBuilder builder = new BlockBuilder();
        return implementor.result(physType, builder.append((Expression)Expressions.call((Expression)this.table.getExpression(SplunkTable.SplunkTableQueryable.class), (Method)METHOD, (Expression[])new Expression[]{Expressions.constant((Object)this.search), Expressions.constant((Object)this.earliest), Expressions.constant((Object)this.latest), this.fieldList == null ? Expressions.constant(null) : SplunkTableScan.constantStringList(this.fieldList)})).toBlock());
    }

    private static Expression constantStringList(final List<String> strings) {
        return Expressions.call(Arrays.class, (String)"asList", (Expression[])new Expression[]{Expressions.newArrayInit(Object.class, (Iterable)new AbstractList<Expression>(){

            @Override
            public Expression get(int index) {
                return Expressions.constant(strings.get(index));
            }

            @Override
            public int size() {
                return strings.size();
            }
        })});
    }
}

