/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.splunk;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.splunk.search.SplunkConnection;
import org.apache.calcite.adapter.splunk.util.StringUtils;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;

public class SplunkQuery<T>
extends AbstractEnumerable<T> {
    private final SplunkConnection splunkConnection;
    private final String search;
    private final String earliest;
    private final String latest;
    private final List<String> fieldList;

    public SplunkQuery(SplunkConnection splunkConnection, String search, String earliest, String latest, List<String> fieldList) {
        this.splunkConnection = splunkConnection;
        this.search = search;
        this.earliest = earliest;
        this.latest = latest;
        this.fieldList = fieldList;
        assert (splunkConnection != null);
        assert (search != null);
    }

    public String toString() {
        return "SplunkQuery {" + this.search + "}";
    }

    public Enumerator<T> enumerator() {
        return this.splunkConnection.getSearchResultEnumerator(this.search, this.getArgs(), this.fieldList);
    }

    private Map<String, String> getArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.fieldList != null) {
            String fields = StringUtils.encodeList(this.fieldList, ',').toString();
            args.put("field_list", fields);
        }
        if (this.earliest != null) {
            args.put("earliest_time", this.earliest);
        }
        if (this.latest != null) {
            args.put("latest_time", this.latest);
        }
        return args;
    }
}

